/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.cave;

import com.terraforged.noise.Module;
import com.terraforged.noise.util.N2DUtil;
import com.terraforged.noise.util.NoiseUtil;
import com.terraforged.noise.util.Vec2f;
import java.awt.Color;

public class UniqueCaveDistributor
implements Module {
    private final int seed;
    private final float frequency;
    private final float jitter;
    private final float density;

    public UniqueCaveDistributor(int seed, float frequency, float jitter, float density) {
        this.seed = seed;
        this.frequency = frequency;
        this.jitter = jitter;
        this.density = density;
    }

    @Override
    public float getValue(float x, float y) {
        int maxX = NoiseUtil.floor(x *= this.frequency) + 1;
        int maxY = NoiseUtil.floor(y *= this.frequency) + 1;
        int cellX = maxX - 1;
        int cellY = maxY - 1;
        float distA = Float.POSITIVE_INFINITY;
        float distB = Float.POSITIVE_INFINITY;
        for (int cy = maxY - 2; cy <= maxY; ++cy) {
            float ox = (float)(cy & 1) * 0.5f;
            for (int cx = maxX - 2; cx <= maxX; ++cx) {
                Vec2f vec = NoiseUtil.cell(this.seed, cx, cy);
                float px = (float)cx + ox + vec.x * this.jitter;
                float py = (float)cy + vec.y * this.jitter;
                float d2 = NoiseUtil.dist2(x, y, px, py);
                if (d2 < distA) {
                    distB = distA;
                    distA = d2;
                    cellX = cx;
                    cellY = cy;
                    continue;
                }
                if (!(d2 < distB)) continue;
                distB = d2;
            }
        }
        if (this.cellValue(cellX, cellY) > this.density) {
            return 0.0f;
        }
        return 1.0f - NoiseUtil.sqrt(distA / distB);
    }

    private float cellValue(int cellX, int cellY) {
        float noise = NoiseUtil.valCoord2D(this.seed, cellX, cellY);
        return (1.0f + noise) * 0.5f;
    }

    public static void main(String[] args) {
        Module noise = new UniqueCaveDistributor(123, 0.01f, 0.75f, 0.1f).clamp(0.2, 1.0).map(0.0, 1.0).warp(12312, 30, 1, 20.0);
        N2DUtil.display(1000, 1000, (x, y, img) -> Color.HSBtoRGB(0.0f, 0.0f, noise.getValue(x, y))).setVisible(true);
    }
}

