/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.profiler;

import com.terraforged.mod.TerraForged;
import com.terraforged.mod.worldgen.profiler.GenStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ProfilerStages {
    private static final long INTERVAL_MS = TimeUnit.SECONDS.toMillis(10L);
    public final GenStage starts = new GenStage("starts    ");
    public final GenStage refs = new GenStage("refs      ");
    public final GenStage biomes = new GenStage("biomes    ");
    public final GenStage noise = new GenStage("noise/fill");
    public final GenStage carve = new GenStage("carve     ");
    public final GenStage surface = new GenStage("surface   ");
    public final GenStage decoration = new GenStage("decoration");
    private final long start = System.currentTimeMillis() + INTERVAL_MS * 2L;
    private final AtomicInteger chunkCount = new AtomicInteger();
    private final AtomicLong timestamp = new AtomicLong(0L);
    private final GenStage[] stages = new GenStage[]{this.starts, this.refs, this.biomes, this.noise, this.carve, this.surface, this.decoration};

    public void incrementChunks() {
        this.chunkCount.incrementAndGet();
    }

    public void reset() {
        this.timestamp.set(0L);
        this.chunkCount.set(0);
        for (GenStage stage : this.stages) {
            stage.reset();
        }
    }

    public void tick() {
        long time = this.timestamp.get();
        long now = System.currentTimeMillis();
        if (time == 0L) {
            this.timestamp.set(now + INTERVAL_MS * 2L);
            if (now > this.start) {
                this.reset();
            }
            return;
        }
        if (now > time && this.timestamp.compareAndSet(time, now + INTERVAL_MS)) {
            TerraForged.LOG.info("Timings:");
            double sumAverage = 0.0;
            for (GenStage stage : this.stages) {
                double average = stage.getAverageMS();
                sumAverage += average;
                average = ProfilerStages.trim(average, 100);
                TerraForged.LOG.info(" - {} = {}ms", (Object)stage.name(), (Object)average);
            }
            sumAverage = ProfilerStages.trim(sumAverage, 100);
            TerraForged.LOG.info(" Chunk Average = {}ms", (Object)sumAverage);
            TerraForged.LOG.info(" Chunk Count: =  {}", (Object)this.chunkCount.get());
        }
    }

    private static double trim(double d, int dp) {
        d = Math.round(d * (double)dp);
        return d / (double)dp;
    }
}

