/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.terrain;

import com.terraforged.mod.worldgen.noise.INoiseGenerator;
import com.terraforged.mod.worldgen.terrain.TerrainData;
import com.terraforged.mod.worldgen.terrain.TerrainGenerator;
import com.terraforged.mod.worldgen.terrain.TerrainLevels;
import com.terraforged.mod.worldgen.util.ThreadPool;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.jetbrains.annotations.Nullable;

public class TerrainCache {
    private final TerrainGenerator generator;
    private final Map<ChunkPos, CompletableFuture<TerrainData>> cache = new ConcurrentHashMap<ChunkPos, CompletableFuture<TerrainData>>();

    public TerrainCache(TerrainLevels levels, INoiseGenerator noiseGenerator) {
        this.generator = new TerrainGenerator(levels, noiseGenerator);
    }

    public void drop(ChunkPos pos) {
        CompletableFuture<TerrainData> task = this.cache.remove(pos);
        if (task == null || task.isDone()) {
            return;
        }
        this.generator.restore(task.join());
    }

    public void hint(ChunkPos pos) {
        this.getAsync(pos);
    }

    public int getHeight(int x, int z) {
        return this.generator.getHeight(x, z);
    }

    public TerrainData getNow(ChunkPos pos) {
        return this.getAsync(pos).join();
    }

    @Nullable
    public TerrainData getIfReady(ChunkPos pos) {
        CompletableFuture<TerrainData> task = this.cache.get(pos);
        if (task == null || !task.isDone()) {
            return null;
        }
        return task.join();
    }

    public CompletableFuture<TerrainData> getAsync(ChunkPos pos) {
        return this.cache.computeIfAbsent(pos, this::generate);
    }

    public <T> CompletableFuture<ChunkAccess> combineAsync(Executor executor, ChunkAccess chunk, BiFunction<ChunkAccess, TerrainData, ChunkAccess> function) {
        return this.getAsync(chunk.m_7697_()).thenApplyAsync(terrainData -> (ChunkAccess)function.apply(chunk, (TerrainData)terrainData), executor);
    }

    protected CompletableFuture<TerrainData> generate(ChunkPos pos) {
        return CompletableFuture.supplyAsync(() -> this.generator.generate(pos.f_45578_, pos.f_45579_), ThreadPool.EXECUTOR);
    }
}

