/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.terrain;

import com.terraforged.engine.world.terrain.Terrain;
import com.terraforged.mod.util.map.FloatMap;
import com.terraforged.mod.util.map.ObjectMap;
import com.terraforged.mod.worldgen.noise.NoiseData;
import com.terraforged.mod.worldgen.terrain.TerrainLevels;
import com.terraforged.noise.util.NoiseUtil;
import java.util.function.Consumer;

public class TerrainData
implements Consumer<NoiseData> {
    protected final TerrainLevels levels;
    protected final FloatMap height = new FloatMap();
    protected final FloatMap gradient = new FloatMap();
    protected final FloatMap water = new FloatMap();
    protected final ObjectMap<Terrain> terrain = new ObjectMap(Terrain[]::new);
    protected float min = Float.MAX_VALUE;
    protected float max = Float.MIN_VALUE;

    public TerrainData(TerrainLevels levels) {
        this.levels = levels;
    }

    public int getMin() {
        return this.levels.getHeight(this.min);
    }

    public int getMax() {
        return this.levels.getHeight(this.max);
    }

    public int getHeight(int x, int z) {
        float scaledHeight = this.height.get(x, z);
        return this.levels.getHeight(scaledHeight);
    }

    public TerrainLevels getLevels() {
        return this.levels;
    }

    public FloatMap getHeight() {
        return this.height;
    }

    public FloatMap getGradient() {
        return this.gradient;
    }

    public FloatMap getWater() {
        return this.water;
    }

    public ObjectMap<Terrain> getTerrain() {
        return this.terrain;
    }

    public float getGradient(int x, int z, float norm) {
        float grad = this.getGradient().get(x, z);
        return NoiseUtil.clamp(grad * norm, 0.0f, 1.0f);
    }

    @Override
    public void accept(NoiseData noiseData) {
        FloatMap noiseMap = noiseData.getHeight();
        ObjectMap<Terrain> terrainMap = noiseData.getTerrain();
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                float heightNoise = noiseMap.get(x, z);
                float scaledHeight = this.levels.getScaledHeight(heightNoise);
                Terrain terrainType = terrainMap.get(x, z);
                float n = noiseMap.get(x, z - 1);
                float s = noiseMap.get(x, z + 1);
                float e = noiseMap.get(x + 1, z);
                float w = noiseMap.get(x - 1, z);
                float dx = e - w;
                float dz = s - n;
                float grad = NoiseUtil.sqrt(dx * dx + dz * dz);
                float noiseGrad = NoiseUtil.clamp(grad, 0.0f, 1.0f);
                this.gradient.set(x, z, noiseGrad);
                this.terrain.set(x, z, terrainType);
                this.height.set(x, z, scaledHeight);
                this.water.set(x, z, noiseData.getWater().get(x, z));
                this.max = Math.max(this.max, scaledHeight);
                this.min = Math.min(this.min, scaledHeight);
            }
        }
    }
}

