/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.util;

import com.terraforged.mod.TerraForged;
import com.terraforged.mod.util.Init;
import java.util.Comparator;
import java.util.function.Supplier;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;

public class StructureReporter
extends Init {
    protected final Supplier<NoiseGeneratorSettings> settings;

    public StructureReporter(Supplier<NoiseGeneratorSettings> settings) {
        this.settings = settings;
    }

    @Override
    protected void doInit() {
        TerraForged.LOG.info("Validating structure configs:");
        StructureSettings structureSettings = this.settings.get().m_64457_();
        structureSettings.m_64590_().keySet().stream().sorted(Comparator.comparing(StructureFeature::m_67098_)).filter(s -> s != StructureFeature.f_67022_).filter(s -> structureSettings.m_189371_(s).isEmpty()).forEach(structure -> {
            String name = structure.m_67098_();
            String mod = StructureReporter.getNamespace(name);
            TerraForged.LOG.error("- [{}] Invalid - Structure has not been assigned to any biomes so it cannot generate. Mod: {}", (Object)name, (Object)mod);
        });
    }

    private static String getNamespace(String name) {
        int colon = name.indexOf(58);
        return colon > -1 ? name.substring(0, colon) : "unknown";
    }
}

