/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import mezz.jei.util.Translator;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;

public final class KeyBindings {
    private static final String overlaysCategoryName;
    private static final String mouseHoverCategoryName;
    private static final String cheatModeCategoryName;
    private static final String hoverConfigButtonCategoryName;
    private static final String editModeCategoryName;
    private static final String recipeCategoryName;
    private static final String searchCategoryName;
    private static final String jeiHiddenInternalCategoryName = "jei.key.category.hidden.internal";
    public static final KeyMapping toggleOverlay;
    public static final KeyMapping focusSearch;
    public static final KeyMapping toggleCheatMode;
    public static final KeyMapping toggleEditMode;
    public static final KeyMapping toggleCheatModeConfigButton;
    public static final KeyMapping recipeBack;
    public static final KeyMapping previousCategory;
    public static final KeyMapping nextCategory;
    public static final KeyMapping previousRecipePage;
    public static final KeyMapping nextRecipePage;
    public static final KeyMapping previousPage;
    public static final KeyMapping nextPage;
    public static final KeyMapping bookmark;
    public static final KeyMapping toggleBookmarkOverlay;
    public static final List<KeyMapping> showRecipe;
    public static final List<KeyMapping> showUses;
    public static final List<KeyMapping> cheatOneItem;
    public static final List<KeyMapping> cheatItemStack;
    public static final KeyMapping toggleHideIngredient;
    public static final KeyMapping toggleWildcardHideIngredient;
    public static final KeyMapping hoveredClearSearchBar;
    public static final KeyMapping previousSearch;
    public static final KeyMapping nextSearch;
    private static final List<KeyMapping> allBindings;
    public static final KeyMapping escapeKey;
    public static final KeyMapping leftClick;
    public static final KeyMapping rightClick;
    public static final List<KeyMapping> enterKey;
    public static final KeyMapping reloadJeiOverTextFilter;

    static InputConstants.Key getKey(int key) {
        return InputConstants.Type.KEYSYM.m_84895_(key);
    }

    private KeyBindings() {
    }

    public static void init() {
        for (KeyMapping binding : allBindings) {
            ClientRegistry.registerKeyBinding((KeyMapping)binding);
        }
    }

    static {
        KeyMapping cheatItemStack2;
        KeyMapping cheatItemStack1;
        KeyMapping cheatOneItem2;
        KeyMapping cheatOneItem1;
        KeyMapping showUses2;
        KeyMapping showUses1;
        KeyMapping showRecipe2;
        KeyMapping showRecipe1;
        overlaysCategoryName = Translator.translateToLocal("jei.key.category.overlays");
        mouseHoverCategoryName = Translator.translateToLocal("jei.key.category.mouse.hover");
        cheatModeCategoryName = Translator.translateToLocal("jei.key.category.cheat.mode");
        hoverConfigButtonCategoryName = Translator.translateToLocal("jei.key.category.hover.config.button");
        editModeCategoryName = Translator.translateToLocal("jei.key.category.edit.mode");
        recipeCategoryName = Translator.translateToLocal("jei.key.category.recipe.gui");
        searchCategoryName = Translator.translateToLocal("jei.key.category.search");
        toggleOverlay = new KeyMapping("key.jei.toggleOverlay", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.CONTROL, KeyBindings.getKey(79), overlaysCategoryName);
        allBindings = List.of(toggleOverlay, focusSearch = new KeyMapping("key.jei.focusSearch", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.CONTROL, KeyBindings.getKey(70), overlaysCategoryName), previousPage = new KeyMapping("key.jei.previousPage", (IKeyConflictContext)KeyConflictContext.GUI, KeyBindings.getKey(-1), overlaysCategoryName), nextPage = new KeyMapping("key.jei.nextPage", (IKeyConflictContext)KeyConflictContext.GUI, KeyBindings.getKey(-1), overlaysCategoryName), toggleBookmarkOverlay = new KeyMapping("key.jei.toggleBookmarkOverlay", (IKeyConflictContext)KeyConflictContext.GUI, KeyBindings.getKey(-1), overlaysCategoryName), bookmark = new KeyMapping("key.jei.bookmark", (IKeyConflictContext)JeiConflictContexts.JEI_GUI_HOVER, KeyBindings.getKey(65), mouseHoverCategoryName), showRecipe1 = new KeyMapping("key.jei.showRecipe", (IKeyConflictContext)JeiConflictContexts.JEI_GUI_HOVER, KeyBindings.getKey(82), mouseHoverCategoryName), showRecipe2 = new KeyMapping("key.jei.showRecipe2", (IKeyConflictContext)JeiConflictContexts.JEI_GUI_HOVER, InputConstants.Type.MOUSE, 0, mouseHoverCategoryName), showUses1 = new KeyMapping("key.jei.showUses", (IKeyConflictContext)JeiConflictContexts.JEI_GUI_HOVER, KeyBindings.getKey(85), mouseHoverCategoryName), showUses2 = new KeyMapping("key.jei.showUses2", (IKeyConflictContext)JeiConflictContexts.JEI_GUI_HOVER, InputConstants.Type.MOUSE, 1, mouseHoverCategoryName), hoveredClearSearchBar = new KeyMapping("key.jei.clearSearchBar", (IKeyConflictContext)JeiConflictContexts.JEI_GUI_HOVER_SEARCH, InputConstants.Type.MOUSE, 1, searchCategoryName), previousSearch = new KeyMapping("key.jei.previousSearch", (IKeyConflictContext)KeyConflictContext.GUI, KeyBindings.getKey(265), searchCategoryName), nextSearch = new KeyMapping("key.jei.nextSearch", (IKeyConflictContext)KeyConflictContext.GUI, KeyBindings.getKey(264), searchCategoryName), toggleCheatMode = new KeyMapping("key.jei.toggleCheatMode", (IKeyConflictContext)KeyConflictContext.GUI, KeyBindings.getKey(-1), cheatModeCategoryName), cheatOneItem1 = new KeyMapping("key.jei.cheatOneItem", (IKeyConflictContext)JeiConflictContexts.JEI_GUI_HOVER_CHEAT_MODE, InputConstants.Type.MOUSE, 0, cheatModeCategoryName), cheatOneItem2 = new KeyMapping("key.jei.cheatOneItem2", (IKeyConflictContext)JeiConflictContexts.JEI_GUI_HOVER_CHEAT_MODE, InputConstants.Type.MOUSE, 1, cheatModeCategoryName), cheatItemStack1 = new KeyMapping("key.jei.cheatItemStack", (IKeyConflictContext)JeiConflictContexts.JEI_GUI_HOVER_CHEAT_MODE, KeyModifier.SHIFT, InputConstants.Type.MOUSE, 0, cheatModeCategoryName), cheatItemStack2 = new KeyMapping("key.jei.cheatItemStack2", (IKeyConflictContext)JeiConflictContexts.JEI_GUI_HOVER_CHEAT_MODE, InputConstants.Type.MOUSE, 2, cheatModeCategoryName), toggleCheatModeConfigButton = new KeyMapping("key.jei.toggleCheatModeConfigButton", (IKeyConflictContext)JeiConflictContexts.JEI_GUI_HOVER_CONFIG_BUTTON, KeyModifier.CONTROL, InputConstants.Type.MOUSE, 0, hoverConfigButtonCategoryName), toggleEditMode = new KeyMapping("key.jei.toggleEditMode", (IKeyConflictContext)KeyConflictContext.GUI, KeyBindings.getKey(-1), editModeCategoryName), toggleHideIngredient = new KeyMapping("key.jei.toggleHideIngredient", (IKeyConflictContext)JeiConflictContexts.JEI_GUI_HOVER, KeyModifier.CONTROL, InputConstants.Type.MOUSE, 0, editModeCategoryName), toggleWildcardHideIngredient = new KeyMapping("key.jei.toggleWildcardHideIngredient", (IKeyConflictContext)JeiConflictContexts.JEI_GUI_HOVER, KeyModifier.CONTROL, InputConstants.Type.MOUSE, 1, editModeCategoryName), recipeBack = new KeyMapping("key.jei.recipeBack", (IKeyConflictContext)KeyConflictContext.GUI, KeyBindings.getKey(259), recipeCategoryName), previousRecipePage = new KeyMapping("key.jei.previousRecipePage", (IKeyConflictContext)KeyConflictContext.GUI, KeyBindings.getKey(266), recipeCategoryName), nextRecipePage = new KeyMapping("key.jei.nextRecipePage", (IKeyConflictContext)KeyConflictContext.GUI, KeyBindings.getKey(267), recipeCategoryName), previousCategory = new KeyMapping("key.jei.previousCategory", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.SHIFT, KeyBindings.getKey(266), recipeCategoryName), nextCategory = new KeyMapping("key.jei.nextCategory", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.SHIFT, KeyBindings.getKey(267), recipeCategoryName));
        showRecipe = List.of(showRecipe1, showRecipe2);
        showUses = List.of(showUses1, showUses2);
        cheatOneItem = List.of(cheatOneItem1, cheatOneItem2);
        cheatItemStack = List.of(cheatItemStack1, cheatItemStack2);
        escapeKey = new KeyMapping("key.jei.internal.escape.key", (IKeyConflictContext)KeyConflictContext.GUI, KeyBindings.getKey(256), jeiHiddenInternalCategoryName);
        leftClick = new KeyMapping("key.jei.internal.left.click", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.MOUSE, 0, jeiHiddenInternalCategoryName);
        rightClick = new KeyMapping("key.jei.internal.right.click", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.MOUSE, 1, jeiHiddenInternalCategoryName);
        enterKey = List.of(new KeyMapping("key.jei.internal.enter.key", (IKeyConflictContext)KeyConflictContext.GUI, KeyBindings.getKey(257), jeiHiddenInternalCategoryName), new KeyMapping("key.jei.internal.enter.key2", (IKeyConflictContext)KeyConflictContext.GUI, KeyBindings.getKey(335), jeiHiddenInternalCategoryName));
        reloadJeiOverTextFilter = new KeyMapping("key.jei.internal.debug.reload", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.SHIFT, KeyBindings.getKey(301), jeiHiddenInternalCategoryName);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum JeiConflictContexts implements IKeyConflictContext
    {
        JEI_GUI_HOVER{

            public boolean isActive() {
                return KeyConflictContext.GUI.isActive();
            }

            public boolean conflicts(IKeyConflictContext other) {
                return this == other;
            }
        }
        ,
        JEI_GUI_HOVER_CHEAT_MODE{

            public boolean isActive() {
                return KeyConflictContext.GUI.isActive();
            }

            public boolean conflicts(IKeyConflictContext other) {
                return this == other;
            }
        }
        ,
        JEI_GUI_HOVER_CONFIG_BUTTON{

            public boolean isActive() {
                return KeyConflictContext.GUI.isActive();
            }

            public boolean conflicts(IKeyConflictContext other) {
                return this == other;
            }
        }
        ,
        JEI_GUI_HOVER_SEARCH{

            public boolean isActive() {
                return KeyConflictContext.GUI.isActive();
            }

            public boolean conflicts(IKeyConflictContext other) {
                return this == other;
            }
        };

    }
}

