/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.Internal;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.gui.textures.Textures;
import mezz.jei.input.IPaged;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.CombinedInputHandler;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.Tuple;

public class PageNavigation {
    private final IPaged paged;
    private final GuiIconButton nextButton;
    private final GuiIconButton backButton;
    private final boolean hideOnSinglePage;
    private String pageNumDisplayString = "1/1";
    private int pageNumDisplayX;
    private int pageNumDisplayY;
    private Rect2i area = new Rect2i(0, 0, 0, 0);

    public PageNavigation(IPaged paged, boolean hideOnSinglePage) {
        this.paged = paged;
        Textures textures = Internal.getTextures();
        this.nextButton = new GuiIconButton(textures.getArrowNext(), b -> paged.nextPage());
        this.backButton = new GuiIconButton(textures.getArrowPrevious(), b -> paged.previousPage());
        this.hideOnSinglePage = hideOnSinglePage;
    }

    public void updateBounds(Rect2i area) {
        this.area = area;
        int buttonSize = area.m_110091_();
        Tuple<Rect2i, Rect2i> result = MathUtil.splitX(area, buttonSize);
        this.backButton.updateBounds((Rect2i)result.m_14418_());
        result = MathUtil.splitXRight(area, buttonSize);
        this.nextButton.updateBounds((Rect2i)result.m_14419_());
    }

    public void updatePageState() {
        int pageNum = this.paged.getPageNumber();
        int pageCount = this.paged.getPageCount();
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        this.pageNumDisplayString = pageNum + 1 + "/" + pageCount;
        Rect2i centerArea = MathUtil.centerTextArea(this.area, fontRenderer, this.pageNumDisplayString);
        this.pageNumDisplayX = centerArea.m_110085_();
        this.pageNumDisplayY = centerArea.m_110086_();
    }

    public void draw(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.hideOnSinglePage || this.paged.hasNext() || this.paged.hasPrevious()) {
            minecraft.f_91062_.m_92750_(poseStack, this.pageNumDisplayString, (float)this.pageNumDisplayX, (float)this.pageNumDisplayY, -1);
            this.nextButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            this.backButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public IUserInputHandler createInputHandler() {
        return new CombinedInputHandler(this.nextButton.createInputHandler(), this.backButton.createInputHandler());
    }
}

