/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients.adapters;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.gui.ingredients.RecipeSlot;
import org.jetbrains.annotations.Nullable;

public class RecipeSlotGuiIngredientAdapter<T>
implements IGuiIngredient<T> {
    private final RecipeSlot recipeSlot;
    private final IIngredientType<T> ingredientType;

    public RecipeSlotGuiIngredientAdapter(RecipeSlot recipeSlot, IIngredientType<T> ingredientType) {
        this.recipeSlot = recipeSlot;
        this.ingredientType = ingredientType;
    }

    @Override
    public IIngredientType<T> getIngredientType() {
        return this.ingredientType;
    }

    @Override
    @Nullable
    public T getDisplayedIngredient() {
        return this.recipeSlot.getDisplayedIngredient(this.ingredientType).orElse(null);
    }

    @Override
    public List<T> getAllIngredients() {
        return this.recipeSlot.getIngredients(this.ingredientType).toList();
    }

    @Override
    public void drawHighlight(PoseStack stack, int color, int xOffset, int yOffset) {
        stack.m_85836_();
        stack.m_85837_((double)xOffset, (double)yOffset, 0.0);
        this.recipeSlot.drawHighlight(stack, color);
        stack.m_85849_();
    }

    @Override
    public boolean isInput() {
        RecipeIngredientRole role = this.recipeSlot.getRole();
        return switch (role) {
            default -> throw new IncompatibleClassChangeError();
            case RecipeIngredientRole.INPUT, RecipeIngredientRole.CATALYST -> true;
            case RecipeIngredientRole.OUTPUT, RecipeIngredientRole.RENDER_ONLY -> false;
        };
    }

    public RecipeSlot getRecipeSlot() {
        return this.recipeSlot;
    }
}

