/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.ingredients.RecipeSlot;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IRecipeFocusSource;
import mezz.jei.util.MathUtil;
import net.minecraft.client.renderer.Rect2i;
import org.jetbrains.annotations.Nullable;

public class RecipeCatalysts
implements IRecipeFocusSource {
    private static final int ingredientSize = 16;
    private static final int ingredientBorderSize = 1;
    private static final int borderSize = 5;
    private static final int overlapSize = 6;
    private final DrawableNineSliceTexture backgroundTab;
    private final List<RecipeSlot> recipeSlots = new ArrayList<RecipeSlot>();
    private final DrawableNineSliceTexture slotBackground;
    private int left = 0;
    private int top = 0;
    private int width = 0;
    private int height = 0;

    public RecipeCatalysts() {
        Textures textures = Internal.getTextures();
        this.backgroundTab = textures.getCatalystTab();
        this.slotBackground = textures.getNineSliceSlot();
    }

    public boolean isEmpty() {
        return this.recipeSlots.isEmpty();
    }

    public int getWidth() {
        return this.width - 6;
    }

    public void updateLayout(List<ITypedIngredient<?>> ingredients, RecipesGui recipesGui) {
        this.recipeSlots.clear();
        if (!ingredients.isEmpty()) {
            Rect2i recipeArea = recipesGui.getArea();
            int availableHeight = recipeArea.m_110091_() - 8;
            int borderHeight = 12;
            int maxIngredientsPerColumn = (availableHeight - borderHeight) / 16;
            int columnCount = MathUtil.divideCeil(ingredients.size(), maxIngredientsPerColumn);
            maxIngredientsPerColumn = MathUtil.divideCeil(ingredients.size(), columnCount);
            this.width = 12 + columnCount * 16;
            this.height = 12 + maxIngredientsPerColumn * 16;
            this.top = recipeArea.m_110086_();
            this.left = recipeArea.m_110085_() - this.width + 6;
            for (int i = 0; i < ingredients.size(); ++i) {
                ITypedIngredient<?> ingredientForSlot = ingredients.get(i);
                RecipeSlot recipeSlot = this.createSlot(ingredientForSlot, i, maxIngredientsPerColumn);
                this.recipeSlots.add(recipeSlot);
            }
        }
    }

    private <T> RecipeSlot createSlot(ITypedIngredient<T> typedIngredient, int index, int maxIngredientsPerColumn) {
        RegisteredIngredients registeredIngredients = Internal.getRegisteredIngredients();
        int column = index / maxIngredientsPerColumn;
        int row = index % maxIngredientsPerColumn;
        int xPos = this.left + 5 + column * 16 + 1;
        int yPos = this.top + 5 + row * 16 + 1;
        RecipeSlot recipeSlot = new RecipeSlot(registeredIngredients, RecipeIngredientRole.CATALYST, xPos, yPos, 0, 0);
        recipeSlot.set(List.of(Optional.of(typedIngredient)), IntSet.of((int)0));
        return recipeSlot;
    }

    @Nullable
    public RecipeSlot draw(PoseStack poseStack, int mouseX, int mouseY) {
        int ingredientCount = this.recipeSlots.size();
        if (ingredientCount > 0) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69465_();
            int slotWidth = this.width - 10;
            int slotHeight = this.height - 10;
            this.backgroundTab.draw(poseStack, this.left, this.top, this.width, this.height);
            this.slotBackground.draw(poseStack, this.left + 5, this.top + 5, slotWidth, slotHeight);
            RenderSystem.m_69482_();
            RecipeSlot hovered = null;
            for (RecipeSlot recipeSlot : this.recipeSlots) {
                if (recipeSlot.isMouseOver(mouseX, mouseY)) {
                    hovered = recipeSlot;
                }
                recipeSlot.draw(poseStack);
            }
            return hovered;
        }
        return null;
    }

    private Optional<RecipeSlot> getHovered(double mouseX, double mouseY) {
        return this.recipeSlots.stream().filter(recipeSlot -> recipeSlot.isMouseOver(mouseX, mouseY)).findFirst();
    }

    @Override
    public Optional<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        return this.getHovered(mouseX, mouseY).flatMap(hovered -> hovered.getDisplayedIngredient().map(displayedIngredient -> new ClickedIngredient(displayedIngredient, hovered.getRect(), false, true)));
    }
}

