/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.config.KeyBindings;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IRecipeFocusSource;
import mezz.jei.input.UserInput;
import net.minecraft.client.Minecraft;

public class CombinedRecipeFocusSource {
    private final List<IRecipeFocusSource> handlers;

    public CombinedRecipeFocusSource(IRecipeFocusSource ... handlers) {
        this.handlers = List.of(handlers);
    }

    public Optional<IClickedIngredient<?>> getIngredientUnderMouse(UserInput input) {
        double mouseX = input.getMouseX();
        double mouseY = input.getMouseY();
        Stream<Object> stream = this.handlers.stream().map(handler -> handler.getIngredientUnderMouse(mouseX, mouseY)).flatMap(Optional::stream);
        if (CombinedRecipeFocusSource.isConflictingVanillaMouseButton(input)) {
            stream = stream.filter(IClickedIngredient::canOverrideVanillaClickHandler);
        }
        return stream.findFirst();
    }

    private static boolean isConflictingVanillaMouseButton(UserInput input) {
        if (input.isMouse()) {
            Minecraft minecraft = Minecraft.m_91087_();
            return input.is(KeyBindings.leftClick) || input.is(minecraft.f_91066_.f_92097_) || input.is(KeyBindings.rightClick);
        }
        return false;
    }
}

