/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input.mouse.handlers;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import mezz.jei.input.CombinedRecipeFocusSource;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.LimitedAreaInputHandler;
import net.minecraft.client.gui.screens.Screen;

public class FocusInputHandler
implements IUserInputHandler {
    private final CombinedRecipeFocusSource focusSource;
    private final IRecipesGui recipesGui;

    public FocusInputHandler(CombinedRecipeFocusSource focusSource, IRecipesGui recipesGui) {
        this.focusSource = focusSource;
        this.recipesGui = recipesGui;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input) {
        if (input.is(KeyBindings.showRecipe)) {
            return this.handleShow(input, List.of(RecipeIngredientRole.OUTPUT));
        }
        if (input.is(KeyBindings.showUses)) {
            return this.handleShow(input, List.of(RecipeIngredientRole.INPUT, RecipeIngredientRole.CATALYST));
        }
        return Optional.empty();
    }

    private Optional<IUserInputHandler> handleShow(UserInput input, List<RecipeIngredientRole> roles) {
        return this.focusSource.getIngredientUnderMouse(input).map(clicked -> {
            if (!input.isSimulate()) {
                List<IFocus<?>> focuses = roles.stream().map(role -> new Focus((RecipeIngredientRole)((Object)((Object)role)), clicked.getValue())).toList();
                this.recipesGui.show(focuses);
            }
            return LimitedAreaInputHandler.create(this, clicked.getArea());
        });
    }
}

