/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.recipes.IngredientToRecipesMap;
import org.jetbrains.annotations.UnmodifiableView;

public class RecipeIngredientTable {
    private final Map<IRecipeCategory<?>, IngredientToRecipesMap<?>> map = new HashMap();

    public <V> void add(V recipe, IRecipeCategory<V> recipeCategory, List<String> ingredientUids) {
        IngredientToRecipesMap ingredientToRecipesMap = this.map.computeIfAbsent(recipeCategory, k -> new IngredientToRecipesMap());
        ingredientToRecipesMap.add(recipe, ingredientUids);
    }

    public <V> @UnmodifiableView List<V> get(IRecipeCategory<V> recipeCategory, String ingredientUid) {
        IngredientToRecipesMap<?> ingredientToRecipesMap = this.map.get(recipeCategory);
        if (ingredientToRecipesMap == null) {
            return List.of();
        }
        return ingredientToRecipesMap.get(ingredientUid);
    }
}

