/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import java.io.File;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.IModPlugin;
import mezz.jei.config.BookmarkConfig;
import mezz.jei.config.ClientConfig;
import mezz.jei.config.EditModeConfig;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IngredientFilterConfig;
import mezz.jei.config.JEIClientConfigs;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.ModIdFormattingConfig;
import mezz.jei.config.WorldConfig;
import mezz.jei.config.sorting.IngredientTypeSortingConfig;
import mezz.jei.config.sorting.ModNameSortingConfig;
import mezz.jei.config.sorting.RecipeCategorySortingConfig;
import mezz.jei.events.DebugRestartJeiEvent;
import mezz.jei.events.PermanentEventSubscriptions;
import mezz.jei.events.PlayerJoinedWorldEvent;
import mezz.jei.events.RuntimeEventSubscriptions;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.ForgeModIdHelper;
import mezz.jei.ingredients.IIngredientSorter;
import mezz.jei.ingredients.IngredientSorter;
import mezz.jei.startup.JeiStarter;
import mezz.jei.startup.NetworkHandler;
import mezz.jei.startup.StartEventObserver;
import mezz.jei.util.AnnotatedInstanceUtil;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientLifecycleHandler
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final JeiStarter jeiStarter;
    private final WorldConfig worldConfig;
    private final ModIdFormattingConfig modIdFormattingConfig;
    private final StartEventObserver startEventObserver = new StartEventObserver(this::startJei);
    private final RuntimeEventSubscriptions runtimeSubscriptions = new RuntimeEventSubscriptions(MinecraftForge.EVENT_BUS);

    public ClientLifecycleHandler(NetworkHandler networkHandler, Textures textures, JEIClientConfigs jeiClientConfigs) {
        File jeiConfigurationDir = ClientLifecycleHandler.createConfigDir();
        ClientConfig clientConfig = jeiClientConfigs.getClientConfig();
        IngredientFilterConfig ingredientFilterConfig = jeiClientConfigs.getFilterConfig();
        this.modIdFormattingConfig = jeiClientConfigs.getModNameFormat();
        ForgeModIdHelper modIdHelper = new ForgeModIdHelper(clientConfig, this.modIdFormattingConfig);
        ErrorUtil.setModIdHelper(modIdHelper);
        BookmarkConfig bookmarkConfig = new BookmarkConfig(jeiConfigurationDir);
        EditModeConfig editModeConfig = new EditModeConfig(jeiConfigurationDir);
        RecipeCategorySortingConfig recipeCategorySortingConfig = new RecipeCategorySortingConfig(new File(jeiConfigurationDir, "recipe-category-sort-order.ini"));
        IIngredientSorter ingredientSorter = ClientLifecycleHandler.createIngredientSorter(clientConfig, jeiConfigurationDir);
        this.worldConfig = new WorldConfig(jeiConfigurationDir);
        networkHandler.createClientPacketHandler(this.worldConfig);
        ErrorUtil.setWorldConfig(this.worldConfig);
        List<IModPlugin> plugins = AnnotatedInstanceUtil.getModPlugins();
        KeyBindings.init();
        this.jeiStarter = new JeiStarter(plugins, textures, clientConfig, editModeConfig, ingredientFilterConfig, this.worldConfig, bookmarkConfig, modIdHelper, recipeCategorySortingConfig, ingredientSorter);
    }

    public void register(PermanentEventSubscriptions subscriptions) {
        this.worldConfig.register(subscriptions);
        this.startEventObserver.register(subscriptions);
        subscriptions.register(DebugRestartJeiEvent.class, this::onRestartJeiEvent);
        subscriptions.register(ClientPlayerNetworkEvent.LoggedOutEvent.class, event -> {
            if (event.getPlayer() != null) {
                this.stopJei();
            }
        });
    }

    private void startJei() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            LOGGER.error("Failed to start JEI, there is no Minecraft client level.");
            return;
        }
        if (!this.runtimeSubscriptions.isEmpty()) {
            LOGGER.error("Failed to start JEI, it is already running.");
            return;
        }
        this.worldConfig.syncWorldConfig();
        this.modIdFormattingConfig.checkForModNameFormatOverride();
        this.runtimeSubscriptions.clear();
        this.jeiStarter.start(this.runtimeSubscriptions);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerJoinedWorldEvent());
    }

    private void stopJei() {
        if (this.runtimeSubscriptions.isEmpty()) {
            LOGGER.error("Tried to stop JEI but it is not running.");
        }
        this.startEventObserver.reset();
        this.runtimeSubscriptions.clear();
        Internal.setRuntime(null);
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.restartJei();
    }

    private void onRestartJeiEvent(DebugRestartJeiEvent event) {
        LOGGER.warn("Restarting JEI from DebugRestartJeiEvent", new Throwable("Restarting JEI from DebugRestartJeiEvent"));
        this.restartJei();
    }

    private void restartJei() {
        if (!this.runtimeSubscriptions.isEmpty()) {
            this.runtimeSubscriptions.clear();
            this.jeiStarter.start(this.runtimeSubscriptions);
        }
    }

    private static IIngredientSorter createIngredientSorter(IClientConfig clientConfig, File jeiConfigurationDir) {
        ModNameSortingConfig ingredientModNameSortingConfig = new ModNameSortingConfig(new File(jeiConfigurationDir, "ingredient-list-mod-sort-order.ini"));
        IngredientTypeSortingConfig ingredientTypeSortingConfig = new IngredientTypeSortingConfig(new File(jeiConfigurationDir, "ingredient-list-type-sort-order.ini"));
        return new IngredientSorter(clientConfig, ingredientModNameSortingConfig, ingredientTypeSortingConfig);
    }

    private static File createConfigDir() {
        File configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "jei");
        if (!configDir.exists()) {
            try {
                if (!configDir.mkdir()) {
                    throw new RuntimeException("Could not create config directory " + configDir);
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException("Could not create config directory " + configDir, e);
            }
        }
        return configDir;
    }
}

