/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import com.google.common.collect.ImmutableTable;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.BookmarkConfig;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.sorting.RecipeCategorySortingConfig;
import mezz.jei.events.RuntimeEventSubscriptions;
import mezz.jei.gui.GuiEventHandler;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.overlay.GridAlignment;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import mezz.jei.gui.overlay.bookmarks.LeftAreaDispatcher;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.IIngredientSorter;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientFilterApi;
import mezz.jei.ingredients.IngredientVisibility;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.input.CombinedRecipeFocusSource;
import mezz.jei.input.GuiContainerWrapper;
import mezz.jei.input.InputEventHandler;
import mezz.jei.input.mouse.ICharTypedHandler;
import mezz.jei.input.mouse.handlers.BookmarkInputHandler;
import mezz.jei.input.mouse.handlers.CombinedInputHandler;
import mezz.jei.input.mouse.handlers.EditInputHandler;
import mezz.jei.input.mouse.handlers.FocusInputHandler;
import mezz.jei.input.mouse.handlers.GlobalInputHandler;
import mezz.jei.input.mouse.handlers.GuiAreaInputHandler;
import mezz.jei.load.PluginCaller;
import mezz.jei.load.PluginHelper;
import mezz.jei.load.PluginLoader;
import mezz.jei.plugins.jei.JeiInternalPlugin;
import mezz.jei.plugins.vanilla.VanillaPlugin;
import mezz.jei.recipes.RecipeTransferManager;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.LoggedTimer;
import net.minecraft.resources.ResourceLocation;

public final class JeiStarter {
    private final List<IModPlugin> plugins;
    private final Textures textures;
    private final IClientConfig clientConfig;
    private final IEditModeConfig editModeConfig;
    private final IIngredientFilterConfig ingredientFilterConfig;
    private final IWorldConfig worldConfig;
    private final BookmarkConfig bookmarkConfig;
    private final IModIdHelper modIdHelper;
    private final RecipeCategorySortingConfig recipeCategorySortingConfig;
    private final IIngredientSorter ingredientSorter;

    public JeiStarter(List<IModPlugin> plugins, Textures textures, IClientConfig clientConfig, IEditModeConfig editModeConfig, IIngredientFilterConfig ingredientFilterConfig, IWorldConfig worldConfig, BookmarkConfig bookmarkConfig, IModIdHelper modIdHelper, RecipeCategorySortingConfig recipeCategorySortingConfig, IIngredientSorter ingredientSorter) {
        ErrorUtil.checkNotEmpty(plugins, "plugins");
        this.plugins = plugins;
        this.textures = textures;
        this.clientConfig = clientConfig;
        this.editModeConfig = editModeConfig;
        this.ingredientFilterConfig = ingredientFilterConfig;
        this.worldConfig = worldConfig;
        this.bookmarkConfig = bookmarkConfig;
        this.modIdHelper = modIdHelper;
        this.recipeCategorySortingConfig = recipeCategorySortingConfig;
        this.ingredientSorter = ingredientSorter;
    }

    public void start(RuntimeEventSubscriptions subscriptions) {
        LoggedTimer totalTime = new LoggedTimer();
        totalTime.start("Starting JEI");
        VanillaPlugin vanillaPlugin = PluginHelper.getPluginWithClass(VanillaPlugin.class, this.plugins);
        JeiInternalPlugin jeiInternalPlugin = PluginHelper.getPluginWithClass(JeiInternalPlugin.class, this.plugins);
        ErrorUtil.checkNotNull(vanillaPlugin, "vanilla plugin");
        PluginHelper.sortPlugins(this.plugins, vanillaPlugin, jeiInternalPlugin);
        PluginLoader pluginLoader = new PluginLoader(this.plugins, this.textures, this.clientConfig, this.modIdHelper, this.ingredientSorter, this.ingredientFilterConfig, this.worldConfig, this.editModeConfig);
        RegisteredIngredients registeredIngredients = pluginLoader.getRegisteredIngredients();
        IngredientFilter ingredientFilter = pluginLoader.getIngredientFilter();
        ingredientFilter.register(subscriptions);
        BookmarkList bookmarkList = pluginLoader.createBookmarkList(this.bookmarkConfig);
        IRecipeManager recipeManager = pluginLoader.createRecipeManager(this.plugins, vanillaPlugin, this.recipeCategorySortingConfig);
        ImmutableTable<Class<?>, ResourceLocation, IRecipeTransferHandler<?, ?>> recipeTransferHandlers = pluginLoader.createRecipeTransferHandlers(this.plugins);
        RecipeTransferManager recipeTransferManager = new RecipeTransferManager(recipeTransferHandlers);
        LoggedTimer timer = new LoggedTimer();
        timer.start("Building runtime");
        GuiScreenHelper guiScreenHelper = pluginLoader.createGuiScreenHelper(this.plugins);
        RecipesGui recipesGui = new RecipesGui(recipeManager, recipeTransferManager, registeredIngredients, this.modIdHelper, this.clientConfig);
        IngredientGrid ingredientListGrid = new IngredientGrid(registeredIngredients, GridAlignment.LEFT, this.editModeConfig, this.ingredientFilterConfig, this.clientConfig, this.worldConfig, guiScreenHelper, recipesGui, this.modIdHelper);
        IngredientGridWithNavigation ingredientListGridNavigation = new IngredientGridWithNavigation(ingredientFilter, this.worldConfig, guiScreenHelper, ingredientListGrid, this.worldConfig, this.clientConfig);
        IngredientListOverlay ingredientListOverlay = new IngredientListOverlay(ingredientFilter, registeredIngredients, guiScreenHelper, ingredientListGridNavigation, this.clientConfig, this.worldConfig);
        IngredientGrid bookmarkListGrid = new IngredientGrid(registeredIngredients, GridAlignment.RIGHT, this.editModeConfig, this.ingredientFilterConfig, this.clientConfig, this.worldConfig, guiScreenHelper, recipesGui, this.modIdHelper);
        IngredientGridWithNavigation bookmarkListGridNavigation = new IngredientGridWithNavigation(bookmarkList, () -> "", guiScreenHelper, bookmarkListGrid, this.worldConfig, this.clientConfig);
        BookmarkOverlay bookmarkOverlay = new BookmarkOverlay(bookmarkList, this.textures, bookmarkListGridNavigation, this.clientConfig, this.worldConfig);
        IngredientFilterApi ingredientFilterApi = new IngredientFilterApi(ingredientFilter, this.worldConfig);
        IIngredientManager ingredientManager = pluginLoader.getIngredientManager();
        IngredientVisibility ingredientVisibility = pluginLoader.getIngredientVisibility();
        JeiRuntime jeiRuntime = new JeiRuntime(recipeManager, ingredientListOverlay, bookmarkOverlay, recipesGui, ingredientFilterApi, registeredIngredients, ingredientManager, ingredientVisibility);
        Internal.setRuntime(jeiRuntime);
        timer.stop();
        PluginCaller.callOnPlugins("Sending Runtime", this.plugins, p -> p.onRuntimeAvailable(jeiRuntime));
        LeftAreaDispatcher leftAreaDispatcher = new LeftAreaDispatcher(guiScreenHelper, bookmarkOverlay);
        GuiEventHandler guiEventHandler = new GuiEventHandler(guiScreenHelper, leftAreaDispatcher, ingredientListOverlay);
        guiEventHandler.register(subscriptions);
        CombinedRecipeFocusSource recipeFocusSource = new CombinedRecipeFocusSource(recipesGui, ingredientListOverlay, leftAreaDispatcher, new GuiContainerWrapper(registeredIngredients, guiScreenHelper));
        List<ICharTypedHandler> charTypedHandlers = List.of(ingredientListOverlay);
        CombinedInputHandler userInputHandler = new CombinedInputHandler(new EditInputHandler(recipeFocusSource, registeredIngredients, ingredientFilter, this.worldConfig, this.editModeConfig), ingredientListOverlay.createInputHandler(), leftAreaDispatcher.createInputHandler(), new FocusInputHandler(recipeFocusSource, recipesGui), new BookmarkInputHandler(recipeFocusSource, bookmarkList), new GlobalInputHandler(this.worldConfig), new GuiAreaInputHandler(registeredIngredients, guiScreenHelper, recipesGui));
        InputEventHandler inputEventHandler = new InputEventHandler(charTypedHandlers, userInputHandler);
        inputEventHandler.register(subscriptions);
        this.ingredientSorter.doPreSort(ingredientFilter, registeredIngredients);
        totalTime.stop();
    }
}

