/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.gui;

import betteradvancements.advancements.BetterDisplayInfo;
import betteradvancements.api.IBetterAdvancementEntryGui;
import betteradvancements.api.event.AdvancementDrawConnectionsEvent;
import betteradvancements.gui.BetterAdvancementTab;
import betteradvancements.gui.BetterAdvancementsScreen;
import betteradvancements.reference.Resources;
import betteradvancements.util.CriterionGrid;
import betteradvancements.util.RenderUtil;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementWidgetType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class BetterAdvancementWidget
extends GuiComponent
implements IBetterAdvancementEntryGui {
    protected static final int ADVANCEMENT_SIZE = 26;
    private static final int CORNER_SIZE = 10;
    private static final int WIDGET_WIDTH = 256;
    private static final int WIDGET_HEIGHT = 26;
    private static final int TITLE_SIZE = 32;
    private static final int ICON_OFFSET = 128;
    private static final int ICON_SIZE = 26;
    private final BetterAdvancementTab betterAdvancementTabGui;
    private final Advancement advancement;
    protected final BetterDisplayInfo betterDisplayInfo;
    private final DisplayInfo displayInfo;
    private final String title;
    private int width;
    private List<FormattedCharSequence> description;
    private CriterionGrid criterionGrid;
    private final Minecraft minecraft;
    private BetterAdvancementWidget parent;
    private final List<BetterAdvancementWidget> children = Lists.newArrayList();
    private AdvancementProgress advancementProgress;
    protected int x;
    protected int y;
    private final int screenScale;

    public BetterAdvancementWidget(BetterAdvancementTab betterAdvancementTabGui, Minecraft mc, Advancement advancement, DisplayInfo displayInfo) {
        this.betterAdvancementTabGui = betterAdvancementTabGui;
        this.advancement = advancement;
        this.betterDisplayInfo = betterAdvancementTabGui.getBetterDisplayInfo(advancement);
        this.displayInfo = displayInfo;
        this.minecraft = mc;
        this.title = displayInfo.m_14977_().m_130668_(163);
        this.x = this.betterDisplayInfo.getPosX() != null ? this.betterDisplayInfo.getPosX() : Mth.m_14143_((float)(displayInfo.m_14993_() * 32.0f));
        this.y = this.betterDisplayInfo.getPosY() != null ? this.betterDisplayInfo.getPosY() : Mth.m_14143_((float)(displayInfo.m_14994_() * 27.0f));
        this.refreshHover();
        this.screenScale = mc.m_91268_().m_85385_(0, false);
    }

    private void refreshHover() {
        Minecraft mc = this.minecraft;
        int k = 0;
        if (this.advancement.m_138326_() > 1) {
            int strLengthRequirementCount = String.valueOf(this.advancement.m_138326_()).length();
            k = mc.f_91062_.m_92895_("  ") + mc.f_91062_.m_92895_("0") * strLengthRequirementCount * 2 + mc.f_91062_.m_92895_("/");
        }
        int titleWidth = 29 + mc.f_91062_.m_92895_(this.title) + k;
        BetterAdvancementsScreen screen = this.betterAdvancementTabGui.getScreen();
        this.criterionGrid = CriterionGrid.findOptimalCriterionGrid(this.advancement, this.advancementProgress, screen.f_96543_ / 2, mc.f_91062_);
        int maxWidth = !CriterionGrid.requiresShift || Screen.m_96638_() ? Math.max(titleWidth, this.criterionGrid.width) : titleWidth;
        this.description = this.findOptimalLines(this.displayInfo.m_14985_(), maxWidth);
        for (FormattedCharSequence line : this.description) {
            maxWidth = Math.max(maxWidth, mc.f_91062_.m_92724_(line));
        }
        this.width = maxWidth + 8;
    }

    private List<FormattedCharSequence> findOptimalLines(Component line, int width) {
        if (line.getString().isEmpty()) {
            return Collections.emptyList();
        }
        List list = this.minecraft.f_91062_.m_92923_((FormattedText)line, width);
        if (list.size() > 1) {
            width = Math.max(width, this.betterAdvancementTabGui.getScreen().internalWidth / 4);
            list = this.minecraft.f_91062_.m_92923_((FormattedText)line, width);
        }
        while (list.size() > 5 && (double)width < 384.0 && (double)width < (double)this.betterAdvancementTabGui.getScreen().internalWidth / 2.5) {
            width += width / 4;
            list = this.minecraft.f_91062_.m_92923_((FormattedText)line, width);
        }
        return list;
    }

    @Nullable
    private BetterAdvancementWidget getFirstVisibleParent(Advancement advancementIn) {
        while ((advancementIn = advancementIn.m_138319_()) != null && advancementIn.m_138320_() == null) {
        }
        if (advancementIn != null && advancementIn.m_138320_() != null) {
            return this.betterAdvancementTabGui.getWidget(advancementIn);
        }
        return null;
    }

    public void drawConnectivity(PoseStack poseStack, int scrollX, int scrollY, boolean drawInside) {
        if (!this.betterDisplayInfo.hideLines().booleanValue()) {
            if (this.parent != null) {
                this.drawConnection(poseStack, this.parent, scrollX, scrollY, drawInside);
            }
            AdvancementDrawConnectionsEvent event = new AdvancementDrawConnectionsEvent(this.advancement);
            MinecraftForge.EVENT_BUS.post((Event)event);
            for (Advancement parent : event.getExtraConnections()) {
                BetterAdvancementWidget parentGui = this.betterAdvancementTabGui.getWidget(parent);
                if (parentGui == null) continue;
                this.drawConnection(poseStack, parentGui, scrollX, scrollY, drawInside);
            }
        }
        for (BetterAdvancementWidget betterAdvancementWidget : this.children) {
            betterAdvancementWidget.drawConnectivity(poseStack, scrollX, scrollY, drawInside);
        }
    }

    public void drawConnection(PoseStack poseStack, BetterAdvancementWidget parent, int scrollX, int scrollY, boolean drawInside) {
        int innerLineColor = this.advancementProgress != null && this.advancementProgress.m_8193_() ? this.betterDisplayInfo.getCompletedLineColor() : this.betterDisplayInfo.getUnCompletedLineColor();
        int borderLineColor = -16777216;
        if (this.betterDisplayInfo.drawDirectLines().booleanValue()) {
            boolean perpendicular;
            double x1 = scrollX + this.x + 13 + 3;
            double y1 = scrollY + this.y + 13;
            double x2 = scrollX + parent.x + 13 + 3;
            double y2 = scrollY + parent.y + 13;
            boolean bl = perpendicular = x1 == x2 || y1 == y2;
            if (!perpendicular) {
                double width;
                switch (this.screenScale) {
                    case 1: {
                        width = drawInside ? 1.5 : 0.5;
                        break;
                    }
                    case 2: {
                        width = drawInside ? 2.25 : 0.75;
                        break;
                    }
                    case 3: {
                        width = drawInside ? 2.0 : 0.6666666666666667;
                        break;
                    }
                    case 4: {
                        width = drawInside ? 2.125 : 0.625;
                        break;
                    }
                    default: {
                        double d = width = drawInside ? 3.0 : 1.0;
                    }
                }
                if (drawInside) {
                    RenderUtil.drawRect(x1 - 0.75, y1 - 0.75, x2 - 0.75, y2 - 0.75, width, borderLineColor);
                } else {
                    RenderUtil.drawRect(x1, y1, x2, y2, width, innerLineColor);
                }
            } else {
                double width;
                double d = width = drawInside ? 3.0 : 1.0;
                if (drawInside) {
                    RenderUtil.drawRect(x1 - 1.0, y1 - 1.0, x2 - 1.0, y2 - 1.0, width, borderLineColor);
                } else {
                    RenderUtil.drawRect(x1, y1, x2, y2, width, innerLineColor);
                }
            }
        } else {
            int startX = scrollX + parent.x + 13;
            int endXHalf = scrollX + parent.x + 26 + 6;
            int startY = scrollY + parent.y + 13;
            int endX = scrollX + this.x + 13;
            int endY = scrollY + this.y + 13;
            if (drawInside) {
                this.m_93154_(poseStack, endXHalf, startX, startY - 1, borderLineColor);
                this.m_93154_(poseStack, endXHalf + 1, startX, startY, borderLineColor);
                this.m_93154_(poseStack, endXHalf, startX, startY + 1, borderLineColor);
                this.m_93154_(poseStack, endX, endXHalf - 1, endY - 1, borderLineColor);
                this.m_93154_(poseStack, endX, endXHalf - 1, endY, borderLineColor);
                this.m_93154_(poseStack, endX, endXHalf - 1, endY + 1, borderLineColor);
                this.m_93222_(poseStack, endXHalf - 1, endY, startY, borderLineColor);
                this.m_93222_(poseStack, endXHalf + 1, endY, startY, borderLineColor);
            } else {
                this.m_93154_(poseStack, endXHalf, startX, startY, innerLineColor);
                this.m_93154_(poseStack, endX, endXHalf, endY, innerLineColor);
                this.m_93222_(poseStack, endXHalf, endY, startY, innerLineColor);
            }
        }
    }

    public void draw(PoseStack poseStack, int scrollX, int scrollY) {
        if (!this.displayInfo.m_14997_() || this.advancementProgress != null && this.advancementProgress.m_8193_()) {
            float f = this.advancementProgress == null ? 0.0f : this.advancementProgress.m_8213_();
            AdvancementWidgetType advancementState = f >= 1.0f ? AdvancementWidgetType.OBTAINED : AdvancementWidgetType.UNOBTAINED;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Resources.Gui.WIDGETS);
            RenderUtil.setColor(this.betterDisplayInfo.getIconColor(advancementState));
            RenderSystem.m_69478_();
            this.m_93228_(poseStack, scrollX + this.x + 3, scrollY + this.y, this.displayInfo.m_14992_().m_15551_(), 128 + 26 * this.betterDisplayInfo.getIconYMultiplier(advancementState), 26, 26);
            this.minecraft.m_91291_().m_115218_(this.displayInfo.m_14990_(), scrollX + this.x + 8, scrollY + this.y + 5);
        }
        for (BetterAdvancementWidget betterAdvancementWidget : this.children) {
            betterAdvancementWidget.draw(poseStack, scrollX, scrollY);
        }
    }

    public void getAdvancementProgress(AdvancementProgress advancementProgressIn) {
        this.advancementProgress = advancementProgressIn;
        this.refreshHover();
    }

    public void addGuiAdvancement(BetterAdvancementWidget betterAdvancementEntryScreen) {
        this.children.add(betterAdvancementEntryScreen);
    }

    public void drawHover(PoseStack poseStack, int scrollX, int scrollY, float fade, int left, int top) {
        int boxHeight;
        AdvancementWidgetType stateIcon;
        AdvancementWidgetType stateTitleRight;
        AdvancementWidgetType stateTitleLeft;
        boolean drawTop;
        int i;
        this.refreshHover();
        boolean drawLeft = left + scrollX + this.x + this.width + 26 >= this.betterAdvancementTabGui.getScreen().internalWidth;
        String s = this.advancementProgress == null ? null : this.advancementProgress.m_8218_();
        int n = i = s == null ? 0 : this.minecraft.f_91062_.m_92895_(s);
        if (!CriterionGrid.requiresShift || Screen.m_96638_()) {
            if (this.criterionGrid.height < this.betterAdvancementTabGui.getScreen().f_96544_) {
                int n2 = this.description.size();
                Objects.requireNonNull(this.minecraft.f_91062_);
                drawTop = top + scrollY + this.y + n2 * 9 + this.criterionGrid.height + 50 >= this.betterAdvancementTabGui.getScreen().f_96544_;
            } else {
                drawTop = false;
            }
        } else {
            int n3 = this.description.size();
            Objects.requireNonNull(this.minecraft.f_91062_);
            drawTop = top + scrollY + this.y + n3 * 9 + 50 >= this.betterAdvancementTabGui.getScreen().f_96544_;
        }
        float percentageObtained = this.advancementProgress == null ? 0.0f : this.advancementProgress.m_8213_();
        int j = Mth.m_14143_((float)(percentageObtained * (float)this.width));
        if (percentageObtained >= 1.0f) {
            j = this.width / 2;
            stateTitleLeft = AdvancementWidgetType.OBTAINED;
            stateTitleRight = AdvancementWidgetType.OBTAINED;
            stateIcon = AdvancementWidgetType.OBTAINED;
        } else if (j < 2) {
            j = this.width / 2;
            stateTitleLeft = AdvancementWidgetType.UNOBTAINED;
            stateTitleRight = AdvancementWidgetType.UNOBTAINED;
            stateIcon = AdvancementWidgetType.UNOBTAINED;
        } else if (j > this.width - 2) {
            j = this.width / 2;
            stateTitleLeft = AdvancementWidgetType.OBTAINED;
            stateTitleRight = AdvancementWidgetType.OBTAINED;
            stateIcon = AdvancementWidgetType.UNOBTAINED;
        } else {
            stateTitleLeft = AdvancementWidgetType.OBTAINED;
            stateTitleRight = AdvancementWidgetType.UNOBTAINED;
            stateIcon = AdvancementWidgetType.UNOBTAINED;
        }
        int k = this.width - j;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Resources.Gui.WIDGETS);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        int drawY = scrollY + this.y;
        int drawX = drawLeft ? scrollX + this.x - this.width + 26 + 6 : scrollX + this.x;
        if (!CriterionGrid.requiresShift || Screen.m_96638_()) {
            int n4 = this.description.size();
            Objects.requireNonNull(this.minecraft.f_91062_);
            boxHeight = 32 + n4 * 9 + this.criterionGrid.height;
        } else {
            int n5 = this.description.size();
            Objects.requireNonNull(this.minecraft.f_91062_);
            boxHeight = 32 + n5 * 9;
        }
        if (!this.description.isEmpty()) {
            if (drawTop) {
                this.render9Sprite(poseStack, drawX, drawY + 26 - boxHeight, this.width, boxHeight, 10, 256, 26, 0, 52);
            } else {
                this.render9Sprite(poseStack, drawX, drawY, this.width, boxHeight, 10, 256, 26, 0, 52);
            }
        }
        RenderUtil.setColor(this.betterDisplayInfo.getTitleColor(stateTitleLeft));
        int left_side = Math.min(j, 240);
        this.m_93228_(poseStack, drawX, drawY, 0, this.betterDisplayInfo.getTitleYMultiplier(stateTitleLeft) * 26, left_side, 26);
        if (left_side < j) {
            this.m_93228_(poseStack, drawX + left_side, drawY, 16, this.betterDisplayInfo.getTitleYMultiplier(stateTitleLeft) * 26, j - left_side, 26);
        }
        RenderUtil.setColor(this.betterDisplayInfo.getTitleColor(stateTitleRight));
        int right_side = Math.min(k, 240);
        this.m_93228_(poseStack, drawX + j, drawY, 256 - right_side, this.betterDisplayInfo.getTitleYMultiplier(stateTitleRight) * 26, right_side, 26);
        if (right_side < k) {
            this.m_93228_(poseStack, drawX + j + right_side - 2, drawY, 256 - k + right_side - 2, this.betterDisplayInfo.getTitleYMultiplier(stateTitleRight) * 26, k - right_side + 2, 26);
        }
        RenderUtil.setColor(this.betterDisplayInfo.getIconColor(stateIcon));
        this.m_93228_(poseStack, scrollX + this.x + 3, scrollY + this.y, this.displayInfo.m_14992_().m_15551_(), 128 + 26 * this.betterDisplayInfo.getIconYMultiplier(stateIcon), 26, 26);
        if (drawLeft) {
            this.minecraft.f_91062_.m_92750_(poseStack, this.title, (float)(drawX + 5), (float)(scrollY + this.y + 9), -1);
            if (s != null) {
                this.minecraft.f_91062_.m_92750_(poseStack, s, (float)(scrollX + this.x - i), (float)(scrollY + this.y + 9), -1);
            }
        } else {
            this.minecraft.f_91062_.m_92750_(poseStack, this.title, (float)(scrollX + this.x + 32), (float)(scrollY + this.y + 9), -1);
            if (s != null) {
                this.minecraft.f_91062_.m_92750_(poseStack, s, (float)(scrollX + this.x + this.width - i - 5), (float)(scrollY + this.y + 9), -1);
            }
        }
        int yOffset = drawTop ? drawY + 26 - boxHeight + 7 : scrollY + this.y + 9 + 17;
        for (int k1 = 0; k1 < this.description.size(); ++k1) {
            Font font = this.minecraft.f_91062_;
            float f = drawX + 5;
            Objects.requireNonNull(this.minecraft.f_91062_);
            font.m_92744_(poseStack, this.description.get(k1), f, (float)(yOffset + k1 * 9), -5592406);
        }
        if (this.criterionGrid != null && !CriterionGrid.requiresShift || Screen.m_96638_()) {
            int xOffset = drawX + 5;
            int n6 = this.description.size();
            Objects.requireNonNull(this.minecraft.f_91062_);
            yOffset += n6 * 9;
            for (int colIndex = 0; colIndex < this.criterionGrid.columns.size(); ++colIndex) {
                CriterionGrid.Column col = this.criterionGrid.columns.get(colIndex);
                for (int rowIndex = 0; rowIndex < col.cells.size(); ++rowIndex) {
                    Font font = this.minecraft.f_91062_;
                    float f = xOffset;
                    Objects.requireNonNull(this.minecraft.f_91062_);
                    font.m_92883_(poseStack, col.cells.get(rowIndex), f, (float)(yOffset + rowIndex * 9), -5592406);
                }
                xOffset += col.width;
            }
        }
        this.minecraft.m_91291_().m_115218_(this.displayInfo.m_14990_(), scrollX + this.x + 8, scrollY + this.y + 5);
    }

    protected void render9Sprite(PoseStack poseStack, int x, int y, int width, int height, int textureHeight, int textureWidth, int textureDistance, int textureX, int textureY) {
        this.m_93228_(poseStack, x, y, textureX, textureY, textureHeight, textureHeight);
        RenderUtil.renderRepeating(this, poseStack, x + textureHeight, y, width - textureHeight - textureHeight, textureHeight, textureX + textureHeight, textureY, textureWidth - textureHeight - textureHeight, textureDistance);
        this.m_93228_(poseStack, x + width - textureHeight, y, textureX + textureWidth - textureHeight, textureY, textureHeight, textureHeight);
        this.m_93228_(poseStack, x, y + height - textureHeight, textureX, textureY + textureDistance - textureHeight, textureHeight, textureHeight);
        RenderUtil.renderRepeating(this, poseStack, x + textureHeight, y + height - textureHeight, width - textureHeight - textureHeight, textureHeight, textureX + textureHeight, textureY + textureDistance - textureHeight, textureWidth - textureHeight - textureHeight, textureDistance);
        this.m_93228_(poseStack, x + width - textureHeight, y + height - textureHeight, textureX + textureWidth - textureHeight, textureY + textureDistance - textureHeight, textureHeight, textureHeight);
        RenderUtil.renderRepeating(this, poseStack, x, y + textureHeight, textureHeight, height - textureHeight - textureHeight, textureX, textureY + textureHeight, textureWidth, textureDistance - textureHeight - textureHeight);
        RenderUtil.renderRepeating(this, poseStack, x + textureHeight, y + textureHeight, width - textureHeight - textureHeight, height - textureHeight - textureHeight, textureX + textureHeight, textureY + textureHeight, textureWidth - textureHeight - textureHeight, textureDistance - textureHeight - textureHeight);
        RenderUtil.renderRepeating(this, poseStack, x + width - textureHeight, y + textureHeight, textureHeight, height - textureHeight - textureHeight, textureX + textureWidth - textureHeight, textureY + textureHeight, textureWidth, textureDistance - textureHeight - textureHeight);
    }

    public boolean isMouseOver(double scrollX, double scrollY, double mouseX, double mouseY) {
        if (!this.displayInfo.m_14997_() || this.advancementProgress != null && this.advancementProgress.m_8193_()) {
            double left = scrollX + (double)this.x;
            double right = left + 26.0;
            double top = scrollY + (double)this.y;
            double bottom = top + 26.0;
            return mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom;
        }
        return false;
    }

    public void attachToParent() {
        if (this.parent == null && this.advancement.m_138319_() != null) {
            this.parent = this.getFirstVisibleParent(this.advancement);
            if (this.parent != null) {
                this.parent.addGuiAdvancement(this);
            }
        }
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public Advancement getAdvancement() {
        return this.advancement;
    }
}

