/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.instancing;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.MaterialGroup;
import com.jozufozu.flywheel.api.struct.Instanced;
import com.jozufozu.flywheel.api.struct.StructType;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.RenderLayer;
import com.jozufozu.flywheel.backend.instancing.instancing.GPUInstancer;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancedMaterial;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancingEngine;
import com.jozufozu.flywheel.backend.model.FallbackAllocator;
import com.jozufozu.flywheel.backend.model.ModelAllocator;
import com.jozufozu.flywheel.backend.model.ModelPool;
import com.jozufozu.flywheel.core.Formats;
import com.jozufozu.flywheel.core.compile.ProgramContext;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.util.Textures;
import com.mojang.math.Matrix4f;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;

public class InstancedMaterialGroup<P extends WorldProgram>
implements MaterialGroup {
    protected final InstancingEngine<P> owner;
    protected final RenderType type;
    private final Map<Instanced<? extends InstanceData>, InstancedMaterial<?>> materials = new HashMap();
    private final ModelAllocator allocator;

    public InstancedMaterialGroup(InstancingEngine<P> owner, RenderType type) {
        this.owner = owner;
        this.type = type;
        this.allocator = Backend.compat.onAMDWindows() ? FallbackAllocator.INSTANCE : new ModelPool(Formats.POS_TEX_NORMAL, 2048);
    }

    public <D extends InstanceData> InstancedMaterial<D> material(StructType<D> type) {
        if (type instanceof Instanced) {
            Instanced instanced = (Instanced)type;
            return this.materials.computeIfAbsent(instanced, t -> new InstancedMaterial(t, this.allocator));
        }
        throw new ClassCastException("Cannot use type '" + type + "' with GPU instancing.");
    }

    public void render(Matrix4f viewProjection, double camX, double camY, double camZ, RenderLayer layer) {
        this.type.m_110185_();
        Textures.bindActiveTextures();
        this.renderAll(viewProjection, camX, camY, camZ, layer);
        this.type.m_110188_();
    }

    protected void renderAll(Matrix4f viewProjection, double camX, double camY, double camZ, RenderLayer layer) {
        for (InstancedMaterial<?> instancedMaterial : this.materials.values()) {
            for (GPUInstancer instancer : instancedMaterial.uninitialized) {
                instancer.init();
            }
            instancedMaterial.uninitialized.clear();
        }
        ModelAllocator modelAllocator = this.allocator;
        if (modelAllocator instanceof ModelPool) {
            ModelPool pool = (ModelPool)modelAllocator;
            pool.flush();
        }
        for (Map.Entry entry : this.materials.entrySet()) {
            InstancedMaterial material3 = (InstancedMaterial)entry.getValue();
            if (material3.nothingToRender()) continue;
            WorldProgram program = (WorldProgram)this.owner.context.getProgram(ProgramContext.create(((Instanced)entry.getKey()).getProgramSpec(), Formats.POS_TEX_NORMAL, layer));
            program.bind();
            program.uploadViewProjection(viewProjection);
            program.uploadCameraPos(camX, camY, camZ);
            this.setup(program);
            for (GPUInstancer instancer : material3.getAllInstancers()) {
                instancer.render();
            }
        }
    }

    public void setup(P program) {
    }

    public void clear() {
        this.materials.values().forEach(InstancedMaterial::clear);
    }

    public void delete() {
        this.materials.values().forEach(InstancedMaterial::delete);
        this.materials.clear();
    }
}

