/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.core.virtual.VirtualEmptyBlockGetter;
import com.jozufozu.flywheel.core.virtual.VirtualEmptyModelData;
import com.jozufozu.flywheel.util.Lazy;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ModelUtil {
    private static final Lazy<ModelBlockRenderer> MODEL_RENDERER = Lazy.of(() -> new ModelBlockRenderer(Minecraft.m_91087_().m_91298_()));
    private static final Direction[] CULL_FACES;

    public static BufferBuilder getBufferBuilder(BakedModel model, BlockState referenceState, PoseStack ms) {
        ModelBlockRenderer blockRenderer = Minecraft.m_91087_().m_91289_().m_110937_();
        BufferBuilder builder = new BufferBuilder(512);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        blockRenderer.tesselateBlock((BlockAndTintGetter)VirtualEmptyBlockGetter.INSTANCE, model, referenceState, BlockPos.f_121853_, ms, (VertexConsumer)builder, false, new Random(), 42L, OverlayTexture.f_118083_, (IModelData)VirtualEmptyModelData.INSTANCE);
        builder.m_85721_();
        return builder;
    }

    public static BufferBuilder getBufferBuilderFromTemplate(BlockAndTintGetter renderWorld, RenderType layer, Collection<StructureTemplate.StructureBlockInfo> blocks) {
        ModelBlockRenderer modelRenderer = MODEL_RENDERER.get();
        BlockModelShaper blockModels = Minecraft.m_91087_().m_91304_().m_119430_();
        PoseStack ms = new PoseStack();
        Random random = new Random();
        BufferBuilder builder = new BufferBuilder(512);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        ForgeHooksClient.setRenderType((RenderType)layer);
        ModelBlockRenderer.m_111000_();
        for (StructureTemplate.StructureBlockInfo info : blocks) {
            BlockState state = info.f_74676_;
            if (state.m_60799_() != RenderShape.MODEL || !ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)layer)) continue;
            BlockPos pos = info.f_74675_;
            ms.m_85836_();
            ms.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            modelRenderer.tesselateBlock(renderWorld, blockModels.m_110893_(state), state, pos, ms, (VertexConsumer)builder, true, random, 42L, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
            ms.m_85849_();
        }
        ModelBlockRenderer.m_111077_();
        ForgeHooksClient.setRenderType(null);
        builder.m_85721_();
        return builder;
    }

    public static Supplier<PoseStack> rotateToFace(Direction facing) {
        return () -> {
            PoseStack stack = new PoseStack();
            ((TransformStack)((TransformStack)TransformStack.cast(stack).centre()).rotateToFace(facing.m_122424_())).unCentre();
            return stack;
        };
    }

    static {
        Direction[] directions = Direction.values();
        CULL_FACES = Arrays.copyOf(directions, directions.length + 1);
    }
}

