/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.api.util.Utils;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.client.gui.WindowScan;
import com.ldtteam.structurize.helpers.Settings;
import com.ldtteam.structurize.items.AbstractItemWithPosSelector;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.network.messages.SaveScanMessage;
import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ItemScanTool
extends AbstractItemWithPosSelector {
    private static final String ANCHOR_POS_TKEY = "item.possetter.anchorpos";
    private static final String NBT_ANCHOR_POS = "structurize:anchor_pos";

    public ItemScanTool(CreativeModeTab itemGroup) {
        this(new Item.Properties().m_41503_(0).setNoRepair().m_41497_(Rarity.UNCOMMON).m_41491_(itemGroup));
    }

    public ItemScanTool(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult onAirRightClick(BlockPos start, BlockPos end, Level worldIn, Player playerIn, ItemStack itemStack) {
        Optional<BlockPos> anchorPos = Optional.empty();
        if (itemStack.m_41784_().m_128441_(NBT_ANCHOR_POS)) {
            BlockPos anchorBlockPos = NbtUtils.m_129239_((CompoundTag)itemStack.m_41784_().m_128469_(NBT_ANCHOR_POS));
            if (BlockPosUtil.isInbetween(anchorBlockPos, start, end)) {
                anchorPos = Optional.of(anchorBlockPos);
                if (worldIn.f_46443_) {
                    Settings.instance.setAnchorPos(anchorPos);
                }
            } else if (worldIn.f_46443_) {
                playerIn.m_6352_((Component)new TranslatableComponent("com.ldtteam.structurize.gui.scantool.outsideanchor"), playerIn.m_142081_());
            }
        }
        if (!worldIn.f_46443_) {
            if (playerIn.m_6144_()) {
                ItemScanTool.saveStructure(worldIn, start, end, playerIn, null, true, anchorPos);
            }
        } else if (!playerIn.m_6144_()) {
            WindowScan window = new WindowScan(start, end, anchorPos);
            window.open();
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public AbstractItemWithPosSelector getRegisteredItemInstance() {
        return (AbstractItemWithPosSelector)ModItems.scanTool.get();
    }

    public static void saveStructure(Level world, BlockPos from, BlockPos to, Player player, String name) {
        ItemScanTool.saveStructure(world, from, to, player, name, true, Optional.empty());
    }

    public static void saveStructure(Level world, BlockPos from, BlockPos to, Player player, String name, boolean saveEntities, Optional<BlockPos> anchorPos) {
        List list;
        if (anchorPos.isPresent() && !BlockPosUtil.isInbetween(anchorPos.get(), from, to)) {
            LanguageHandler.sendPlayerMessage(player, "item.sceptersteel.badanchorpos", new Object[0]);
            return;
        }
        BlockPos blockpos = new BlockPos(Math.min(from.m_123341_(), to.m_123341_()), Math.min(from.m_123342_(), to.m_123342_()), Math.min(from.m_123343_(), to.m_123343_()));
        BlockPos blockpos1 = new BlockPos(Math.max(from.m_123341_(), to.m_123341_()), Math.max(from.m_123342_(), to.m_123342_()), Math.max(from.m_123343_(), to.m_123343_()));
        BlockPos size = blockpos1.m_141950_((Vec3i)blockpos).m_142082_(1, 1, 1);
        if (size.m_123341_() * size.m_123342_() * size.m_123343_() > (Integer)Structurize.getConfig().getServer().schematicBlockLimit.get()) {
            LanguageHandler.sendPlayerMessage(player, "item.sceptersteel.toobig", Structurize.getConfig().getServer().schematicBlockLimit.get());
            return;
        }
        long currentMillis = System.currentTimeMillis();
        String currentMillisString = Long.toString(currentMillis);
        String fileName = name == null || name.isEmpty() ? new TranslatableComponent("item.sceptersteel.scanformat", new Object[]{"", currentMillisString}).getString() : name;
        Blueprint bp = BlueprintUtil.createBlueprint(world, blockpos, saveEntities, (short)size.m_123341_(), (short)size.m_123342_(), (short)size.m_123343_(), fileName, anchorPos);
        if (!anchorPos.isPresent() && bp.getPrimaryBlockOffset().equals((Object)new BlockPos(bp.getSizeX() / 2, 0, bp.getSizeZ() / 2)) && (list = bp.getBlockInfoAsList().stream().filter(blockInfo -> blockInfo.hasTileEntityData() && blockInfo.getTileEntityData().m_128441_("blueprintDataProvider")).collect(Collectors.toList())).size() > 1) {
            player.m_6352_((Component)new TranslatableComponent("com.ldtteam.structurize.gui.scantool.scanbadanchor", new Object[]{fileName}), player.m_142081_());
        }
        Network.getNetwork().sendToPlayer(new SaveScanMessage(BlueprintUtil.writeBlueprintToNBT(bp), fileName), (ServerPlayer)player);
    }

    public static boolean saveStructureOnServer(Level world, BlockPos from, BlockPos to, String name) {
        return ItemScanTool.saveStructureOnServer(world, from, to, name, true);
    }

    public static boolean saveStructureOnServer(Level world, BlockPos from, BlockPos to, String name, boolean saveEntities) {
        BlockPos blockpos = new BlockPos(Math.min(from.m_123341_(), to.m_123341_()), Math.min(from.m_123342_(), to.m_123342_()), Math.min(from.m_123343_(), to.m_123343_()));
        BlockPos blockpos1 = new BlockPos(Math.max(from.m_123341_(), to.m_123341_()), Math.max(from.m_123342_(), to.m_123342_()), Math.max(from.m_123343_(), to.m_123343_()));
        BlockPos size = blockpos1.m_141950_((Vec3i)blockpos).m_142082_(1, 1, 1);
        if (size.m_123341_() * size.m_123342_() * size.m_123343_() > (Integer)Structurize.getConfig().getServer().schematicBlockLimit.get()) {
            Log.getLogger().warn("Saving too large schematic for:" + name);
        }
        String prefix = "cache";
        String fileName = name == null || name.isEmpty() ? new TranslatableComponent("item.sceptersteel.scanformat").getString() : name;
        StructureName structureName = new StructureName("cache", "backup", fileName);
        List<File> folder = StructureLoadingUtils.getCachedSchematicsFolders();
        if (folder == null || folder.isEmpty()) {
            Log.getLogger().warn("Unable to save schematic in cache since no folder was found.");
            return false;
        }
        Blueprint bp = BlueprintUtil.createBlueprint(world, blockpos, saveEntities, (short)size.m_123341_(), (short)size.m_123342_(), (short)size.m_123343_(), name, Optional.empty());
        File file = new File(folder.get(0), structureName.toString() + ".blueprint");
        Utils.checkDirectory(file.getParentFile());
        try (FileOutputStream outputstream = new FileOutputStream(file);){
            NbtIo.m_128947_((CompoundTag)BlueprintUtil.writeBlueprintToNBT(bp), (OutputStream)outputstream);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        BlockEntity te;
        ItemStack itemstack;
        if (!player.m_6144_()) {
            return super.m_6777_(state, worldIn, pos, player);
        }
        if (worldIn.m_5776_()) {
            LanguageHandler.sendMessageToPlayer(player, ANCHOR_POS_TKEY, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        if (!(itemstack = player.m_21205_()).m_41720_().equals((Object)this.getRegisteredItemInstance())) {
            itemstack = player.m_21206_();
        }
        if ((te = worldIn.m_7702_(pos)) instanceof IBlueprintDataProvider && !((IBlueprintDataProvider)te).getSchematicName().isEmpty()) {
            if (worldIn.f_46443_) {
                Settings.instance.setAnchorPos(Optional.of(pos));
            }
            BlockPos start = (BlockPos)((IBlueprintDataProvider)te).getInWorldCorners().m_14418_();
            BlockPos end = (BlockPos)((IBlueprintDataProvider)te).getInWorldCorners().m_14419_();
            if (!start.equals((Object)pos) && !end.equals((Object)pos)) {
                if (worldIn.f_46443_) {
                    Settings.instance.setBox(((IBlueprintDataProvider)te).getInWorldCorners());
                }
                itemstack.m_41784_().m_128365_("structurize:start_pos", (Tag)NbtUtils.m_129224_((BlockPos)start));
                itemstack.m_41784_().m_128365_("structurize:end_pos", (Tag)NbtUtils.m_129224_((BlockPos)end));
            }
        }
        itemstack.m_41784_().m_128365_(NBT_ANCHOR_POS, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        return false;
    }
}

