/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.client.gui.WindowTagTool;
import com.ldtteam.structurize.items.AbstractItemWithPosSelector;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.util.LanguageHandler;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ItemTagTool
extends AbstractItemWithPosSelector {
    public static final String TAG_ANCHOR_POS = "anchorpostag";
    public static final String TAG_CURRENT_TAG = "currenttag";

    public ItemTagTool(CreativeModeTab itemGroup) {
        this(new Item.Properties().m_41503_(0).setNoRepair().m_41497_(Rarity.UNCOMMON).m_41491_(itemGroup));
    }

    public ItemTagTool(Item.Properties properties) {
        super(properties);
    }

    @Override
    public AbstractItemWithPosSelector getRegisteredItemInstance() {
        return (AbstractItemWithPosSelector)ModItems.tagTool.get();
    }

    @Override
    public InteractionResult onAirRightClick(BlockPos start, BlockPos end, Level worldIn, Player playerIn, ItemStack itemStack) {
        if (worldIn.f_46443_) {
            BlockPos anchorPos = this.getAnchorPos(itemStack);
            if (anchorPos == null) {
                LanguageHandler.sendPlayerMessage(playerIn, "com.ldtteam.structurize.gui.tagtool.noanchor", new Object[0]);
                return InteractionResult.FAIL;
            }
            WindowTagTool window = new WindowTagTool(this.getCurrentTag(itemStack), anchorPos, worldIn, itemStack);
            window.open();
        }
        return InteractionResult.SUCCESS;
    }

    private BlockPos getAnchorPos(ItemStack stack) {
        CompoundTag itemCompound = stack.m_41784_();
        if (itemCompound.m_128441_(TAG_ANCHOR_POS)) {
            return BlockPosUtil.readFromNBT(itemCompound, TAG_ANCHOR_POS);
        }
        return null;
    }

    private String getCurrentTag(ItemStack stack) {
        if (stack.m_41784_().m_128441_(TAG_CURRENT_TAG)) {
            return stack.m_41784_().m_128461_(TAG_CURRENT_TAG);
        }
        return "";
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        return new InteractionResultHolder(this.onAirRightClick(null, null, worldIn, playerIn, playerIn.m_21120_(handIn)), (Object)playerIn.m_21120_(handIn));
    }

    @Override
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.SUCCESS;
        }
        if (context.m_43723_().m_6144_()) {
            BlockEntity te = context.m_43725_().m_7702_(context.m_8083_());
            if (te instanceof IBlueprintDataProvider) {
                BlockPosUtil.writeToNBT(context.m_43722_().m_41784_(), TAG_ANCHOR_POS, context.m_8083_());
                if (context.m_43725_().m_5776_()) {
                    LanguageHandler.sendPlayerMessage(context.m_43723_(), "com.ldtteam.structurize.gui.tagtool.anchorsaved", new Object[0]);
                }
                return InteractionResult.SUCCESS;
            }
            if (context.m_43725_().m_5776_()) {
                LanguageHandler.sendPlayerMessage(context.m_43723_(), "com.ldtteam.structurize.gui.tagtool.anchor.notvalid", new Object[0]);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() != ModItems.tagTool.get()) {
            return false;
        }
        BlockPos anchorPos = this.getAnchorPos(stack);
        String currentTag = this.getCurrentTag(stack);
        if (anchorPos == null) {
            LanguageHandler.sendPlayerMessage(player, "com.ldtteam.structurize.gui.tagtool.noanchor", new Object[0]);
            return false;
        }
        if (currentTag.isEmpty()) {
            LanguageHandler.sendPlayerMessage(player, "com.ldtteam.structurize.gui.tagtool.notag", new Object[0]);
            return false;
        }
        BlockPos relativePos = pos.m_141950_((Vec3i)anchorPos);
        BlockEntity te = worldIn.m_7702_(anchorPos);
        if (!(te instanceof IBlueprintDataProvider)) {
            LanguageHandler.sendPlayerMessage(player, "com.ldtteam.structurize.gui.tagtool.anchor.notvalid", new Object[0]);
            stack.m_41784_().m_128473_(TAG_ANCHOR_POS);
            return false;
        }
        Map<BlockPos, List<String>> tagPosMap = ((IBlueprintDataProvider)te).getPositionedTags();
        if (!tagPosMap.containsKey(relativePos) || !tagPosMap.get(relativePos).contains(currentTag)) {
            ((IBlueprintDataProvider)te).addTag(relativePos, currentTag);
            if (worldIn.m_5776_()) {
                LanguageHandler.sendPlayerMessage(player, "com.ldtteam.structurize.gui.tagtool.addtag", currentTag, new TranslatableComponent(worldIn.m_8055_(pos).m_60734_().m_7705_()));
            }
        } else {
            ((IBlueprintDataProvider)te).removeTag(relativePos, currentTag);
            if (worldIn.m_5776_()) {
                LanguageHandler.sendPlayerMessage(player, "com.ldtteam.structurize.gui.tagtool.removed", currentTag, new TranslatableComponent(worldIn.m_8055_(pos).m_60734_().m_7705_()));
            }
        }
        return false;
    }
}

