/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.management.linksession;

import com.ldtteam.structurize.management.linksession.ChannelsEnum;
import com.ldtteam.structurize.management.linksession.LinkSession;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class LinkSessionManager
implements INBTSerializable<CompoundTag> {
    private static final String CHANNELS_TAG = "channels";
    public static final LinkSessionManager INSTANCE = new LinkSessionManager();
    private final HashMap<UUID, LinkSession> sessions = new HashMap();
    private final HashMap<UUID, HashMap<Integer, Boolean>> channels = new HashMap();
    private final HashMap<UUID, UUID> invites = new HashMap();

    public void createSession(UUID ownerUUID) {
        this.sessions.put(ownerUUID, new LinkSession());
    }

    public boolean destroySession(UUID ownerUUID) {
        return this.sessions.remove(ownerUUID) != null;
    }

    public List<UUID> getMembersOf(UUID ownerUUID) {
        return this.sessions.get(ownerUUID) == null ? Collections.emptyList() : this.sessions.get(ownerUUID).getMembersUUID();
    }

    public List<String> getMembersNamesOf(UUID ownerUUID) {
        return this.sessions.get(ownerUUID) == null ? Collections.emptyList() : this.sessions.get(ownerUUID).getMembersDisplayNames();
    }

    public List<String> getSessionNamesOf(UUID memberUUID) {
        List ses = this.sessions.entrySet().stream().filter(en -> ((LinkSession)en.getValue()).isMember(memberUUID)).map(en -> ((LinkSession)en.getValue()).getMemberDisplayName((UUID)en.getKey())).collect(Collectors.toList());
        return ses.isEmpty() ? Collections.emptyList() : ses;
    }

    public Set<UUID> execute(UUID memberUUID, ChannelsEnum channel) {
        return this.sessions.entrySet().stream().filter(en -> ((LinkSession)en.getValue()).isMember(memberUUID)).flatMap(en -> this.getMembersOf((UUID)en.getKey()).stream()).filter(uuid -> !this.getMuteState((UUID)uuid, channel)).collect(Collectors.toSet());
    }

    public boolean addOrUpdateMemberInSession(UUID ownerUUID, UUID memberUUID, @Nullable String displayName) {
        if (this.sessions.containsKey(ownerUUID)) {
            this.sessions.get(ownerUUID).addOrUpdateMember(memberUUID, displayName);
            return true;
        }
        return false;
    }

    public boolean removeMemberOfSession(UUID ownerUUID, UUID memberUUID) {
        if (this.sessions.containsKey(ownerUUID)) {
            this.sessions.get(ownerUUID).removeMember(memberUUID);
            return true;
        }
        return false;
    }

    public void setMuteState(UUID playerUUID, ChannelsEnum channel, boolean state) {
        if (!this.channels.containsKey(playerUUID)) {
            this.channels.put(playerUUID, new HashMap());
        }
        this.channels.get(playerUUID).put(channel.getID(), state);
    }

    public boolean getMuteState(UUID playerUUID, ChannelsEnum channel) {
        if (this.channels.containsKey(playerUUID) && this.channels.get(playerUUID).containsKey(channel.getID())) {
            return this.channels.get(playerUUID).get(channel.getID());
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag out = new CompoundTag();
        CompoundTag channelz = new CompoundTag();
        this.sessions.forEach((uuid, ls) -> out.m_128365_(uuid.toString(), (Tag)ls.writeToNBT()));
        this.channels.forEach((uuid, ch) -> {
            CompoundTag player = new CompoundTag();
            ch.forEach((id, state) -> player.m_128379_(String.valueOf(id), state.booleanValue()));
            channelz.m_128365_(uuid.toString(), (Tag)player);
        });
        out.m_128365_(CHANNELS_TAG, (Tag)channelz);
        return out;
    }

    public void deserializeNBT(CompoundTag in) {
        this.reset();
        CompoundTag channelz = in.m_128469_(CHANNELS_TAG);
        for (String key : channelz.m_128431_()) {
            CompoundTag playerTag = channelz.m_128469_(key);
            UUID playerUUID = UUID.fromString(key);
            this.channels.put(playerUUID, new HashMap());
            for (String id : playerTag.m_128431_()) {
                this.channels.get(playerUUID).put(Integer.valueOf(id), playerTag.m_128471_(id));
            }
        }
        in.m_128473_(CHANNELS_TAG);
        for (String key : in.m_128431_()) {
            this.sessions.put(UUID.fromString(key), LinkSession.createFromNBT(in.m_128469_(key)));
        }
    }

    public boolean createInvite(UUID playerUUID, UUID ownerUUID) {
        if (this.sessions.containsKey(ownerUUID)) {
            this.invites.put(playerUUID, ownerUUID);
            return true;
        }
        return false;
    }

    @Nullable
    public String hasInvite(UUID playerUUID) {
        if (this.invites.containsKey(playerUUID)) {
            UUID ownerUUID = this.invites.get(playerUUID);
            if (this.sessions.containsKey(ownerUUID)) {
                return this.sessions.get(ownerUUID).getMemberDisplayName(ownerUUID);
            }
            this.invites.remove(playerUUID);
        }
        return null;
    }

    @Nullable
    public String consumeInvite(UUID playerUUID, @Nullable String playerName) {
        if (!this.invites.containsKey(playerUUID)) {
            return null;
        }
        UUID ownerUUID = this.invites.get(playerUUID);
        this.invites.remove(playerUUID);
        if (!this.addOrUpdateMemberInSession(ownerUUID, playerUUID, playerName)) {
            return null;
        }
        return this.sessions.get(ownerUUID).getMemberDisplayName(ownerUUID);
    }

    @Nullable
    public String consumeInviteWithCheck(UUID playerUUID, @Nullable String playerName, UUID UUIDtoCheck) {
        if (this.invites.containsKey(playerUUID) && this.invites.get(playerUUID).equals(UUIDtoCheck)) {
            return this.consumeInvite(playerUUID, playerName);
        }
        return null;
    }

    private void reset() {
        this.channels.clear();
        this.sessions.clear();
        this.invites.clear();
    }
}

