/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.api.util.Shape;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class GenerateAndPasteMessage
implements IMessage {
    protected final boolean hollow;
    protected final ItemStack block;
    protected final ItemStack block2;
    protected final Shape shape;
    protected final BlockPos pos;
    protected final int length;
    protected final int width;
    protected final int height;
    protected final int frequency;
    protected final String equation;
    protected final int rotation;
    protected final boolean mirror;

    public GenerateAndPasteMessage(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.length = buf.readInt();
        this.width = buf.readInt();
        this.height = buf.readInt();
        this.frequency = buf.readInt();
        this.shape = Shape.values()[buf.readInt()];
        this.block = buf.m_130267_();
        this.block2 = buf.m_130267_();
        this.hollow = buf.readBoolean();
        this.rotation = buf.readInt();
        this.mirror = buf.readBoolean();
        this.equation = buf.m_130136_(Short.MAX_VALUE);
    }

    public GenerateAndPasteMessage(BlockPos pos, int length, int width, int height, int frequency, String equation, Shape shape, ItemStack block, ItemStack block2, boolean hollow, Rotation rotation, Mirror mirror) {
        this.pos = pos;
        this.length = length;
        this.width = width;
        this.height = height;
        this.frequency = frequency;
        this.shape = shape;
        this.block = block;
        this.block2 = block2;
        this.hollow = hollow;
        this.mirror = mirror != Mirror.NONE;
        this.rotation = rotation.ordinal();
        this.equation = equation;
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.length);
        buf.writeInt(this.width);
        buf.writeInt(this.height);
        buf.writeInt(this.frequency);
        buf.writeInt(this.shape.ordinal());
        buf.m_130055_(this.block);
        buf.m_130055_(this.block2);
        buf.writeBoolean(this.hollow);
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.mirror);
        buf.m_130070_(this.equation);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!ctxIn.getSender().m_7500_()) {
            return;
        }
        Manager.pasteStructure(ctxIn.getSender().m_183503_(), this.pos, this.width, this.length, this.height, this.frequency, this.equation, this.shape, this.block, this.block2, this.hollow, ctxIn.getSender(), this.mirror ? Mirror.FRONT_BACK : Mirror.NONE, Rotation.values()[this.rotation]);
    }
}

