/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.domumornamentum.entity.block.IMateriallyTexturedBlockEntity;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.util.JavaUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.GameData;

public final class BlockUtils {
    public static final List<BiPredicate<Block, BlockState>> FREE_TO_PLACE_BLOCKS = Arrays.asList((block, iBlockState) -> block.equals(Blocks.f_50016_), (block, iBlockState) -> iBlockState.m_60767_().m_76332_(), (block, iBlockState) -> BlockUtils.isWater(block.m_49966_()), (block, iBlockState) -> block instanceof LeavesBlock, (block, iBlockState) -> block instanceof DoublePlantBlock, (block, iBlockState) -> block.equals(Blocks.f_50034_), (block, iBlockState) -> block instanceof DoorBlock && iBlockState != null && (Boolean)iBlockState.m_61143_((Property)BooleanProperty.m_61465_((String)"upper")) != false);

    private BlockUtils() {
    }

    public static Rotation getRotation(int rotation) {
        switch (rotation) {
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static int getRotationFromFacing(Direction facing) {
        switch (facing) {
            case SOUTH: {
                return 2;
            }
            case EAST: {
                return 1;
            }
            case WEST: {
                return 3;
            }
        }
        return 0;
    }

    public static BlockState getSubstitutionBlockAtWorld(Level world, BlockPos location) {
        BlockState filler = Blocks.f_50493_.m_49966_();
        if (filler.m_60734_() == Blocks.f_49992_) {
            return Blocks.f_50062_.m_49966_();
        }
        if (filler.m_60734_() instanceof FallingBlock) {
            return Blocks.f_50493_.m_49966_();
        }
        return filler;
    }

    public static boolean isWater(BlockState iBlockState) {
        return iBlockState.m_60734_() == Blocks.f_49990_;
    }

    private static Item getItem(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block.equals(Blocks.f_49991_)) {
            return Items.f_42448_;
        }
        if (block instanceof CropBlock) {
            ItemStack stack = ((CropBlock)block).m_7397_(null, null, blockState);
            if (stack != null) {
                return stack.m_41720_();
            }
            return Items.f_42404_;
        }
        if (block instanceof FarmBlock || block instanceof DirtPathBlock) {
            return BlockUtils.getItemFromBlock(Blocks.f_50493_);
        }
        if (block instanceof FireBlock) {
            return Items.f_42409_;
        }
        if (block instanceof FlowerPotBlock) {
            return Items.f_42618_;
        }
        if (block == Blocks.f_50570_) {
            return Items.f_41911_;
        }
        return BlockUtils.getItemFromBlock(block);
    }

    private static Item getItemFromBlock(Block block) {
        return (Item)GameData.getBlockItemMap().get(block);
    }

    public static boolean areBlockStatesEqual(BlockState structureState, BlockState worldState, Predicate<BlockState> shallReplace, boolean fancy, BiPredicate<BlockState, BlockState> specialEqualRule, CompoundTag tileEntityData, BlockEntity worldEntity) {
        if (structureState == null || worldState == null) {
            return true;
        }
        Block structureBlock = structureState.m_60734_();
        Block worldBlock = worldState.m_60734_();
        if (worldState.equals(structureState)) {
            if (tileEntityData == null) {
                return true;
            }
            if (worldEntity == null) {
                return false;
            }
            if (worldEntity instanceof IMateriallyTexturedBlockEntity) {
                CompoundTag tag = tileEntityData.m_6426_();
                tag.m_128405_("x", worldEntity.m_58899_().m_123341_());
                tag.m_128405_("y", worldEntity.m_58899_().m_123342_());
                tag.m_128405_("z", worldEntity.m_58899_().m_123343_());
                return worldEntity.m_187480_().equals((Object)tag);
            }
            return true;
        }
        if (fancy) {
            if (structureBlock == ModBlocks.blockSubstitution.get()) {
                return true;
            }
            if (structureBlock == ModBlocks.blockTagSubstitution.get() && worldBlock instanceof AirBlock) {
                return true;
            }
            if (structureBlock instanceof AirBlock && worldBlock instanceof AirBlock) {
                return true;
            }
            if (structureBlock == Blocks.f_50493_ && worldState.m_60620_((Tag)BlockTags.f_144274_)) {
                return true;
            }
            if (structureBlock == ModBlocks.blockSolidSubstitution.get() && !shallReplace.test(worldState)) {
                return true;
            }
            if (structureBlock == ModBlocks.blockFluidSubstitution.get() && (worldState.m_60819_().m_76170_() || !worldState.m_61138_((Property)BlockStateProperties.f_61362_) && worldState.m_60767_().m_76333_()) || worldBlock == ModBlocks.blockFluidSubstitution.get() && (structureState.m_60819_().m_76170_() || !structureState.m_61138_((Property)BlockStateProperties.f_61362_) && structureState.m_60767_().m_76333_())) {
                return true;
            }
        }
        return specialEqualRule.test(structureState, worldState);
    }

    public static BlockState getBlockStateFromStack(ItemStack stack) {
        return BlockUtils.getBlockStateFromStack(stack, Blocks.f_50016_.m_49966_());
    }

    public static BlockState getBlockStateFromStack(ItemStack stack, BlockState def) {
        if (stack.m_41720_() == Items.f_41852_) {
            return Blocks.f_50016_.m_49966_();
        }
        if (stack.m_41720_() instanceof BucketItem) {
            return ((BucketItem)stack.m_41720_()).getFluid().m_76145_().m_76188_();
        }
        if (stack.m_41720_() instanceof BlockItem) {
            return ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
        }
        return def;
    }

    public static ItemStack getItemStackFromBlockState(BlockState blockState) {
        if (blockState.m_60734_() instanceof LiquidBlock) {
            return new ItemStack((ItemLike)((LiquidBlock)blockState.m_60734_()).getFluid().m_6859_(), 1);
        }
        Item item = BlockUtils.getItem(blockState);
        if (item != Items.f_41852_ && item != null) {
            return new ItemStack((ItemLike)item, 1);
        }
        return new ItemStack((ItemLike)blockState.m_60734_(), 1);
    }

    public static void handleCorrectBlockPlacement(Level world, FakePlayer fakePlayer, ItemStack itemStack, BlockState blockState, BlockPos here) {
        ItemStack stackToPlace = itemStack.m_41777_();
        Item item = stackToPlace.m_41720_();
        stackToPlace.m_41764_(stackToPlace.m_41741_());
        if (item instanceof AirItem) {
            world.m_7471_(here, false);
        } else if (item instanceof BlockItem) {
            Block targetBlock = ((BlockItem)item).m_40614_();
            BlockState newState = BlockUtils.copyFirstCommonBlockStateProperties(targetBlock.m_49966_(), blockState);
            if (newState == null) {
                fakePlayer.m_21008_(InteractionHand.MAIN_HAND, stackToPlace);
                if (stackToPlace.m_150922_((Tag)ItemTags.f_13146_) && blockState.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
                    fakePlayer.m_146922_((float)(((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122416_() * 90));
                }
                if ((newState = targetBlock.m_5573_(new BlockPlaceContext(new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, new BlockHitResult(new Vec3(0.0, 0.0, 0.0), itemStack.m_41720_() instanceof BedItem ? Direction.UP : Direction.NORTH, here, true))))) == null) {
                    return;
                }
            }
            world.m_7471_(here, false);
            world.m_7731_(here, newState, 3);
            targetBlock.m_6402_(world, here, newState, (LivingEntity)fakePlayer, stackToPlace);
        } else if (item instanceof BucketItem) {
            Block sourceBlock = blockState.m_60734_();
            BucketItem bucket = (BucketItem)item;
            Fluid fluid = bucket.getFluid();
            if (sourceBlock instanceof LiquidBlockContainer) {
                LiquidBlockContainer liquidContainer = (LiquidBlockContainer)sourceBlock;
                if (liquidContainer.m_6044_((BlockGetter)world, here, blockState, fluid)) {
                    liquidContainer.m_7361_((LevelAccessor)world, here, blockState, fluid.m_76145_());
                    bucket.m_142131_(null, world, stackToPlace, here);
                }
            } else {
                world.m_7471_(here, false);
                world.m_7731_(here, fluid.m_76145_().m_76188_(), 3);
                bucket.m_142131_(null, world, stackToPlace, here);
            }
        } else {
            throw new IllegalArgumentException(MessageFormat.format("Cannot handle placing of {0} instead of {1}?!", itemStack.toString(), blockState.toString()));
        }
    }

    public static void removeFluid(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if ((!(block instanceof BucketPickup) || ((BucketPickup)block).m_142598_((LevelAccessor)world, pos, state).m_41619_()) && block instanceof LiquidBlock) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public static BlockState getFluidForDimension(Level world) {
        return world.m_6042_().m_63951_() ? Blocks.f_49991_.m_49966_() : Blocks.f_49990_.m_49966_();
    }

    public static List<ItemStack> getBlockDrops(Level world, BlockPos coords, int fortune, ItemStack stack) {
        return world.m_8055_(coords).m_60724_(new LootContext.Builder((ServerLevel)world).m_78963_((float)fortune).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)coords.m_123341_(), (double)coords.m_123342_(), (double)coords.m_123343_())).m_78984_(LootContextParams.f_81462_, (Object)world.m_7702_(coords)).m_78972_(LootContextParams.f_81463_, (Object)stack));
    }

    public static BlockState copyBlockStateProperties(Block target, BlockState propertiesOrigin) {
        return target.getClass().equals(propertiesOrigin.m_60734_().getClass()) ? BlockUtils.unsafeCopyBlockStateProperties(target.m_49966_(), propertiesOrigin, propertiesOrigin.m_61147_()) : null;
    }

    public static BlockState copyFirstCommonBlockStateProperties(BlockState target, BlockState propertiesOrigin) {
        BlockState sameClass = BlockUtils.copyBlockStateProperties(target.m_60734_(), propertiesOrigin);
        if (sameClass != null) {
            return sameClass;
        }
        Class<?> firstCommonClass = JavaUtils.getFirstCommonSuperClass(target.m_60734_().getClass(), propertiesOrigin.m_60734_().getClass());
        if (firstCommonClass == Block.class || !Block.class.isAssignableFrom(firstCommonClass)) {
            return null;
        }
        ArrayList properties = new ArrayList(target.m_61147_());
        properties.retainAll(propertiesOrigin.m_61147_());
        return BlockUtils.unsafeCopyBlockStateProperties(target, propertiesOrigin, properties);
    }

    private static BlockState unsafeCopyBlockStateProperties(BlockState target, BlockState propertiesOrigin, Collection<Property<?>> properties) {
        BlockState blockState = target;
        for (Property<?> property : properties) {
            blockState = (BlockState)blockState.m_61124_(property, propertiesOrigin.m_61143_(property));
        }
        return blockState;
    }
}

