/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.tablet.items;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.api.various.IItemCycler;
import mcjty.rftoolsbase.api.various.ITabletSupport;
import mcjty.rftoolsbase.modules.tablet.TabletModule;
import mcjty.rftoolsbase.modules.tablet.items.TabletContainer;
import mcjty.rftoolsbase.modules.tablet.items.TabletItemHandler;
import mcjty.rftoolsbase.tools.ManualHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class TabletItem
extends Item
implements IItemCycler,
ITooltipSettings {
    public static final ManualEntry MANUAL = ManualHelper.create("rftoolsbase:tools/tablet");
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbase.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()});

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    public TabletItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(RFToolsBase.setup.getTab()));
    }

    public static int getCurrentSlot(ItemStack stack) {
        return NBTTools.getTag((ItemStack)stack).map(tag -> tag.m_128451_("Current")).orElse(0);
    }

    public static void setCurrentSlot(Player player, ItemStack stack, int current) {
        stack.m_41784_().m_128405_("Current", current);
        ItemStack containingItem = TabletItem.getContainingItem(stack, current);
        ItemStack newTablet = TabletItem.deriveNewItemstack(current, containingItem, stack, current);
        player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)newTablet);
    }

    public static InteractionHand getHand(Player player) {
        return player.m_7655_() == null ? InteractionHand.MAIN_HAND : player.m_7655_();
    }

    public Collection<CreativeModeTab> getCreativeTabs() {
        if (this == TabletModule.TABLET.get()) {
            return super.getCreativeTabs();
        }
        return Collections.emptyList();
    }

    @Override
    public void cycle(Player player, ItemStack stack, boolean next) {
        int currentItem = TabletItem.getCurrentSlot(stack);
        for (int tries = 7; tries > 0; --tries) {
            currentItem = next ? (currentItem + 1) % 6 : (currentItem + 6 - 1) % 6;
            ItemStack containingItem = TabletItem.getContainingItem(stack, currentItem);
            if (containingItem.m_41619_()) continue;
            TabletItem.setCurrentSlot(player, stack, currentItem);
            player.m_5661_((Component)new TextComponent("Switched item"), false);
            return;
        }
    }

    public static ItemStack getContainingItem(ItemStack stack, int slot) {
        return NBTTools.getTag((ItemStack)stack).map(tag -> ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item" + slot))).orElse(ItemStack.f_41583_);
    }

    public static void setContainingItem(Player player, InteractionHand hand, int slot, ItemStack containingItem) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        if (containingItem.m_41619_()) {
            tag.m_128473_("Item" + slot);
        } else {
            CompoundTag compound = new CompoundTag();
            containingItem.m_41739_(compound);
            tag.m_128365_("Item" + slot, (Tag)compound);
        }
        int current = TabletItem.getCurrentSlot(stack);
        ItemStack newTablet = TabletItem.deriveNewItemstack(slot, containingItem, stack, current);
        player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)newTablet);
    }

    private static ItemStack deriveNewItemstack(int slot, ItemStack containingItem, ItemStack stack, int current) {
        ItemStack newTablet;
        if (slot == current) {
            newTablet = containingItem.m_41619_() ? new ItemStack((ItemLike)TabletModule.TABLET.get()) : new ItemStack((ItemLike)((ITabletSupport)containingItem.m_41720_()).getInstalledTablet());
            newTablet.m_41751_(stack.m_41783_());
        } else {
            newTablet = stack;
        }
        return newTablet;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            if (player.m_6144_()) {
                this.openTabletGui(player);
            } else {
                ItemStack containingItem = TabletItem.getContainingItem(stack, TabletItem.getCurrentSlot(stack));
                if (containingItem.m_41619_()) {
                    this.openTabletGui(player);
                } else if (containingItem.m_41720_() instanceof ITabletSupport) {
                    ((ITabletSupport)containingItem.m_41720_()).openGui(player, stack, containingItem);
                }
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private void openTabletGui(Player player) {
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

            @Nonnull
            public Component m_5446_() {
                return new TextComponent("Tablet");
            }

            public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory playerInventory, @Nonnull Player player) {
                TabletContainer container = new TabletContainer(id, player.m_142538_(), player);
                container.setupInventories((IItemHandler)new TabletItemHandler(player), playerInventory);
                return container;
            }
        });
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void m_7373_(@Nonnull ItemStack itemStack, Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flags) {
        super.m_7373_(itemStack, world, list, flags);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(this.getRegistryName(), itemStack, list, flags);
    }
}

