/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.various.items;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mcjty.lib.api.smartwrench.ISmartWrenchSelector;
import mcjty.lib.api.smartwrench.SmartWrench;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.modules.various.VariousModule;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.Lazy;

public class SmartWrenchItem
extends Item
implements SmartWrench,
ITooltipSettings {
    private final SmartWrenchMode mode;
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbase.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"info1", stack -> this.getMode().getName()), TooltipBuilder.parameter((String)"info2", stack -> SmartWrenchItem.getCurrentBlock(stack).map(BlockPosTools::toString).orElse("<not selected>"))});

    public SmartWrenchItem(SmartWrenchMode mode) {
        super(new Item.Properties().m_41487_(1).m_41491_(RFToolsBase.setup.getTab()));
        this.mode = mode;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            ItemStack newStack;
            SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(stack);
            CompoundTag tag = stack.m_41783_();
            if (mode == SmartWrenchMode.MODE_WRENCH) {
                mode = SmartWrenchMode.MODE_SELECT;
                newStack = new ItemStack((ItemLike)VariousModule.SMARTWRENCH_SELECT.get());
            } else {
                mode = SmartWrenchMode.MODE_WRENCH;
                newStack = new ItemStack((ItemLike)VariousModule.SMARTWRENCH.get());
            }
            newStack.m_41751_(tag);
            player.m_21008_(hand, newStack);
            Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Smart wrench is now in " + mode.getName() + " mode."));
        }
        return super.m_7203_(world, player, hand);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (!world.f_46443_) {
            BlockState state;
            Block block;
            Player player = context.m_43723_();
            InteractionHand hand = context.m_43724_();
            ItemStack stack = context.m_43722_();
            BlockPos pos = context.m_8083_();
            if (player != null && player.m_6144_() && (block = (state = world.m_8055_(pos)).m_60734_()) instanceof BaseBlock && state.m_60664_(world, player, hand, new BlockHitResult(context.m_43720_(), context.m_43719_(), pos, context.m_43721_())) == InteractionResult.SUCCESS) {
                return InteractionResult.SUCCESS;
            }
            SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(stack);
            if (mode == SmartWrenchMode.MODE_SELECT) {
                return SmartWrenchItem.getCurrentBlock(stack).map(b -> {
                    if (!b.m_122640_().equals((Object)world.m_46472_())) {
                        if (player != null) {
                            Logging.message((Player)player, (String)(ChatFormatting.RED + "The selected block is in another dimension!"));
                        }
                        return InteractionResult.FAIL;
                    }
                    BlockEntity te = world.m_7702_(b.m_122646_());
                    if (te instanceof ISmartWrenchSelector) {
                        ISmartWrenchSelector smartWrenchSelector = (ISmartWrenchSelector)te;
                        smartWrenchSelector.selectBlock(player, pos);
                    }
                    return InteractionResult.SUCCESS;
                }).orElse(InteractionResult.SUCCESS);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(@Nonnull ItemStack itemStack, Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flags) {
        super.m_7373_(itemStack, world, list, flags);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(this.getRegistryName(), itemStack, list, flags);
    }

    public SmartWrenchMode getMode() {
        return this.mode;
    }

    public SmartWrenchMode getMode(ItemStack itemStack) {
        return SmartWrenchItem.getCurrentMode(itemStack);
    }

    public static SmartWrenchMode getCurrentMode(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof SmartWrenchItem) {
            return ((SmartWrenchItem)itemStack.m_41720_()).getMode();
        }
        return SmartWrenchMode.MODE_WRENCH;
    }

    public static void setCurrentBlock(ItemStack itemStack, GlobalPos c) {
        CompoundTag tagCompound = itemStack.m_41784_();
        if (c == null) {
            tagCompound.m_128473_("selectedX");
            tagCompound.m_128473_("selectedY");
            tagCompound.m_128473_("selectedZ");
            tagCompound.m_128473_("selectedDim");
        } else {
            tagCompound.m_128405_("selectedX", c.m_122646_().m_123341_());
            tagCompound.m_128405_("selectedY", c.m_122646_().m_123342_());
            tagCompound.m_128405_("selectedZ", c.m_122646_().m_123343_());
            tagCompound.m_128359_("selectedDim", c.m_122640_().m_135782_().toString());
        }
    }

    @Nonnull
    public static Optional<GlobalPos> getCurrentBlock(ItemStack itemStack) {
        CompoundTag tagCompound = itemStack.m_41783_();
        if (tagCompound != null && tagCompound.m_128441_("selectedX")) {
            int x = tagCompound.m_128451_("selectedX");
            int y = tagCompound.m_128451_("selectedY");
            int z = tagCompound.m_128451_("selectedZ");
            String dim = tagCompound.m_128461_("selectedDim");
            return Optional.of(GlobalPos.m_122643_((ResourceKey)LevelTools.getId((String)dim), (BlockPos)new BlockPos(x, y, z)));
        }
        return Optional.empty();
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return 1;
    }
}

