/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.charginggadgets;

import com.direwolf20.charginggadgets.blocks.BlockRegistry;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="charginggadgets", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new GeneratorRecipes(generator));
            generator.m_123914_((DataProvider)new GeneratorLoots(generator));
        }
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new GeneratorBlockTags(generator, event.getExistingFileHelper()));
            generator.m_123914_((DataProvider)new GeneratorLanguage(generator));
            generator.m_123914_((DataProvider)new GeneratorBlockStates(generator, event.getExistingFileHelper()));
            generator.m_123914_((DataProvider)new GeneratorItemModels(generator, event.getExistingFileHelper()));
        }
    }

    static class GeneratorRecipes
    extends RecipeProvider {
        public GeneratorRecipes(DataGenerator generator) {
            super(generator);
        }

        protected void m_176531_(Consumer<FinishedRecipe> consumer) {
            Block block = (Block)BlockRegistry.CHARGING_STATION.get();
            ShapedRecipeBuilder.m_126116_((ItemLike)block).m_126121_(Character.valueOf('i'), (Tag)Tags.Items.INGOTS_IRON).m_126121_(Character.valueOf('r'), (Tag)Tags.Items.DUSTS_REDSTONE).m_126121_(Character.valueOf('l'), (Tag)Tags.Items.STORAGE_BLOCKS_COAL).m_126121_(Character.valueOf('d'), (Tag)Tags.Items.GEMS_LAPIS).m_126130_("iri").m_126130_("drd").m_126130_("ili").m_142284_("has_diamonds", (CriterionTriggerInstance)GeneratorRecipes.m_125975_((Tag)Tags.Items.GEMS_DIAMOND)).m_176498_(consumer);
        }
    }

    static class GeneratorLoots
    extends LootTableProvider {
        public GeneratorLoots(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootContextParamSets.f_81421_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)name, (LootTable)table));
        }

        private static class Blocks
        extends BlockLoot {
            private Blocks() {
            }

            protected void addTables() {
                LootPool.Builder builder = LootPool.m_79043_().name(((Block)BlockRegistry.CHARGING_STATION.get()).getRegistryName().toString()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ExplosionCondition.m_81661_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BlockRegistry.CHARGING_STATION.get())).m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)));
                this.m_124165_((Block)BlockRegistry.CHARGING_STATION.get(), LootTable.m_79147_().m_79161_(builder));
            }

            protected Iterable<Block> getKnownBlocks() {
                return ImmutableList.of((Object)((Block)BlockRegistry.CHARGING_STATION.get()));
            }
        }
    }

    static class GeneratorBlockTags
    extends BlockTagsProvider {
        public GeneratorBlockTags(DataGenerator generator, @Nullable ExistingFileHelper existingFileHelper) {
            super(generator, "charginggadgets", existingFileHelper);
        }

        protected void m_6577_() {
            this.m_126548_((Tag.Named)BlockTags.createOptional((ResourceLocation)((Block)BlockRegistry.CHARGING_STATION.get()).getRegistryName())).addTags(new Tag.Named[]{BlockTags.f_144282_});
        }
    }

    static class GeneratorLanguage
    extends LanguageProvider {
        public GeneratorLanguage(DataGenerator gen) {
            super(gen, "charginggadgets", "en_us");
        }

        protected void addTranslations() {
            this.addBlock((Supplier)BlockRegistry.CHARGING_STATION, "Charging Station");
            this.add("itemGroup.charginggadgets", "Charging Gadgets");
            this.add("screen.charginggadgets.energy", "Energy: %s/%s FE");
            this.add("screen.charginggadgets.no_fuel", "Fuel source empty");
            this.add("screen.charginggadgets.burn_time", "Burn time left: %ss");
        }
    }

    static class GeneratorBlockStates
    extends BlockStateProvider {
        public GeneratorBlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
            super(gen, "charginggadgets", exFileHelper);
        }

        protected void registerStatesAndModels() {
            this.horizontalBlock((Block)BlockRegistry.CHARGING_STATION.get(), (ModelFile)this.models().orientableWithBottom(((Block)BlockRegistry.CHARGING_STATION.get()).getRegistryName().m_135815_(), this.modLoc("blocks/charging_station_side"), this.modLoc("blocks/charging_station_fronton"), this.modLoc("blocks/charging_station_bottom"), this.modLoc("blocks/charging_station_top")));
        }
    }

    static class GeneratorItemModels
    extends ItemModelProvider {
        public GeneratorItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "charginggadgets", existingFileHelper);
        }

        protected void registerModels() {
            String path = ((Block)BlockRegistry.CHARGING_STATION.get()).getRegistryName().m_135815_();
            ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
        }

        public String m_6055_() {
            return "Item Models";
        }
    }
}

