/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz;

import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.fml.common.Mod;
import net.roguelogix.phosphophyllite.registry.Registry;
import net.roguelogix.phosphophyllite.repack.org.joml.AABBi;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.util.MethodsReturnNonnullByDefault;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.Mesh;
import net.roguelogix.quartz.internal.QuartzCore;

@Mod(value="quartz")
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class Quartz {
    public static final String modid = "quartz";
    public static EventBus EVENT_BUS = new EventBus(new BusBuilder().setTrackPhases(false));

    public Quartz() {
        new Registry();
    }

    public static Mesh createStaticMesh(BlockState blockState) {
        return Quartz.createStaticMesh((Mesh.Builder builder) -> Minecraft.m_91087_().m_91289_().renderSingleBlock(blockState, builder.matrixStack(), builder.bufferSource(), 0, 0, (IModelData)EmptyModelData.INSTANCE));
    }

    public static Mesh createStaticMesh(Consumer<Mesh.Builder> buildFunc) {
        return QuartzCore.INSTANCE.meshManager.createMesh(buildFunc);
    }

    public static DrawBatch getDrawBatchForBlock(BlockPos blockPos) {
        return Quartz.getDrawBatcherForSection(SectionPos.m_175568_((BlockPos)blockPos));
    }

    public static DrawBatch getDrawBatcherForBlock(Vector3ic blockPos) {
        return Quartz.getDrawBatcherForSection(SectionPos.m_123209_((int)(blockPos.x() >> 4), (int)(blockPos.y() >> 4), (int)(blockPos.z() >> 4)));
    }

    public static DrawBatch getDrawBatcherForSection(long sectionPos) {
        return QuartzCore.INSTANCE.getWorldEngine().getBatcherForSection(sectionPos);
    }

    public static DrawBatch getDrawBatcherForAABB(AABBi aabb) {
        return QuartzCore.INSTANCE.getWorldEngine().getBatcherForAABB(aabb);
    }
}

