/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.lang.ref.Cleaner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraftforge.eventbus.api.Event;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.Quartz;
import net.roguelogix.quartz.QuartzConfig;
import net.roguelogix.quartz.QuartzEvent;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.EventListener;
import net.roguelogix.quartz.internal.common.InternalMesh;
import net.roguelogix.quartz.internal.common.LightEngine;
import net.roguelogix.quartz.internal.gl.GLCore;
import net.roguelogix.quartz.internal.world.WorldEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class QuartzCore {
    public static final Logger LOGGER = LogManager.getLogger((String)"Quartz");
    @Nonnull
    public static final QuartzCore INSTANCE;
    public static final Cleaner CLEANER;
    private static boolean wasInit;
    public final WorldEngine worldEngine = new WorldEngine();
    public final LightEngine lightEngine = new LightEngine();
    public final InternalMesh.Manager meshManager = new InternalMesh.Manager(this.allocBuffer());

    @Nullable
    private static QuartzCore createCore(QuartzConfig.Mode mode) {
        return switch (mode) {
            case QuartzConfig.Mode.OpenGL33 -> GLCore.INSTANCE;
            case QuartzConfig.Mode.Automatic -> {
                for (QuartzConfig.Mode value : QuartzConfig.Mode.values()) {
                    if (value == QuartzConfig.Mode.Automatic) {
                        yield null;
                    }
                    QuartzCore core = QuartzCore.createCore(value);
                    if (core == null) continue;
                    yield core;
                }
                yield null;
            }
            default -> null;
        };
    }

    static void init() {
    }

    static void startup() {
        INSTANCE.startupInternal();
        Quartz.EVENT_BUS.post((Event)new QuartzEvent.Startup());
        wasInit = true;
    }

    protected abstract void startupInternal();

    public static void shutdown() {
        if (!wasInit) {
            return;
        }
        Quartz.EVENT_BUS.post((Event)new QuartzEvent.Shutdown());
        INSTANCE.shutdownInternal();
    }

    protected abstract void shutdownInternal();

    public static void resourcesReloaded() {
        if (!wasInit) {
            return;
        }
        QuartzCore.INSTANCE.meshManager.buildAllMeshes();
        INSTANCE.resourcesReloadedInternal();
    }

    protected abstract void resourcesReloadedInternal();

    public WorldEngine getWorldEngine() {
        return this.worldEngine;
    }

    public abstract DrawBatch createDrawBatch();

    public abstract Buffer allocBuffer();

    public abstract void frameStart(PoseStack var1, float var2, long var3, boolean var5, Camera var6, GameRenderer var7, LightTexture var8, Matrix4f var9);

    public abstract void lightUpdated();

    public abstract void preTerrainSetup();

    public abstract void preOpaque();

    public abstract void endOpaque();

    public abstract void endTranslucent();

    static {
        CLEANER = Cleaner.create();
        if (!Thread.currentThread().getStackTrace()[2].getClassName().equals(EventListener.class.getName())) {
            throw new IllegalStateException("Attempt to init quartz before it is ready");
        }
        LOGGER.info("Quartz Init");
        QuartzCore instance = QuartzCore.createCore(QuartzConfig.INSTANCE.mode);
        if (instance == null) {
            throw new IllegalStateException();
        }
        INSTANCE = instance;
        wasInit = false;
    }
}

