/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.common;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.roguelogix.phosphophyllite.repack.org.joml.Matrix4f;
import net.roguelogix.phosphophyllite.repack.org.joml.Matrix4fc;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3f;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3fc;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.util.MethodsReturnNonnullByDefault;
import net.roguelogix.quartz.DynamicMatrix;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.QuartzCore;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DynamicMatrixManager
implements DynamicMatrix.Manager {
    private final Buffer buffer;
    private final ObjectArrayList<WeakReference<Matrix>> rootMatrices = new ObjectArrayList();

    public DynamicMatrixManager(Buffer buffer) {
        this.buffer = buffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DynamicMatrix createMatrix(@Nullable DynamicMatrix.UpdateFunc updateFunc, @Nullable DynamicMatrix parent) {
        Matrix parentMatrix = null;
        if (parent != null) {
            if (!(parent instanceof Matrix)) throw new IllegalArgumentException("Parent matrix must be from the same manager");
            Matrix parentMat = (Matrix)parent;
            if (!this.owns(parentMatrix)) throw new IllegalArgumentException("Parent matrix must be from the same manager");
            parentMatrix = parentMat;
        }
        ObjectArrayList<WeakReference<Matrix>> list = parentMatrix == null ? this.rootMatrices : ((Matrix)parent).childMatrices;
        return new Matrix(this.buffer.alloc(128, 128), updateFunc, list);
    }

    @Override
    public boolean owns(@Nullable DynamicMatrix dynamicMatrix) {
        if (dynamicMatrix instanceof Matrix) {
            Matrix mat = (Matrix)dynamicMatrix;
            return mat.allocation.allocator() == this.buffer;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAll(long nanos, float partialTicks, Vector3i playerBlock, Vector3f playerPartialBlock) {
        ObjectArrayList<WeakReference<Matrix>> objectArrayList = this.rootMatrices;
        synchronized (objectArrayList) {
            for (int i = 0; i < this.rootMatrices.size(); ++i) {
                Matrix mat = (Matrix)((WeakReference)this.rootMatrices.get(i)).get();
                if (mat == null) continue;
                mat.update(nanos, partialTicks, playerBlock, playerPartialBlock);
            }
        }
        this.buffer.dirtyAll();
    }

    public static class Matrix
    implements DynamicMatrix {
        private final Buffer.Allocation allocation;
        private final Matrix4f transformMatrix = new Matrix4f();
        private final Matrix4f normalMatrix = new Matrix4f();
        private final ObjectArrayList<WeakReference<Matrix>> childMatrices = new ObjectArrayList();
        @Nullable
        private final DynamicMatrix.UpdateFunc updateFunc;

        public Matrix(Buffer.Allocation allocation, @Nullable DynamicMatrix.UpdateFunc updateFunc, ObjectArrayList<WeakReference<Matrix>> matrixList) {
            this.allocation = allocation;
            this.updateFunc = updateFunc;
            WeakReference<Matrix> ref = new WeakReference<Matrix>(this);
            matrixList.add(ref);
            QuartzCore.CLEANER.register(this, () -> {
                ObjectArrayList objectArrayList = matrixList;
                synchronized (objectArrayList) {
                    matrixList.remove((Object)ref);
                }
            });
        }

        @Override
        public void write(Matrix4fc matrixData) {
            this.transformMatrix.set(matrixData);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(long nanos, float partialTicks, Vector3i playerBlock, Vector3f playerPartialBlock) {
            if (this.updateFunc != null) {
                this.updateFunc.accept(this, nanos, partialTicks, (Vector3ic)playerBlock, (Vector3fc)playerPartialBlock);
            }
            this.transformMatrix.normal(this.normalMatrix);
            this.transformMatrix.get(0, this.allocation.buffer());
            this.normalMatrix.get(64, this.allocation.buffer());
            ObjectArrayList<WeakReference<Matrix>> objectArrayList = this.childMatrices;
            synchronized (objectArrayList) {
                for (int i = 0; i < this.childMatrices.size(); ++i) {
                    Matrix mat = (Matrix)((WeakReference)this.childMatrices.get(i)).get();
                    if (mat == null) continue;
                    mat.update(nanos, partialTicks, playerBlock, playerPartialBlock);
                }
            }
        }

        public int id() {
            return this.allocation.offset() / 128;
        }
    }
}

