/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.common;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3f;
import net.roguelogix.phosphophyllite.util.MethodsReturnNonnullByDefault;
import net.roguelogix.quartz.Mesh;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.QuartzCore;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class InternalMesh
implements Mesh {
    public Consumer<Mesh.Builder> buildFunc;

    public InternalMesh(Consumer<Mesh.Builder> buildFunc) {
        this.buildFunc = buildFunc;
    }

    public Object2LongArrayMap<RenderType> build(Function<Integer, ByteBuffer> bufferCreator) {
        Builder builder = new Builder();
        this.buildFunc.accept(builder);
        ByteBuffer buffer = bufferCreator.apply(builder.bytesRequired());
        return builder.build(buffer);
    }

    @Override
    public void rebuild() {
        QuartzCore.INSTANCE.meshManager.buildMesh(this);
    }

    private static class Builder
    implements Mesh.Builder,
    MultiBufferSource {
        private final PoseStack poseStack = new PoseStack();
        private final HashMap<RenderType, BufferBuilder> buffers = new HashMap();

        Builder() {
        }

        @Override
        public MultiBufferSource bufferSource() {
            return this;
        }

        @Override
        public PoseStack matrixStack() {
            return this.poseStack;
        }

        public VertexConsumer m_6299_(RenderType renderType) {
            return this.buffers.computeIfAbsent(renderType, e -> new BufferBuilder());
        }

        int bytesRequired() {
            int totalVertices = 0;
            for (Map.Entry<RenderType, BufferBuilder> entry : this.buffers.entrySet()) {
                RenderType renderType = entry.getKey();
                BufferBuilder bufferBuilder = entry.getValue();
                int vertexCount = bufferBuilder.vertices.size() - bufferBuilder.vertices.size() % renderType.m_173186_().f_166947_;
                if (vertexCount == 0) continue;
                totalVertices += vertexCount;
            }
            return totalVertices * 32;
        }

        /*
         * Unable to fully structure code
         */
        Object2LongArrayMap<RenderType> build(ByteBuffer masterBuffer) {
            drawInfoMap = new Object2LongArrayMap();
            currentByteIndex = 0;
            for (Map.Entry<RenderType, BufferBuilder> entry : this.buffers.entrySet()) {
                renderType = entry.getKey();
                bufferBuilder = entry.getValue();
                vertexCount = bufferBuilder.vertices.size() - bufferBuilder.vertices.size() % renderType.m_173186_().f_166947_;
                if (vertexCount == 0) continue;
                offsetAndSize = (long)(currentByteIndex / 32) << 32 | (long)vertexCount;
                byteBuf = masterBuffer.slice(currentByteIndex, vertexCount * 32);
                byteBuf.order(ByteOrder.nativeOrder());
                currentByteIndex += vertexCount * 32;
                tempNormalVec = new Vector3f();
                v0 = quadType = renderType.m_173186_() == VertexFormat.Mode.QUADS;
                if (!quadType) {
                    vertexIndex = 0;
                    for (Vertex vertex : bufferBuilder.vertices) {
                        if (vertexIndex <= vertexCount) {
                            byteBuf.putFloat(vertex.x);
                            byteBuf.putFloat(vertex.y);
                            byteBuf.putFloat(vertex.z);
                            byteBuf.putInt(vertex.rgba);
                            byteBuf.putFloat(vertex.texU);
                            byteBuf.putFloat(vertex.texV);
                            packedA = 0;
                            packedB = 0;
                            packedA |= (vertex.lightmapU & 255) << 24;
                            packedA |= (vertex.lightmapV & 255) << 16;
                            tempNormalVec.set(vertex.normalX, vertex.normalY, vertex.normalZ);
                            tempNormalVec.normalize(32767.0f);
                            packedB |= ((int)tempNormalVec.y & 65535) << 16;
                            byteBuf.putInt(packedA |= (int)tempNormalVec.x & 65535);
                            byteBuf.putInt(packedB |= (int)tempNormalVec.z & 65535);
                            ++vertexIndex;
                            continue;
                        }
                        break;
                    }
                } else {
                    vertexIndex = 0;
                    iter = bufferBuilder.vertices.iterator();
                    currentVertices = new Vertex[4];
                    block2: while (true) {
                        for (i = 0; i < 4; ++i) {
                            if (vertexIndex <= vertexCount && iter.hasNext()) {
                                currentVertices[i] = (Vertex)iter.next();
                                ++vertexIndex;
                                continue;
                            }
                            break block2;
                        }
                        packedLightA = 0;
                        packedLightB = 0;
                        packedLightA |= currentVertices[0].lightmapU & 63;
                        packedLightA |= (currentVertices[0].lightmapV & 63) << 6;
                        packedLightA |= (currentVertices[1].lightmapU & 63) << 12;
                        packedLightA |= (currentVertices[1].lightmapV & 63) << 18;
                        packedLightB |= currentVertices[2].lightmapU & 63;
                        packedLightB |= (currentVertices[2].lightmapV & 63) << 6;
                        packedLightB |= (currentVertices[3].lightmapU & 63) << 12;
                        packedLightB |= (currentVertices[3].lightmapV & 63) << 18;
                        i = 0;
                        while (true) {
                            if (i >= 4) ** continue;
                            vertex = currentVertices[i];
                            byteBuf.putInt(Float.floatToIntBits(vertex.x));
                            byteBuf.putInt(Float.floatToIntBits(vertex.y));
                            byteBuf.putInt(Float.floatToIntBits(vertex.z));
                            byteBuf.putInt(vertex.rgba);
                            byteBuf.putInt(Float.floatToIntBits(vertex.texU));
                            byteBuf.putInt(Float.floatToIntBits(vertex.texV));
                            packedA = packedLightA;
                            packedB = packedLightB;
                            tempNormalVec.set(vertex.normalX, vertex.normalY, vertex.normalZ);
                            tempNormalVec.normalize(7.0f);
                            packedA |= Builder.packInt((int)tempNormalVec.x, 24, 4);
                            packedB |= Builder.packInt((int)tempNormalVec.z, 24, 4);
                            byteBuf.putInt(packedA |= Builder.packInt((int)tempNormalVec.y, 28, 4));
                            byteBuf.putInt(packedB |= (i & 3) << 28);
                            ++i;
                        }
                        break;
                    }
                }
                drawInfoMap.put((Object)renderType, offsetAndSize);
            }
            return drawInfoMap;
        }

        private static int packInt(int value, int position, int width) {
            int signBitMask = 1 << width - 1;
            int bitMask = signBitMask - 1;
            int returnVal = value & bitMask;
            return (returnVal |= value >> 32 - width & signBitMask) << position;
        }

        private static int extractInt(int packed, int pos, int width) {
            int signBitMask = 1 << width - 1;
            int bitMask = signBitMask - 1;
            int val = ~bitMask * ((signBitMask & (packed >>= pos)) != 0 ? 1 : 0);
            return val |= packed & bitMask;
        }

        private static class BufferBuilder
        implements VertexConsumer {
            Vertex currentVertex = new Vertex();
            final LinkedList<Vertex> vertices = new LinkedList();
            private boolean defaultColorSet = false;
            private int drgba;

            private BufferBuilder() {
            }

            public VertexConsumer m_5483_(double x, double y, double z) {
                this.currentVertex.x = (float)x;
                this.currentVertex.y = (float)y;
                this.currentVertex.z = (float)z;
                return this;
            }

            public VertexConsumer m_6122_(int r, int g, int b, int a) {
                this.currentVertex.rgba = r << 24 | g << 16 | b << 8 | a;
                return this;
            }

            public VertexConsumer m_7421_(float u, float v) {
                this.currentVertex.texU = u;
                this.currentVertex.texV = v;
                return this;
            }

            public VertexConsumer m_7122_(int oU, int oV) {
                return this;
            }

            public VertexConsumer m_7120_(int u2, int v2) {
                this.currentVertex.lightmapU = u2;
                this.currentVertex.lightmapV = v2;
                return this;
            }

            public VertexConsumer m_5601_(float nx, float ny, float nz) {
                this.currentVertex.normalX = nx;
                this.currentVertex.normalY = ny;
                this.currentVertex.normalZ = nz;
                return this;
            }

            public void m_5752_() {
                this.vertices.add(this.currentVertex);
                this.currentVertex = new Vertex(this.currentVertex);
                if (this.defaultColorSet) {
                    this.currentVertex.rgba = this.drgba;
                }
            }

            public void m_142461_(int r, int g, int b, int a) {
                this.drgba = r << 24 | g << 16 | b << 8 | a;
                this.defaultColorSet = true;
            }

            public void m_141991_() {
                this.defaultColorSet = false;
            }
        }

        private static class Vertex {
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            float normalX = 0.0f;
            float normalY = 0.0f;
            float normalZ = 0.0f;
            int rgba = -1;
            float texU = 0.0f;
            float texV = 0.0f;
            int lightmapU = 0;
            int lightmapV = 0;

            Vertex() {
            }

            Vertex(Vertex toCopy) {
                this.x = toCopy.x;
                this.y = toCopy.y;
                this.z = toCopy.z;
                this.normalX = toCopy.normalX;
                this.normalY = toCopy.normalY;
                this.normalZ = toCopy.normalZ;
                this.rgba = toCopy.rgba;
                this.texU = toCopy.texU;
                this.texV = toCopy.texV;
                this.lightmapU = toCopy.lightmapU;
                this.lightmapV = toCopy.lightmapV;
            }
        }
    }

    public static class Manager {
        private final ObjectArrayList<TrackedMesh> trackedMeshes = new ObjectArrayList();
        public final Buffer vertexBuffer;

        public Manager(Buffer vertexBuffer) {
            this.vertexBuffer = vertexBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InternalMesh createMesh(Consumer<Mesh.Builder> buildFunc) {
            InternalMesh staticMesh = new InternalMesh(buildFunc);
            TrackedMesh trackedMesh = new TrackedMesh(new WeakReference<InternalMesh>(staticMesh), this.vertexBuffer);
            ObjectArrayList<TrackedMesh> objectArrayList = this.trackedMeshes;
            synchronized (objectArrayList) {
                this.trackedMeshes.add((Object)trackedMesh);
            }
            QuartzCore.CLEANER.register(staticMesh, () -> {
                ObjectArrayList<TrackedMesh> objectArrayList = this.trackedMeshes;
                synchronized (objectArrayList) {
                    this.trackedMeshes.remove((Object)trackedMesh);
                }
            });
            return staticMesh;
        }

        @Nullable
        public TrackedMesh getMeshInfo(Mesh mesh) {
            for (int i = 0; i < this.trackedMeshes.size(); ++i) {
                TrackedMesh trackedMesh = (TrackedMesh)this.trackedMeshes.get(i);
                if (trackedMesh.meshRef.get() != mesh) continue;
                return trackedMesh;
            }
            return null;
        }

        public void buildAllMeshes() {
            for (TrackedMesh value : this.trackedMeshes) {
                this.buildTrackedMesh(value);
            }
        }

        public void buildMesh(Mesh mesh) {
            TrackedMesh trackedMesh = this.getMeshInfo(mesh);
            if (trackedMesh != null) {
                this.buildTrackedMesh(trackedMesh);
            }
        }

        private void buildTrackedMesh(TrackedMesh trackedMesh) {
            trackedMesh.rebuild();
        }

        public static class TrackedMesh {
            public final WeakReference<InternalMesh> meshRef;
            private final Buffer vertexBuffer;
            private Buffer.Allocation vertexAllocation;
            private final Object2ObjectArrayMap<RenderType, Component> drawInfo = new Object2ObjectArrayMap();
            private final ObjectArrayList<Consumer<TrackedMesh>> buildCallbacks = new ObjectArrayList();

            public TrackedMesh(WeakReference<InternalMesh> meshRef, Buffer vertexBuffer) {
                this.meshRef = meshRef;
                this.vertexBuffer = vertexBuffer;
            }

            void rebuild() {
                Object2LongArrayMap<RenderType> rawDrawInfo;
                InternalMesh mesh = (InternalMesh)this.meshRef.get();
                if (mesh == null) {
                    return;
                }
                this.drawInfo.clear();
                try {
                    rawDrawInfo = mesh.build(this::allocBuffer);
                    this.vertexAllocation.dirty();
                }
                finally {
                    if (this.vertexAllocation != null) {
                        this.vertexAllocation.unlock();
                    }
                }
                for (Object2LongMap.Entry renderTypeEntry : rawDrawInfo.object2LongEntrySet()) {
                    RenderType renderType = (RenderType)renderTypeEntry.getKey();
                    long drawLong = renderTypeEntry.getLongValue();
                    Component drawComponent = new Component((int)(drawLong >> 32) + this.vertexAllocation.offset() / 32, (int)drawLong);
                    this.drawInfo.put((Object)renderType, (Object)drawComponent);
                }
                for (int i = 0; i < this.buildCallbacks.size(); ++i) {
                    ((Consumer)this.buildCallbacks.get(i)).accept(this);
                }
            }

            private ByteBuffer allocBuffer(int size) {
                this.vertexAllocation = this.vertexAllocation != null ? this.vertexBuffer.realloc(this.vertexAllocation, size, 32) : this.vertexBuffer.alloc(size, 32);
                this.vertexAllocation.lock();
                return this.vertexAllocation.buffer();
            }

            public Collection<RenderType> usedRenderTypes() {
                return this.drawInfo.keySet();
            }

            @Nullable
            public Component renderTypeComponent(RenderType renderType) {
                return (Component)this.drawInfo.get((Object)renderType);
            }

            public void addBuildCallback(Consumer<TrackedMesh> consumer) {
                this.buildCallbacks.add(consumer);
            }

            public void removeBuildCallback(Consumer<TrackedMesh> consumer) {
                this.buildCallbacks.remove(consumer);
            }

            public record Component(int vertexOffset, int vertexCount) {
            }
        }
    }
}

