/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl;

import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.roguelogix.phosphophyllite.util.MethodsReturnNonnullByDefault;
import net.roguelogix.quartz.internal.common.ShaderInfo;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GLRenderPass {
    public final boolean QUAD;
    public final boolean TEXTURE;
    public final boolean LIGHTING;
    public final boolean ALPHA_DISCARD;
    public final int VERTICES_PER_PRIMITIVE;
    public final int GL_MODE;
    private final ResourceLocation textureResourceLocation;
    private AbstractTexture texture;
    private static final Object2ObjectOpenHashMap<RenderType, GLRenderPass> renderPasses = new Object2ObjectOpenHashMap();

    public static void resourcesReloaded() {
        for (GLRenderPass value : renderPasses.values()) {
            value.resourceReload();
        }
    }

    public static GLRenderPass renderPassForRenderType(RenderType renderType) {
        return (GLRenderPass)renderPasses.computeIfAbsent((Object)renderType, type -> {
            GLRenderPass renderPass = new GLRenderPass(renderType);
            for (GLRenderPass potentialPass : renderPasses.values()) {
                if (!potentialPass.compatible(renderPass)) continue;
                return potentialPass;
            }
            return renderPass;
        });
    }

    private GLRenderPass(RenderType rawRenderType) {
        RenderStateShard.EmptyTextureStateShard emptyTextureStateShard;
        if (!(rawRenderType instanceof RenderType.CompositeRenderType)) {
            throw new IllegalArgumentException("RenderType must be composite type");
        }
        RenderType.CompositeRenderType renderType = (RenderType.CompositeRenderType)rawRenderType;
        RenderType.CompositeState compositeState = renderType.m_173265_();
        ShaderInfo shaderInfo = ShaderInfo.get(compositeState.f_173274_);
        if (shaderInfo == null) {
            throw new IllegalArgumentException("Unsupported RenderType shader" + rawRenderType);
        }
        this.QUAD = renderType.m_173186_() == VertexFormat.Mode.QUADS;
        this.TEXTURE = compositeState.f_110576_ != RenderStateShard.f_110147_;
        this.LIGHTING = compositeState.f_110583_ != RenderStateShard.f_110153_;
        this.ALPHA_DISCARD = shaderInfo.ALPHA_DISCARD;
        if (this.TEXTURE && (emptyTextureStateShard = compositeState.f_110576_) instanceof RenderStateShard.TextureStateShard) {
            RenderStateShard.TextureStateShard texShard = (RenderStateShard.TextureStateShard)emptyTextureStateShard;
            this.textureResourceLocation = texShard.m_142706_().orElse(null);
            if (this.textureResourceLocation == null) {
                throw new IllegalArgumentException("No Texture found for texture state shard");
            }
        } else {
            this.textureResourceLocation = null;
        }
        this.VERTICES_PER_PRIMITIVE = switch (renderType.m_173186_()) {
            case VertexFormat.Mode.LINES -> 2;
            case VertexFormat.Mode.TRIANGLES -> 3;
            case VertexFormat.Mode.QUADS -> 4;
            default -> throw new IllegalArgumentException("Unsupported primitive type");
        };
        this.GL_MODE = switch (renderType.m_173186_()) {
            case VertexFormat.Mode.LINES -> 6913;
            case VertexFormat.Mode.TRIANGLES, VertexFormat.Mode.QUADS -> 4;
            default -> throw new IllegalArgumentException("Unsupported primitive type");
        };
        this.resourceReload();
    }

    public boolean compatible(GLRenderPass otherPass) {
        return this.QUAD == otherPass.QUAD && this.TEXTURE == otherPass.TEXTURE && this.LIGHTING == otherPass.LIGHTING && this.ALPHA_DISCARD == otherPass.ALPHA_DISCARD && this.VERTICES_PER_PRIMITIVE == otherPass.VERTICES_PER_PRIMITIVE && this.GL_MODE == otherPass.GL_MODE && this.textureResourceLocation.equals((Object)otherPass.textureResourceLocation);
    }

    @Nullable
    public AbstractTexture texture() {
        return this.texture;
    }

    private void resourceReload() {
        this.texture = Minecraft.m_91087_().m_91097_().m_118506_(this.textureResourceLocation);
    }
}

