/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.capability.oxygen;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.mrscauthd.beyond_earth.capability.oxygen.CapabilityOxygen;
import net.mrscauthd.beyond_earth.capability.oxygen.IOxygenStorage;

public class OxygenUtil {
    public static IOxygenStorage getItemStackOxygenStorage(ItemStack itemStack) {
        IOxygenStorage oxygenStorage = (IOxygenStorage)itemStack.getCapability(CapabilityOxygen.OXYGEN).orElse(null);
        if (oxygenStorage != null) {
            return oxygenStorage;
        }
        return null;
    }

    public static boolean canReceive(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        IOxygenStorage storageInItemStack = OxygenUtil.getItemStackOxygenStorage(itemStack);
        return storageInItemStack != null && storageInItemStack.receiveOxygen(1, true) > 0;
    }

    public static boolean canExtract(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        IOxygenStorage storageInItemStack = OxygenUtil.getItemStackOxygenStorage(itemStack);
        return storageInItemStack != null && storageInItemStack.extractOxygen(1, true) > 0;
    }

    public static ItemStack makeFull(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return itemStack;
        }
        IOxygenStorage storageInItemStack = OxygenUtil.getItemStackOxygenStorage(itemStack);
        if (storageInItemStack != null) {
            storageInItemStack.receiveOxygen(storageInItemStack.getMaxOxygenStored(), false);
        }
        return itemStack;
    }

    public static boolean fillSink(IItemHandlerModifiable itemHandler, int sinkItemSlot, IOxygenStorage source, int transfer) {
        ItemStack sinkItemStack = itemHandler.getStackInSlot(sinkItemSlot);
        return OxygenUtil.fillSinkCapability(source, sinkItemStack, transfer) > 0;
    }

    public static int fillSinkCapability(IOxygenStorage source, ItemStack sinkItemStack, int transfer) {
        IOxygenStorage sink = OxygenUtil.getItemStackOxygenStorage(sinkItemStack);
        return OxygenUtil.tryTransfer(sink, source, transfer);
    }

    public static boolean drainSource(IItemHandlerModifiable itemHandler, int sourceItemSlot, IOxygenStorage sink, int transfer) {
        ItemStack sourceItemStack = itemHandler.getStackInSlot(sourceItemSlot);
        return OxygenUtil.drainSourceCapability(sink, sourceItemStack, transfer) > 0;
    }

    public static int drainSourceCapability(IOxygenStorage sink, ItemStack sourceItemStack, int transfer) {
        IOxygenStorage source = OxygenUtil.getItemStackOxygenStorage(sourceItemStack);
        return OxygenUtil.tryTransfer(sink, source, transfer);
    }

    public static int tryTransfer(IOxygenStorage sink, IOxygenStorage source, int transfer) {
        int extracted;
        int receivableAmount;
        int extractableAmount;
        int received = 0;
        if (sink != null && source != null && transfer > 0 && (extractableAmount = source.extractOxygen(transfer, true)) > 0 && (receivableAmount = sink.receiveOxygen(extractableAmount, true)) > 0 && (extracted = source.extractOxygen(receivableAmount, false)) > 0) {
            received = sink.receiveOxygen(extracted, false);
        }
        return received;
    }

    private OxygenUtil() {
    }
}

