/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.compat.waila;

import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.ui.IElement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.mrscauthd.beyond_earth.compat.waila.BlockDataProvider;
import net.mrscauthd.beyond_earth.compat.waila.EntityDataProvider;
import net.mrscauthd.beyond_earth.compat.waila.GaugeValueElement;
import net.mrscauthd.beyond_earth.gauge.GaugeValueRenderer;
import net.mrscauthd.beyond_earth.gauge.GaugeValueSerializer;
import net.mrscauthd.beyond_earth.gauge.IGaugeValue;

@mcp.mobius.waila.api.WailaPlugin
public class WailaPlugin
implements IWailaPlugin {
    public static final ResourceLocation DATA_KEY = new ResourceLocation("beyond_earth", "waila_datakey");

    public static ListTag write(List<IGaugeValue> list) {
        ListTag nbt = new ListTag();
        list.stream().map(GaugeValueSerializer.Serializer::serialize).forEach(arg_0 -> nbt.add(arg_0));
        return nbt;
    }

    public static List<IGaugeValue> read(ListTag nbt) {
        ArrayList<IGaugeValue> list = new ArrayList<IGaugeValue>();
        nbt.stream().map(h -> (CompoundTag)h).map(GaugeValueSerializer.Serializer::deserialize).forEach(list::add);
        return list;
    }

    public static ListTag get(CompoundTag compound) {
        return compound.m_128437_(DATA_KEY.toString(), 10);
    }

    public static void put(CompoundTag compound, ListTag nbt) {
        compound.m_128365_(DATA_KEY.toString(), (Tag)nbt);
    }

    public static void appendTooltip(ITooltip tooltip, CompoundTag serverData) {
        ListTag list = WailaPlugin.get(serverData);
        for (int i = 0; i < list.size(); ++i) {
            IGaugeValue value = GaugeValueSerializer.Serializer.deserialize(list.m_128728_(i));
            tooltip.add((IElement)new GaugeValueElement(new GaugeValueRenderer(value)));
        }
    }

    public void register(IRegistrar registrar) {
        registrar.registerBlockDataProvider((IServerDataProvider)BlockDataProvider.INSTANCE, BlockEntity.class);
        registrar.registerComponentProvider((IComponentProvider)BlockDataProvider.INSTANCE, TooltipPosition.BODY, Block.class);
        registrar.registerEntityDataProvider((IServerDataProvider)EntityDataProvider.INSTANCE, Entity.class);
        registrar.registerComponentProvider((IEntityComponentProvider)EntityDataProvider.INSTANCE, TooltipPosition.BODY, Entity.class);
    }
}

