/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.crafting;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.crafting.AlienTradingRecipeItemStackBase;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeSerializer;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeTypes;
import org.apache.commons.lang3.tuple.Triple;

public class AlienTradingRecipeEnchantedBook
extends AlienTradingRecipeItemStackBase {
    private int costBaseLevelMultiplier = 3;
    private int costRangeBase = 5;
    private int costRangeLevelMultiplier = 10;
    private int costTreasureOnlyMultiplier = 2;

    public AlienTradingRecipeEnchantedBook(ResourceLocation id, JsonObject json) {
        super(id, json);
        this.costBaseLevelMultiplier = GsonHelper.m_13824_((JsonObject)json, (String)"costBaseLevelMultiplier", (int)this.costBaseLevelMultiplier);
        this.costRangeBase = GsonHelper.m_13824_((JsonObject)json, (String)"costRangeBase", (int)this.costRangeBase);
        this.costRangeLevelMultiplier = GsonHelper.m_13824_((JsonObject)json, (String)"costRangeLevelMultiplier", (int)this.costRangeLevelMultiplier);
        this.costTreasureOnlyMultiplier = GsonHelper.m_13824_((JsonObject)json, (String)"costTreasureOnlyMultiplier", (int)this.costTreasureOnlyMultiplier);
    }

    public AlienTradingRecipeEnchantedBook(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, buffer);
        this.costBaseLevelMultiplier = buffer.readInt();
        this.costRangeBase = buffer.readInt();
        this.costRangeLevelMultiplier = buffer.readInt();
        this.costTreasureOnlyMultiplier = buffer.readInt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeInt(this.costBaseLevelMultiplier);
        buffer.writeInt(this.costRangeBase);
        buffer.writeInt(this.costRangeLevelMultiplier);
        buffer.writeInt(this.costTreasureOnlyMultiplier);
    }

    @Override
    public Triple<ItemStack, ItemStack, ItemStack> getTrade(Entity trader, Random rand) {
        List list = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(Enchantment::m_6594_).collect(Collectors.toList());
        Enchantment enchantment = (Enchantment)list.get(rand.nextInt(list.size()));
        int level = Mth.m_14072_((Random)rand, (int)enchantment.m_44702_(), (int)enchantment.m_6586_());
        ItemStack costA = this.getCostA();
        ItemStack costB = this.getCostB();
        int cost = costA.m_41613_() + level * this.getCostBaseLevelMultiplier();
        int bound = this.getCostRangeBase() + level * this.getCostRangeLevelMultiplier();
        if (bound > 0) {
            cost += rand.nextInt(bound);
        }
        if (enchantment.m_6591_()) {
            cost *= this.getCostTreasureOnlyMultiplier();
        }
        costA.m_41764_(Math.min(cost, costA.m_41741_()));
        ItemStack itemstack = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, level));
        return Triple.of((Object)costA, (Object)costB, (Object)itemstack);
    }

    public int getCostBaseLevelMultiplier() {
        return this.costBaseLevelMultiplier;
    }

    public int getCostRangeBase() {
        return this.costRangeBase;
    }

    public int getCostRangeLevelMultiplier() {
        return this.costRangeLevelMultiplier;
    }

    public int getCostTreasureOnlyMultiplier() {
        return this.costTreasureOnlyMultiplier;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModInit.RECIPE_SERIALIZER_ALIEN_TRADING_ENCHANTEDBOOK.get();
    }

    public RecipeType<?> m_6671_() {
        return BeyondEarthRecipeTypes.ALIEN_TRADING_ENCHANTEDBOOK;
    }

    public static class Serializer
    extends BeyondEarthRecipeSerializer<AlienTradingRecipeEnchantedBook> {
        public AlienTradingRecipeEnchantedBook fromJson(ResourceLocation id, JsonObject json) {
            return new AlienTradingRecipeEnchantedBook(id, json);
        }

        public AlienTradingRecipeEnchantedBook fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            return new AlienTradingRecipeEnchantedBook(id, buffer);
        }

        public void toNetwork(FriendlyByteBuf buffer, AlienTradingRecipeEnchantedBook recipe) {
            recipe.write(buffer);
        }
    }
}

