/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.crafting;

import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.crafting.AlienTradingRecipeItemStack;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeSerializer;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeTypes;
import org.apache.commons.lang3.tuple.Triple;

public class AlienTradingRecipeEnchantedItem
extends AlienTradingRecipeItemStack {
    private int levelBase = 5;
    private int levelRange = 15;
    private int costBaseLevelMultiplier = 1;
    private int costRangeBase = 0;
    private int costRangeLevelMultiplier = 0;

    public AlienTradingRecipeEnchantedItem(ResourceLocation id, JsonObject json) {
        super(id, json);
        this.levelBase = GsonHelper.m_13824_((JsonObject)json, (String)"levelBase", (int)this.levelBase);
        this.levelRange = GsonHelper.m_13824_((JsonObject)json, (String)"levelRange", (int)this.levelRange);
        this.costBaseLevelMultiplier = GsonHelper.m_13824_((JsonObject)json, (String)"costBaseLevelMultiplier", (int)this.costBaseLevelMultiplier);
        this.costRangeBase = GsonHelper.m_13824_((JsonObject)json, (String)"costRangeBase", (int)this.costRangeBase);
        this.costRangeLevelMultiplier = GsonHelper.m_13824_((JsonObject)json, (String)"costRangeLevelMultiplier", (int)this.costRangeLevelMultiplier);
    }

    public AlienTradingRecipeEnchantedItem(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, buffer);
        this.levelBase = buffer.readInt();
        this.levelRange = buffer.readInt();
        this.costBaseLevelMultiplier = buffer.readInt();
        this.costRangeBase = buffer.readInt();
        this.costRangeLevelMultiplier = buffer.readInt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeInt(this.levelBase);
        buffer.writeInt(this.levelRange);
        buffer.writeInt(this.costBaseLevelMultiplier);
        buffer.writeInt(this.costRangeBase);
        buffer.writeInt(this.costRangeLevelMultiplier);
    }

    @Override
    public Triple<ItemStack, ItemStack, ItemStack> getTrade(Entity trader, Random rand) {
        int level = this.getLevelBase();
        int bound1 = this.getLevelRange();
        ItemStack costA = this.getCostA();
        ItemStack costB = this.getCostB();
        if (bound1 > 0) {
            level += rand.nextInt(bound1);
        }
        int cost = costA.m_41613_() + level * this.getCostBaseLevelMultiplier();
        int bound2 = this.getCostRangeBase() + level * this.getCostRangeLevelMultiplier();
        if (bound2 > 0) {
            cost += rand.nextInt(bound2);
        }
        costA.m_41764_(Math.min(cost, costA.m_41741_()));
        ItemStack result = EnchantmentHelper.m_44877_((Random)rand, (ItemStack)this.getResult(trader, rand), (int)level, (boolean)false);
        return Triple.of((Object)costA, (Object)costB, (Object)result);
    }

    public int getLevelBase() {
        return this.levelBase;
    }

    public int getLevelRange() {
        return this.levelRange;
    }

    public int getCostBaseLevelMultiplier() {
        return this.costBaseLevelMultiplier;
    }

    public int getCostRangeBase() {
        return this.costRangeBase;
    }

    public int getCostRangeLevelMultiplier() {
        return this.costRangeLevelMultiplier;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModInit.RECIPE_SERIALIZER_ALIEN_TRADING_ENCHANTEDITEM.get();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return BeyondEarthRecipeTypes.ALIEN_TRADING_ENCHANTEDITEM;
    }

    public static class Serializer
    extends BeyondEarthRecipeSerializer<AlienTradingRecipeEnchantedItem> {
        public AlienTradingRecipeEnchantedItem fromJson(ResourceLocation id, JsonObject json) {
            return new AlienTradingRecipeEnchantedItem(id, json);
        }

        public AlienTradingRecipeEnchantedItem fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            return new AlienTradingRecipeEnchantedItem(id, buffer);
        }

        public void toNetwork(FriendlyByteBuf buffer, AlienTradingRecipeEnchantedItem recipe) {
            recipe.write(buffer);
        }
    }
}

