/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.entity;

import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.block.RocketLaunchPad;
import net.mrscauthd.beyond_earth.entity.VehicleEntity;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.fluid.FluidUtil2;
import net.mrscauthd.beyond_earth.gui.screens.rocket.RocketGui;

public class RocketTier4Entity
extends VehicleEntity {
    public double ar = 0.0;
    public double ay = 0.0;
    public double ap = 0.0;
    public static final EntityDataAccessor<Boolean> ROCKET_START = SynchedEntityData.m_135353_(RocketTier4Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> BUCKETS = SynchedEntityData.m_135353_(RocketTier4Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> FUEL = SynchedEntityData.m_135353_(RocketTier4Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> START_TIMER = SynchedEntityData.m_135353_(RocketTier4Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final double ROCKET_SPEED = 0.9;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory});

    public RocketTier4Entity(EntityType type, Level world) {
        super(type, world);
        this.f_19804_.m_135372_(ROCKET_START, (Object)false);
        this.f_19804_.m_135372_(BUCKETS, (Object)0);
        this.f_19804_.m_135372_(FUEL, (Object)0);
        this.f_19804_.m_135372_(START_TIMER, (Object)0);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0);
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public void m_7334_(Entity p_21294_) {
    }

    @Deprecated
    public boolean canBeRiddenInWater() {
        return true;
    }

    public double m_6048_() {
        return super.m_6048_() - 2.85;
    }

    @Nullable
    public ItemStack m_142340_() {
        ItemStack itemStack = new ItemStack((ItemLike)ModInit.TIER_4_ROCKET_ITEM.get(), 1);
        itemStack.m_41784_().m_128405_("beyond_earth:fuel", ((Integer)this.m_20088_().m_135370_(FUEL)).intValue());
        itemStack.m_41784_().m_128405_("beyond_earth:buckets", ((Integer)this.m_20088_().m_135370_(BUCKETS)).intValue());
        return itemStack;
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Vec3[] avector3d = new Vec3[]{RocketTier4Entity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)livingEntity.m_146908_()), RocketTier4Entity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() - 22.5f)), RocketTier4Entity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() + 22.5f)), RocketTier4Entity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() - 45.0f)), RocketTier4Entity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() + 45.0f))};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.m_142469_().f_82292_;
        double d1 = this.m_142469_().f_82289_ - 0.5;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Vec3 vector3d : avector3d) {
            blockpos$mutable.m_122169_(this.m_20185_() + vector3d.f_82479_, d0, this.m_20189_() + vector3d.f_82481_);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockpos$mutable.m_7949_());
                blockpos$mutable.m_122173_(Direction.DOWN);
            }
        }
        for (BlockPos blockpos : set) {
            double d3;
            if (this.f_19853_.m_6425_(blockpos).m_76153_((Tag)FluidTags.f_13132_) || !DismountHelper.m_38439_((double)(d3 = this.f_19853_.m_45573_(blockpos)))) continue;
            Vec3 vector3d1 = Vec3.m_82514_((Vec3i)blockpos, (double)d3);
            for (Pose pose : livingEntity.m_7431_()) {
                AABB axisalignedbb = livingEntity.m_21270_(pose);
                if (!DismountHelper.m_38439_((double)this.f_19853_.m_45573_(blockpos))) continue;
                livingEntity.m_20124_(pose);
                return vector3d1;
            }
        }
        return new Vec3(this.m_20185_(), this.m_142469_().f_82292_, this.m_20189_());
    }

    public void m_6074_() {
        this.dropEquipment();
        this.spawnRocketItem();
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public boolean m_6469_(DamageSource source, float p_21017_) {
        Entity sourceentity = source.m_7639_();
        if (!source.m_19360_() && sourceentity != null && sourceentity.m_6047_() && !this.m_20160_()) {
            this.dropEquipment();
            this.spawnRocketItem();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return false;
    }

    protected void spawnRocketItem() {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemStack = new ItemStack((ItemLike)ModInit.TIER_4_ROCKET_ITEM.get(), 1);
            itemStack.m_41784_().m_128405_("beyond_earth:fuel", ((Integer)this.m_20088_().m_135370_(FUEL)).intValue());
            itemStack.m_41784_().m_128405_("beyond_earth:buckets", ((Integer)this.m_20088_().m_135370_(BUCKETS)).intValue());
            ItemEntity entityToSpawn = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), itemStack);
            entityToSpawn.m_32010_(10);
            this.f_19853_.m_7967_((Entity)entityToSpawn);
        }
    }

    protected void dropEquipment() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.m_6084_() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
            return LazyOptional.of(() -> this.combined).cast();
        }
        return super.getCapability(capability, side);
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).resolve().get();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        compound.m_128365_("InventoryCustom", (net.minecraft.nbt.Tag)this.inventory.serializeNBT());
        compound.m_128379_("rocket_start", ((Boolean)this.f_19804_.m_135370_(ROCKET_START)).booleanValue());
        compound.m_128405_("buckets", ((Integer)this.f_19804_.m_135370_(BUCKETS)).intValue());
        compound.m_128405_("fuel", ((Integer)this.f_19804_.m_135370_(FUEL)).intValue());
        compound.m_128405_("start_timer", ((Integer)this.f_19804_.m_135370_(START_TIMER)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        net.minecraft.nbt.Tag inventoryCustom = compound.m_128423_("InventoryCustom");
        if (inventoryCustom instanceof CompoundTag) {
            this.inventory.deserializeNBT((CompoundTag)inventoryCustom);
        }
        this.f_19804_.m_135381_(ROCKET_START, (Object)compound.m_128471_("rocket_start"));
        this.f_19804_.m_135381_(BUCKETS, (Object)compound.m_128451_("buckets"));
        this.f_19804_.m_135381_(FUEL, (Object)compound.m_128451_("fuel"));
        this.f_19804_.m_135381_(START_TIMER, (Object)compound.m_128451_("start_timer"));
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        super.m_6096_(player, hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        if (player instanceof ServerPlayer && player.m_6047_()) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return new TranslatableComponent("container.entity.beyond_earth.rocket_t4");
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.m_130130_(RocketTier4Entity.this.m_142049_());
                    return new RocketGui.GuiContainer(id, inventory, packetBuffer);
                }
            }, buf -> buf.m_130130_(this.m_142049_()));
            return retval;
        }
        player.m_20329_((Entity)this);
        return retval;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        if (((Boolean)this.f_19804_.m_135370_(ROCKET_START)).booleanValue()) {
            this.ar += 1.0;
            if (this.ar == 1.0) {
                this.ay += 0.006;
                this.ap += 0.006;
            }
            if (this.ar == 2.0) {
                this.ar = 0.0;
                this.ay = 0.0;
                this.ap = 0.0;
            }
            if ((Integer)this.f_19804_.m_135370_(START_TIMER) < 200) {
                this.f_19804_.m_135381_(START_TIMER, (Object)((Integer)this.f_19804_.m_135370_(START_TIMER) + 1));
            }
            if ((Integer)this.f_19804_.m_135370_(START_TIMER) == 200) {
                if (this.m_20184_().m_7098_() < 0.8) {
                    this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ + 0.1, this.m_20184_().f_82481_);
                } else {
                    this.m_20334_(this.m_20184_().f_82479_, 0.9, this.m_20184_().f_82481_);
                }
            }
            if (y > 600.0 && !this.m_20197_().isEmpty()) {
                Entity pass = (Entity)this.m_20197_().get(0);
                pass.getPersistentData().m_128379_("beyond_earth:planet_selection_gui_open", true);
                pass.getPersistentData().m_128359_("beyond_earth:rocket_type", this.m_6095_().toString());
                pass.getPersistentData().m_128359_("beyond_earth:slot0", this.inventory.getStackInSlot(0).m_41720_().getRegistryName().toString());
                pass.m_20242_(true);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else if (y > 600.0 && this.m_20197_().isEmpty()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            Vec3 vec = this.m_20184_();
            if ((Integer)this.f_19804_.m_135370_(START_TIMER) == 200) {
                if (this.f_19853_ instanceof ServerLevel) {
                    for (ServerPlayer p : ((ServerLevel)this.f_19853_).m_142572_().m_6846_().m_11314_()) {
                        float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.90999997f;
                        float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.90999997f;
                        ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ModInit.LARGE_FLAME_PARTICLE.get(), true, this.m_20185_() - vec.f_82479_, this.m_20186_() - vec.f_82480_ - 2.9, this.m_20189_() - vec.f_82481_, 20, 0.1, 0.1, 0.1, 0.001);
                        ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ModInit.LARGE_SMOKE_PARTICLE.get(), true, this.m_20185_() - vec.f_82479_, this.m_20186_() - vec.f_82480_ - 3.9, this.m_20189_() - vec.f_82481_, 10, 0.1, 0.1, 0.1, 0.04);
                        ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ModInit.SMALL_FLAME_PARTICLE.get(), true, this.m_20185_() + (double)f2, this.m_20186_() - vec.f_82480_ - 2.3, this.m_20189_() + (double)f3, 20, 0.1, 0.1, 0.1, 0.001);
                        ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ModInit.SMALL_SMOKE_PARTICLE.get(), true, this.m_20185_() + (double)f2, this.m_20186_() - vec.f_82480_ - 3.3, this.m_20189_() + (double)f3, 10, 0.1, 0.1, 0.1, 0.04);
                        ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ModInit.SMALL_FLAME_PARTICLE.get(), true, this.m_20185_() - (double)f2, this.m_20186_() - vec.f_82480_ - 2.3, this.m_20189_() - (double)f3, 20, 0.1, 0.1, 0.1, 0.001);
                        ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ModInit.SMALL_SMOKE_PARTICLE.get(), true, this.m_20185_() - (double)f2, this.m_20186_() - vec.f_82480_ - 3.3, this.m_20189_() - (double)f3, 10, 0.1, 0.1, 0.1, 0.04);
                    }
                }
            } else if (this.f_19853_ instanceof ServerLevel) {
                for (ServerPlayer p : ((ServerLevel)this.f_19853_).m_142572_().m_6846_().m_11314_()) {
                    ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ParticleTypes.f_123777_, true, this.m_20185_() - vec.f_82479_, this.m_20186_() - vec.f_82480_ - 0.1, this.m_20189_() - vec.f_82481_, 6, 0.1, 0.1, 0.1, 0.023);
                }
            }
        }
        if (Methods.tagCheck(FluidUtil2.findBucketFluid(this.inventory.getStackInSlot(0).m_41720_()), ModInit.FLUID_VEHICLE_FUEL_TAG) && (Integer)this.f_19804_.m_135370_(BUCKETS) < 3) {
            if ((Integer)this.f_19804_.m_135370_(FUEL) == 0 && (Integer)this.f_19804_.m_135370_(BUCKETS) == 0) {
                this.inventory.setStackInSlot(0, new ItemStack((ItemLike)Items.f_42446_));
                this.m_20088_().m_135381_(BUCKETS, (Object)((Integer)this.m_20088_().m_135370_(BUCKETS) + 1));
            } else if ((Integer)this.m_20088_().m_135370_(FUEL) == 100 && (Integer)this.m_20088_().m_135370_(BUCKETS) == 1) {
                this.inventory.setStackInSlot(0, new ItemStack((ItemLike)Items.f_42446_));
                this.m_20088_().m_135381_(BUCKETS, (Object)((Integer)this.m_20088_().m_135370_(BUCKETS) + 1));
            } else if ((Integer)this.m_20088_().m_135370_(FUEL) == 200 && (Integer)this.m_20088_().m_135370_(BUCKETS) == 2) {
                this.inventory.setStackInSlot(0, new ItemStack((ItemLike)Items.f_42446_));
                this.m_20088_().m_135381_(BUCKETS, (Object)((Integer)this.m_20088_().m_135370_(BUCKETS) + 1));
            }
        }
        if ((Integer)this.m_20088_().m_135370_(BUCKETS) == 1 && (Integer)this.m_20088_().m_135370_(FUEL) < 100) {
            this.m_20088_().m_135381_(FUEL, (Object)((Integer)this.m_20088_().m_135370_(FUEL) + 1));
        } else if ((Integer)this.m_20088_().m_135370_(BUCKETS) == 2 && (Integer)this.m_20088_().m_135370_(FUEL) < 200) {
            this.m_20088_().m_135381_(FUEL, (Object)((Integer)this.m_20088_().m_135370_(FUEL) + 1));
        } else if ((Integer)this.m_20088_().m_135370_(BUCKETS) == 3 && (Integer)this.m_20088_().m_135370_(FUEL) < 300) {
            this.m_20088_().m_135381_(FUEL, (Object)((Integer)this.m_20088_().m_135370_(FUEL) + 1));
        }
        if (this.m_20096_() || this.m_20069_()) {
            BlockState state = this.f_19853_.m_8055_(new BlockPos(Math.floor(x), y - 0.1, Math.floor(z)));
            if (!this.f_19853_.m_46859_(new BlockPos(Math.floor(x), y - 0.01, Math.floor(z))) && state.m_60734_() instanceof RocketLaunchPad && !((Boolean)state.m_61143_((Property)RocketLaunchPad.STAGE)).booleanValue() || this.f_19853_.m_8055_(new BlockPos(Math.floor(x), Math.floor(y), Math.floor(z))).m_60734_() != ((Block)ModInit.ROCKET_LAUNCH_PAD.get()).m_49966_().m_60734_()) {
                this.dropEquipment();
                this.spawnRocketItem();
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }
}

