/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.entity.renderer.flag;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.beyond_earth.entity.renderer.flag.TileEntityHeadModel;
import net.mrscauthd.beyond_earth.flag.FlagBlock;
import net.mrscauthd.beyond_earth.flag.FlagTileEntity;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityHeadRenderer
implements BlockEntityRenderer<FlagTileEntity> {
    private static final Map<FlagBlock.ISkullType, TileEntityHeadModel> MODELS = (Map)Util.m_137469_((Object)Maps.newHashMap(), p_209262_0_ -> {
        Minecraft minecraft = Minecraft.m_91087_();
        Map<String, ModelPart> map = Map.of("head", new TileEntityHeadModel((ModelPart)minecraft.m_167973_().m_171103_((ModelLayerLocation)TileEntityHeadModel.LAYER_LOCATION)).head);
        ModelPart modelPart = new ModelPart(Collections.emptyList(), map);
        TileEntityHeadModel genericheadmodel = new TileEntityHeadModel(modelPart);
        p_209262_0_.put(FlagBlock.Types.PLAYER, genericheadmodel);
    });
    private static final Map<FlagBlock.ISkullType, ResourceLocation> SKINS = (Map)Util.m_137469_((Object)Maps.newHashMap(), p_209263_0_ -> p_209263_0_.put(FlagBlock.Types.PLAYER, DefaultPlayerSkin.m_118626_()));

    public TileEntityHeadRenderer(BlockEntityRendererProvider.Context context) {
    }

    public boolean shouldRenderOffScreen(FlagTileEntity p_112306_) {
        return true;
    }

    public int m_142163_() {
        return 256;
    }

    public boolean shouldRender(FlagTileEntity p_173568_, Vec3 p_173569_) {
        return Vec3.m_82512_((Vec3i)p_173568_.m_58899_()).m_82542_(1.0, 0.0, 1.0).m_82509_((Position)p_173569_.m_82542_(1.0, 0.0, 1.0), (double)this.m_142163_());
    }

    public static Map<SkullBlock.Type, TileEntityHeadModel> createSkullRenderers(EntityModelSet p_173662_) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)SkullBlock.Types.PLAYER, (Object)new TileEntityHeadModel(p_173662_.m_171103_(ModelLayers.f_171163_)));
        return builder.build();
    }

    public void render(FlagTileEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntityIn.m_58900_().m_61143_(FlagBlock.HALF) == DoubleBlockHalf.UPPER) {
            BlockState blockstate = tileEntityIn.m_58900_();
            boolean flag = blockstate.m_60734_() instanceof FlagBlock;
            Direction direction = flag ? (Direction)blockstate.m_61143_((Property)FlagBlock.FACING) : null;
            TileEntityHeadRenderer.render(direction, ((Direction)blockstate.m_61143_((Property)FlagBlock.FACING)).m_122435_(), ((FlagBlock)blockstate.m_60734_()).getSkullType(), tileEntityIn.getPlayerProfile(), 0.0f, matrixStackIn, bufferIn, combinedLightIn);
        }
    }

    public static void render(@Nullable Direction directionIn, float p_228879_1_, FlagBlock.ISkullType skullType, @Nullable GameProfile gameProfileIn, float animationProgress, PoseStack matrixStackIn, MultiBufferSource buffer, int combinedLight) {
        TileEntityHeadModel genericheadmodel = MODELS.get(skullType);
        matrixStackIn.m_85836_();
        if (directionIn == null) {
            matrixStackIn.m_85837_(0.5, 0.0, 0.5);
        } else {
            matrixStackIn.m_85837_((double)(0.5f - (float)directionIn.m_122429_() * 0.25f), 0.25, (double)(0.5f - (float)directionIn.m_122431_() * 0.25f));
        }
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        VertexConsumer ivertexbuilder = buffer.m_6299_(TileEntityHeadRenderer.getRenderType(skullType, gameProfileIn));
        genericheadmodel.m_142698_(animationProgress, p_228879_1_, 0.0f);
        genericheadmodel.m_7695_(matrixStackIn, ivertexbuilder, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
    }

    private static RenderType getRenderType(FlagBlock.ISkullType skullType, @Nullable GameProfile gameProfileIn) {
        ResourceLocation resourcelocation = SKINS.get(skullType);
        if (skullType == FlagBlock.Types.PLAYER && gameProfileIn != null) {
            Minecraft minecraft = Minecraft.m_91087_();
            Map map = minecraft.m_91109_().m_118815_(gameProfileIn);
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? RenderType.m_110473_((ResourceLocation)minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : RenderType.m_110458_((ResourceLocation)DefaultPlayerSkin.m_118627_((UUID)Player.m_36198_((GameProfile)gameProfileIn)));
        }
        return RenderType.m_110464_((ResourceLocation)resourcelocation);
    }
}

