/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.events;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.netty.buffer.Unpooled;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.capability.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.capability.oxygen.OxygenUtil;
import net.mrscauthd.beyond_earth.entity.LanderEntity;
import net.mrscauthd.beyond_earth.entity.RocketTier1Entity;
import net.mrscauthd.beyond_earth.entity.RocketTier2Entity;
import net.mrscauthd.beyond_earth.entity.RocketTier3Entity;
import net.mrscauthd.beyond_earth.entity.RocketTier4Entity;
import net.mrscauthd.beyond_earth.entity.VehicleEntity;
import net.mrscauthd.beyond_earth.events.Config;
import net.mrscauthd.beyond_earth.events.forgeevents.LivingSetFireInHotPlanetEvent;
import net.mrscauthd.beyond_earth.events.forgeevents.LivingSetVenusRainEvent;
import net.mrscauthd.beyond_earth.gui.screens.planetselection.PlanetSelectionGui;
import net.mrscauthd.beyond_earth.item.VehicleItem;

public class Methods {
    public static final ResourceKey<Level> moon = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "moon"));
    public static final ResourceKey<Level> moon_orbit = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "moon_orbit"));
    public static final ResourceKey<Level> mars = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "mars"));
    public static final ResourceKey<Level> mars_orbit = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "mars_orbit"));
    public static final ResourceKey<Level> mercury = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "mercury"));
    public static final ResourceKey<Level> mercury_orbit = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "mercury_orbit"));
    public static final ResourceKey<Level> venus = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "venus"));
    public static final ResourceKey<Level> venus_orbit = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "venus_orbit"));
    public static final ResourceKey<Level> glacio = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "glacio"));
    public static final ResourceKey<Level> glacio_orbit = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "glacio_orbit"));
    public static final ResourceKey<Level> overworld = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("overworld"));
    public static final ResourceKey<Level> overworld_orbit = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "overworld_orbit"));

    public static void worldTeleport(Player entity, ResourceKey<Level> planet, double high) {
        ServerLevel nextLevel = entity.m_20194_().m_129880_(planet);
        if (nextLevel != null && entity instanceof ServerPlayer) {
            ((ServerPlayer)entity).f_8906_.m_141995_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132157_, 0.0f));
            ((ServerPlayer)entity).m_8999_(nextLevel, entity.m_20185_(), high, entity.m_20189_(), entity.m_146908_(), entity.m_146909_());
            ((ServerPlayer)entity).f_8906_.m_141995_((Packet)new ClientboundPlayerAbilitiesPacket(entity.m_150110_()));
            for (MobEffectInstance effectinstance : entity.m_21220_()) {
                ((ServerPlayer)entity).f_8906_.m_141995_((Packet)new ClientboundUpdateMobEffectPacket(entity.m_142049_(), effectinstance));
            }
            ((ServerPlayer)entity).f_8906_.m_141995_((Packet)new ClientboundSetExperiencePacket(entity.f_36080_, entity.f_36079_, entity.f_36078_));
        }
    }

    public static boolean netheriteSpaceSuitCheck(LivingEntity entity) {
        Boolean item3 = Methods.checkArmor(entity, 3, (Item)ModInit.NETHERITE_OXYGEN_MASK.get());
        Boolean item2 = Methods.checkArmor(entity, 2, (Item)ModInit.NETHERITE_SPACE_SUIT.get());
        Boolean item1 = Methods.checkArmor(entity, 1, (Item)ModInit.NETHERITE_SPACE_PANTS.get());
        Boolean item0 = Methods.checkArmor(entity, 0, (Item)ModInit.NETHERITE_SPACE_BOOTS.get());
        return item0 != false && item1 != false && item2 != false && item3 != false;
    }

    public static boolean spaceSuitCheck(LivingEntity entity) {
        Boolean item3 = Methods.checkArmor(entity, 3, (Item)ModInit.OXYGEN_MASK.get());
        Boolean item2 = Methods.checkArmor(entity, 2, (Item)ModInit.SPACE_SUIT.get());
        Boolean item1 = Methods.checkArmor(entity, 1, (Item)ModInit.SPACE_PANTS.get());
        Boolean item0 = Methods.checkArmor(entity, 0, (Item)ModInit.SPACE_BOOTS.get());
        return item0 != false && item1 != false && item2 != false && item3 != false;
    }

    public static boolean spaceSuitCheckBoth(LivingEntity entity) {
        Boolean item3 = Methods.checkArmor(entity, 3, (Item)ModInit.OXYGEN_MASK.get());
        Boolean item2 = Methods.checkArmor(entity, 2, (Item)ModInit.SPACE_SUIT.get());
        Boolean item1 = Methods.checkArmor(entity, 1, (Item)ModInit.SPACE_PANTS.get());
        Boolean item0 = Methods.checkArmor(entity, 0, (Item)ModInit.SPACE_BOOTS.get());
        Boolean item3_2 = Methods.checkArmor(entity, 3, (Item)ModInit.NETHERITE_OXYGEN_MASK.get());
        Boolean item2_2 = Methods.checkArmor(entity, 2, (Item)ModInit.NETHERITE_SPACE_SUIT.get());
        Boolean item1_2 = Methods.checkArmor(entity, 1, (Item)ModInit.NETHERITE_SPACE_PANTS.get());
        Boolean item0_2 = Methods.checkArmor(entity, 0, (Item)ModInit.NETHERITE_SPACE_BOOTS.get());
        Boolean check3 = false;
        Boolean check2 = false;
        Boolean check1 = false;
        Boolean check0 = false;
        if (item3.booleanValue() || item3_2.booleanValue()) {
            check3 = true;
        }
        if (item2.booleanValue() || item2_2.booleanValue()) {
            check2 = true;
        }
        if (item1.booleanValue() || item1_2.booleanValue()) {
            check1 = true;
        }
        if (item0.booleanValue() || item0_2.booleanValue()) {
            check0 = true;
        }
        return check0 != false && check1 != false && check2 != false && check3 != false;
    }

    public static boolean checkArmor(LivingEntity entity, int number, Item item) {
        return entity.m_6844_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)number)).m_41720_() == item;
    }

    public static boolean isSpaceWorld(Level world) {
        return Methods.isWorld(world, moon) || Methods.isWorld(world, moon_orbit) || Methods.isWorld(world, mars) || Methods.isWorld(world, mars_orbit) || Methods.isWorld(world, mercury) || Methods.isWorld(world, mercury_orbit) || Methods.isWorld(world, venus) || Methods.isWorld(world, venus_orbit) || Methods.isWorld(world, glacio) || Methods.isWorld(world, glacio_orbit) || Methods.isWorld(world, overworld_orbit);
    }

    public static boolean isSpaceWorldWithoutOxygen(Level world) {
        return Methods.isWorld(world, moon) || Methods.isWorld(world, moon_orbit) || Methods.isWorld(world, mars) || Methods.isWorld(world, mars_orbit) || Methods.isWorld(world, mercury) || Methods.isWorld(world, mercury_orbit) || Methods.isWorld(world, venus) || Methods.isWorld(world, venus_orbit) || Methods.isWorld(world, glacio_orbit) || Methods.isWorld(world, overworld_orbit);
    }

    public static boolean isOrbitWorld(Level world) {
        return Methods.isWorld(world, overworld_orbit) || Methods.isWorld(world, moon_orbit) || Methods.isWorld(world, mars_orbit) || Methods.isWorld(world, mercury_orbit) || Methods.isWorld(world, venus_orbit) || Methods.isWorld(world, glacio_orbit);
    }

    public static boolean isWorld(Level world, ResourceKey<Level> loc) {
        return world.m_46472_() == loc;
    }

    public static void OxygenDamage(LivingEntity entity) {
        entity.m_6469_(ModInit.DAMAGE_SOURCE_OXYGEN, 1.0f);
    }

    public static boolean isRocket(Entity entity) {
        return entity instanceof RocketTier1Entity || entity instanceof RocketTier2Entity || entity instanceof RocketTier3Entity || entity instanceof RocketTier4Entity;
    }

    public static boolean AllVehiclesOr(Entity entity) {
        return entity instanceof VehicleEntity;
    }

    public static void RocketSounds(Entity entity, Level world) {
        world.m_6269_(null, entity, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("beyond_earth", "rocket_fly")), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public static void DropRocket(Player player) {
        Item item1 = player.m_21205_().m_41720_();
        Item item2 = player.m_21206_().m_41720_();
        if (item1 instanceof VehicleItem && item2 instanceof VehicleItem) {
            ItemEntity spawn = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)item2));
            spawn.m_32010_(0);
            player.f_19853_.m_7967_((Entity)spawn);
            player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(capability -> capability.extractItem(40, 1, false));
        }
    }

    public static void PlanetFire(LivingEntity entity, ResourceKey<Level> planet1, ResourceKey<Level> planet2) {
        Level level = entity.f_19853_;
        if (!(!Methods.isWorld(level, planet1) && !Methods.isWorld(level, planet2) || Methods.netheriteSpaceSuitCheck(entity) || entity.m_21023_(MobEffects.f_19607_) || entity.m_5825_() || !(entity instanceof Mob) && !(entity instanceof Player) || MinecraftForge.EVENT_BUS.post((Event)new LivingSetFireInHotPlanetEvent(entity)) || Methods.tagCheck((Entity)entity, "beyond_earth:entities/planet_fire"))) {
            entity.m_20254_(10);
        }
    }

    public static void VenusRain(LivingEntity entity, ResourceKey<Level> planet) {
        if (!Methods.isWorld(entity.f_19853_, planet)) {
            return;
        }
        if (entity.m_20159_() && (Methods.isRocket(entity.m_20202_()) || entity.m_20202_() instanceof LanderEntity)) {
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new LivingSetVenusRainEvent(entity))) {
            return;
        }
        if (Methods.tagCheck((Entity)entity, "beyond_earth:entities/venus_rain")) {
            return;
        }
        if (entity.f_19853_.m_6106_().m_6533_() && (double)entity.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)Math.floor(entity.m_20185_()), (int)Math.floor(entity.m_20189_())) <= Math.floor(entity.m_20186_()) + 1.0) {
            entity.m_6469_(ModInit.DAMAGE_SOURCE_ACID_RAIN, 1.0f);
        }
    }

    public static void EntityOxygen(LivingEntity entity, Level world) {
        if (((Boolean)Config.ENTITY_OXYGEN_SYSTEM.get()).booleanValue() && Methods.isSpaceWorldWithoutOxygen(world) && Methods.tagCheck((Entity)entity, "beyond_earth:entities/oxygen") && !entity.m_21023_((MobEffect)ModInit.OXYGEN_EFFECT.get())) {
            entity.getPersistentData().m_128347_("beyond_earth:oxygen_tick", entity.getPersistentData().m_128459_("beyond_earth:oxygen_tick") + 1.0);
            if (entity.getPersistentData().m_128459_("beyond_earth:oxygen_tick") > 15.0) {
                if (!world.f_46443_) {
                    Methods.OxygenDamage(entity);
                }
                entity.getPersistentData().m_128347_("beyond_earth:oxygen_tick", 0.0);
            }
        }
        if (((Boolean)Config.ENTITY_OXYGEN_SYSTEM.get()).booleanValue() && entity.m_21023_((MobEffect)ModInit.OXYGEN_EFFECT.get())) {
            entity.m_20301_(300);
        }
    }

    public static void vehicleRotation(Entity vehicle, float roation) {
        vehicle.m_146922_(vehicle.m_146908_() + roation);
        vehicle.m_5618_(vehicle.m_146908_());
        vehicle.f_19859_ = vehicle.m_146908_();
    }

    public static void noFuelMessage(Player player) {
        if (!player.f_19853_.f_46443_) {
            player.m_5661_((Component)new TranslatableComponent("message.beyond_earth.no_fuel"), false);
        }
    }

    public static void holdSpaceMessage(Player player) {
        if (!player.f_19853_.f_46443_) {
            player.m_5661_((Component)new TranslatableComponent("message.beyond_earth.hold_space"), false);
        }
    }

    public static boolean tagCheck(Entity entity, String tag) {
        return EntityTypeTags.m_13126_().m_7689_(new ResourceLocation(tag)).m_8110_((Object)entity.m_6095_());
    }

    public static boolean tagCheck(Fluid fluid, ResourceLocation tag) {
        return FluidTags.m_144299_().m_7689_(tag).m_8110_((Object)fluid);
    }

    public static boolean tagCheck(Item item, ResourceLocation tag) {
        return ItemTags.m_13193_().m_7689_(tag).m_8110_((Object)item);
    }

    public static void landerTeleport(Player player, ResourceKey<Level> newPlanet) {
        LanderEntity lander = (LanderEntity)player.m_20202_();
        if (player.m_20186_() < 1.0) {
            ItemStack slot_0 = lander.getInventory().getStackInSlot(0);
            ItemStack slot_1 = lander.getInventory().getStackInSlot(1);
            lander.m_142687_(Entity.RemovalReason.DISCARDED);
            Methods.worldTeleport(player, newPlanet, 700.0);
            Level newWorld = player.f_19853_;
            if (!player.f_19853_.f_46443_) {
                LanderEntity entityToSpawn = new LanderEntity((EntityType)ModInit.LANDER.get(), newWorld);
                entityToSpawn.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0f, 0.0f);
                newWorld.m_7967_((Entity)entityToSpawn);
                entityToSpawn.getInventory().setStackInSlot(0, slot_0);
                entityToSpawn.getInventory().setStackInSlot(1, slot_1);
                player.m_20329_((Entity)entityToSpawn);
            }
        }
    }

    public static void rocketTeleport(Player player, ResourceKey<Level> planet, ItemStack rocketItem, Boolean SpaceStation) {
        if (!Methods.isWorld(player.f_19853_, planet)) {
            Methods.worldTeleport(player, planet, 700.0);
        } else {
            player.m_6034_(player.m_20185_(), 700.0, player.m_20189_());
            if (player instanceof ServerPlayer) {
                ((ServerPlayer)player).f_8906_.m_9774_(player.m_20185_(), 700.0, player.m_20189_(), player.m_146908_(), player.m_146909_());
            }
        }
        Level world = player.f_19853_;
        if (!world.f_46443_) {
            LanderEntity landerSpawn = new LanderEntity((EntityType)ModInit.LANDER.get(), world);
            landerSpawn.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0f, 0.0f);
            world.m_7967_((Entity)landerSpawn);
            String itemId = player.getPersistentData().m_128461_("beyond_earth:slot0");
            landerSpawn.getInventory().setStackInSlot(0, new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), 1));
            landerSpawn.getInventory().setStackInSlot(1, rocketItem);
            if (SpaceStation.booleanValue()) {
                Methods.createSpaceStation(player, (ServerLevel)world);
            }
            Methods.cleanUpPlayerNBT(player);
            player.m_20329_((Entity)landerSpawn);
        }
    }

    public static void createSpaceStation(Player player, ServerLevel serverWorld) {
        BlockPos pos = new BlockPos(player.m_20185_() - 15.5, 100.0, player.m_20189_() - 15.5);
        serverWorld.m_8875_().m_74341_(new ResourceLocation("beyond_earth", "space_station")).m_74536_((ServerLevelAccessor)serverWorld, pos, pos, new StructurePlaceSettings(), serverWorld.f_46441_, 2);
    }

    public static void cleanUpPlayerNBT(Player player) {
        player.getPersistentData().m_128379_("beyond_earth:planet_selection_gui_open", false);
        player.getPersistentData().m_128359_("beyond_earth:rocket_type", "");
        player.getPersistentData().m_128359_("beyond_earth:slot0", "");
    }

    public static void openPlanetGui(Player player) {
        if (!(player.f_36096_ instanceof PlanetSelectionGui.GuiContainer) && player.getPersistentData().m_128471_("beyond_earth:planet_selection_gui_open") && player instanceof ServerPlayer) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return new TextComponent("Planet Selection");
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.m_130070_(player.getPersistentData().m_128461_("beyond_earth:rocket_type"));
                    return new PlanetSelectionGui.GuiContainer(id, inventory, packetBuffer);
                }
            }, buf -> buf.m_130070_(player.getPersistentData().m_128461_("beyond_earth:rocket_type")));
        }
    }

    public static void teleportButton(Player player, ResourceKey<Level> planet, Boolean SpaceStation) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_41852_, 1);
        if (player.getPersistentData().m_128461_("beyond_earth:rocket_type").equals("entity.beyond_earth.rocket_t1")) {
            itemStack = new ItemStack((ItemLike)ModInit.TIER_1_ROCKET_ITEM.get(), 1);
        }
        if (player.getPersistentData().m_128461_("beyond_earth:rocket_type").equals("entity.beyond_earth.rocket_t2")) {
            itemStack = new ItemStack((ItemLike)ModInit.TIER_2_ROCKET_ITEM.get(), 1);
        }
        if (player.getPersistentData().m_128461_("beyond_earth:rocket_type").equals("entity.beyond_earth.rocket_t3")) {
            itemStack = new ItemStack((ItemLike)ModInit.TIER_3_ROCKET_ITEM.get(), 1);
        }
        if (player.getPersistentData().m_128461_("beyond_earth:rocket_type").equals("entity.beyond_earth.rocket_t4")) {
            itemStack = new ItemStack((ItemLike)ModInit.TIER_4_ROCKET_ITEM.get(), 1);
        }
        Methods.rocketTeleport(player, planet, itemStack, SpaceStation);
    }

    public static void landerTeleportOrbit(Player player, Level world) {
        if (Methods.isWorld(world, overworld_orbit)) {
            Methods.landerTeleport(player, overworld);
        }
        if (Methods.isWorld(world, moon_orbit)) {
            Methods.landerTeleport(player, moon);
        }
        if (Methods.isWorld(world, mars_orbit)) {
            Methods.landerTeleport(player, mars);
        }
        if (Methods.isWorld(world, glacio_orbit)) {
            Methods.landerTeleport(player, glacio);
        }
        if (Methods.isWorld(world, mercury_orbit)) {
            Methods.landerTeleport(player, mercury);
        }
        if (Methods.isWorld(world, venus_orbit)) {
            Methods.landerTeleport(player, venus);
        }
    }

    public static void playerFalltoPlanet(Level world, Player player) {
        ResourceKey world2 = world.m_46472_();
        if (world2 == overworld_orbit) {
            Methods.worldTeleport(player, overworld, 450.0);
        }
        if (world2 == moon_orbit) {
            Methods.worldTeleport(player, moon, 450.0);
        }
        if (world2 == mars_orbit) {
            Methods.worldTeleport(player, mars, 450.0);
        }
        if (world2 == mercury_orbit) {
            Methods.worldTeleport(player, mercury, 450.0);
        }
        if (world2 == venus_orbit) {
            Methods.worldTeleport(player, venus, 450.0);
        }
        if (world2 == glacio_orbit) {
            Methods.worldTeleport(player, glacio, 450.0);
        }
    }

    public static void extractArmorOxygenUsingTimer(ItemStack itemstack, Player player) {
        if (!player.m_150110_().f_35937_ && !player.m_5833_() && Methods.spaceSuitCheckBoth((LivingEntity)player) && !player.m_21023_((MobEffect)ModInit.OXYGEN_EFFECT.get()) && ((Boolean)Config.PLAYER_OXYGEN_SYSTEM.get()).booleanValue() && (Methods.isSpaceWorldWithoutOxygen(player.f_19853_) || player.m_19941_((Tag)FluidTags.f_13131_))) {
            IOxygenStorage oxygenStorage = OxygenUtil.getItemStackOxygenStorage(itemstack);
            CompoundTag persistentData = player.getPersistentData();
            String key = "beyond_earth:oxygen_timer";
            int oxygenTimer = persistentData.m_128451_(key);
            if (oxygenStorage.getOxygenStored() > 0 && ++oxygenTimer > 3) {
                oxygenStorage.extractOxygen(1, false);
                oxygenTimer = 0;
            }
            persistentData.m_128405_(key, oxygenTimer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderArm(PoseStack poseStack, MultiBufferSource bufferSource, int light, ResourceLocation texture, AbstractClientPlayer player, PlayerModel<AbstractClientPlayer> playermodel, ModelPart arm) {
        Methods.setModelProperties(player, playermodel);
        playermodel.f_102608_ = 0.0f;
        playermodel.f_102817_ = false;
        playermodel.f_102818_ = 0.0f;
        playermodel.m_6973_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        arm.f_104203_ = 0.0f;
        ItemStack item = player.m_6844_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)2));
        VertexConsumer vertex = ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)texture), (boolean)false, (boolean)item.m_41793_());
        arm.m_104301_(poseStack, vertex, light, OverlayTexture.f_118083_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setModelProperties(AbstractClientPlayer p_117819_, PlayerModel<AbstractClientPlayer> modelPart) {
        PlayerModel<AbstractClientPlayer> playermodel = modelPart;
        if (p_117819_.m_5833_()) {
            playermodel.m_8009_(false);
            playermodel.f_102808_.f_104207_ = true;
            playermodel.f_102809_.f_104207_ = true;
        } else {
            playermodel.m_8009_(true);
            playermodel.f_102809_.f_104207_ = p_117819_.m_36170_(PlayerModelPart.HAT);
            playermodel.f_103378_.f_104207_ = p_117819_.m_36170_(PlayerModelPart.JACKET);
            playermodel.f_103376_.f_104207_ = p_117819_.m_36170_(PlayerModelPart.LEFT_PANTS_LEG);
            playermodel.f_103377_.f_104207_ = p_117819_.m_36170_(PlayerModelPart.RIGHT_PANTS_LEG);
            playermodel.f_103374_.f_104207_ = p_117819_.m_36170_(PlayerModelPart.LEFT_SLEEVE);
            playermodel.f_103375_.f_104207_ = p_117819_.m_36170_(PlayerModelPart.RIGHT_SLEEVE);
            playermodel.f_102817_ = p_117819_.m_6047_();
            HumanoidModel.ArmPose humanoidmodel$armpose = Methods.getArmPose(p_117819_, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose humanoidmodel$armpose1 = Methods.getArmPose(p_117819_, InteractionHand.OFF_HAND);
            if (humanoidmodel$armpose.m_102897_()) {
                HumanoidModel.ArmPose armPose = humanoidmodel$armpose1 = p_117819_.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (p_117819_.m_5737_() == HumanoidArm.RIGHT) {
                playermodel.f_102816_ = humanoidmodel$armpose;
                playermodel.f_102815_ = humanoidmodel$armpose1;
            } else {
                playermodel.f_102816_ = humanoidmodel$armpose1;
                playermodel.f_102815_ = humanoidmodel$armpose;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static HumanoidModel.ArmPose getArmPose(AbstractClientPlayer p_117795_, InteractionHand p_117796_) {
        ItemStack itemstack = p_117795_.m_21120_(p_117796_);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (p_117795_.m_7655_() == p_117796_ && p_117795_.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && p_117796_ == p_117795_.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
        } else if (!p_117795_.f_20911_ && itemstack.m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean checkSound(SoundSource sound) {
        return sound == SoundSource.BLOCKS || sound == SoundSource.NEUTRAL || sound == SoundSource.RECORDS || sound == SoundSource.WEATHER || sound == SoundSource.HOSTILE || sound == SoundSource.PLAYERS || sound == SoundSource.AMBIENT;
    }
}

