/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.flag;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.beyond_earth.block.helper.VoxelShapeHelper;
import net.mrscauthd.beyond_earth.flag.FlagTileEntity;

public class FlagBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public FlagBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(world, pos);
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            switch ((Direction)state.m_61143_((Property)FACING)) {
                default: {
                    return Shapes.m_83110_((VoxelShape)VoxelShapeHelper.boxSimple(14.5, 0.0, 9.0, 12.5, 1.0, 7.0), (VoxelShape)VoxelShapeHelper.boxSimple(14.0, 1.0, 8.5, 13.0, 16.0, 7.5)).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
                }
                case NORTH: {
                    return Shapes.m_83110_((VoxelShape)VoxelShapeHelper.boxSimple(1.5, 0.0, 7.0, 3.5, 1.0, 9.0), (VoxelShape)VoxelShapeHelper.boxSimple(2.0, 1.0, 7.5, 3.0, 16.0, 8.5)).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
                }
                case EAST: {
                    return Shapes.m_83110_((VoxelShape)VoxelShapeHelper.boxSimple(9.0, 0.0, 1.5, 7.0, 1.0, 3.5), (VoxelShape)VoxelShapeHelper.boxSimple(8.5, 1.0, 2.0, 7.5, 16.0, 3.0)).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
                }
                case WEST: 
            }
            return Shapes.m_83110_((VoxelShape)VoxelShapeHelper.boxSimple(7.0, 0.0, 14.5, 9.0, 1.0, 12.5), (VoxelShape)VoxelShapeHelper.boxSimple(7.5, 1.0, 14.0, 8.5, 16.0, 13.0)).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        }
        switch ((Direction)state.m_61143_((Property)FACING)) {
            default: {
                return Shapes.m_83110_((VoxelShape)VoxelShapeHelper.boxSimple(14.0, 0.0, 8.5, 13.0, 16.0, 7.5), (VoxelShape)VoxelShapeHelper.boxSimple(14.0, 7.0, 8.5, 1.0, 15.0, 7.5)).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            }
            case NORTH: {
                return Shapes.m_83110_((VoxelShape)VoxelShapeHelper.boxSimple(2.0, 0.0, 7.5, 3.0, 16.0, 8.5), (VoxelShape)VoxelShapeHelper.boxSimple(2.0, 7.0, 7.5, 15.0, 15.0, 8.5)).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            }
            case EAST: {
                return Shapes.m_83110_((VoxelShape)VoxelShapeHelper.boxSimple(8.5, 0.0, 2.0, 7.5, 16.0, 3.0), (VoxelShape)VoxelShapeHelper.boxSimple(8.5, 7.0, 2.0, 7.5, 15.0, 15.0)).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            }
            case WEST: 
        }
        return Shapes.m_83110_((VoxelShape)VoxelShapeHelper.boxSimple(7.5, 0.0, 14.0, 8.5, 16.0, 13.0), (VoxelShape)VoxelShapeHelper.boxSimple(7.5, 7.0, 14.0, 8.5, 15.0, 1.0)).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.m_61143_(HALF);
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (facing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) != doubleblockhalf ? (BlockState)stateIn.m_61124_((Property)FACING, (Comparable)((Direction)facingState.m_61143_((Property)FACING))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.f_46443_ && player.m_7500_()) {
            FlagBlock.removeBottomHalf(worldIn, pos, state, player);
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    protected static void removeBottomHalf(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = world.m_8055_(blockpos = pos.m_7495_())).m_60734_() == state.m_60734_() && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_49820_) {
        BlockPos blockpos = p_49820_.m_8083_();
        Level level = p_49820_.m_43725_();
        if (blockpos.m_123342_() < level.m_151558_() - 1 && p_49820_.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(p_49820_)) {
            boolean flag = p_49820_.m_43725_().m_6425_(p_49820_.m_8083_()).m_192917_((Fluid)Fluids.f_76193_);
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)p_49820_.m_8125_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return null;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        worldIn.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        BlockEntity tileentity = worldIn.m_7702_(new BlockPos(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_()));
        if (tileentity instanceof FlagTileEntity) {
            FlagTileEntity flagtileentity = (FlagTileEntity)tileentity;
            CompoundTag compoundnbt = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)compoundnbt, (GameProfile)new GameProfile(placer.m_142081_(), placer.m_7755_().getString()));
            flagtileentity.getTileData().m_128365_("FlagOwner", (Tag)compoundnbt);
            if (placer instanceof Player) {
                Player player = (Player)placer;
                flagtileentity.setOwner(player.m_36316_());
            }
        }
    }

    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new FlagTileEntity(p_153215_, p_153216_);
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter p_60476_, BlockPos p_60477_, PathComputationType p_60478_) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ISkullType getSkullType() {
        return Types.PLAYER;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? blockstate.m_60783_((BlockGetter)worldIn, blockpos, Direction.UP) : blockstate.m_60713_((Block)this);
    }

    public PushReaction m_5537_(BlockState p_60584_) {
        return PushReaction.DESTROY;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6630_(state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49915_) {
        p_49915_.m_61104_(new Property[]{HALF, FACING, WATERLOGGED});
    }

    public static enum Types implements ISkullType
    {
        PLAYER;

    }

    public static interface ISkullType {
    }
}

