/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.gauge;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.mrscauthd.beyond_earth.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.gauge.GaugeValueSerializer;
import net.mrscauthd.beyond_earth.gauge.IGaugeValue;
import net.mrscauthd.beyond_earth.gui.helper.GuiHelper;
import net.mrscauthd.beyond_earth.util.Rectangle2d;

public abstract class AbstractGaugeDataRenderer {
    private final IGaugeValue value;

    public AbstractGaugeDataRenderer(IGaugeValue value) {
        this.value = value;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        GaugeValueSerializer.Serializer.write(this.getValue(), buffer);
    }

    public void render(PoseStack matrixStack, int left, int top, int width, int height) {
        this.drawBorder(matrixStack, left, top, width, height);
        int padding = this.getBorderWidth();
        Rectangle2d innerBounds = new Rectangle2d(left + padding, top + padding, width - padding * 2, height - padding * 2);
        this.drawBackground(matrixStack, innerBounds);
        this.drawContents(matrixStack, innerBounds);
        this.drawGaugeText(matrixStack, innerBounds);
    }

    public void render(PoseStack matrixStack, int left, int top) {
        this.render(matrixStack, left, top, this.getWidth(), this.getHeight());
    }

    protected void drawContents(PoseStack matrixStack, Rectangle2d innerBounds) {
    }

    @Nullable
    public Component getGaugeText() {
        return GaugeTextHelper.getValueText(this.getValue()).build();
    }

    protected void drawGaugeText(PoseStack matrixStack, Rectangle2d innerBounds) {
        Component text = this.getGaugeText();
        if (text != null) {
            int color = this.getTextColor();
            int textPadding = 2;
            Rectangle2d textBounds = new Rectangle2d(innerBounds.getX() + textPadding, innerBounds.getY(), innerBounds.getWidth() - textPadding, innerBounds.getHeight());
            this.drawText(matrixStack, textBounds, text, color);
        }
    }

    protected void drawText(PoseStack matrixStack, Rectangle2d bounds, Component text, int color) {
        this.drawText(Minecraft.m_91087_(), matrixStack, bounds, text, color);
    }

    protected void drawText(Minecraft minecraft, PoseStack matrixStack, Rectangle2d bounds, Component text, int color) {
        Font fontRenderer = minecraft.f_91062_;
        int textWidth = fontRenderer.m_92852_((FormattedText)text);
        float scale = Math.min(1.0f, (float)bounds.getWidth() / (float)textWidth);
        float offsetX = 0.0f;
        float f = bounds.getHeight();
        Objects.requireNonNull(fontRenderer);
        float offsetY = (f - (float)(9 - 1) * scale) / 2.0f;
        float scaledX = ((float)bounds.getX() + offsetX) / scale;
        float scaledY = ((float)bounds.getY() + offsetY) / scale;
        matrixStack.m_85836_();
        matrixStack.m_85841_(scale, scale, scale);
        fontRenderer.m_92889_(matrixStack, text, scaledX, scaledY, color);
        matrixStack.m_85849_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawBackground(PoseStack matrixStack, Rectangle2d innerBounds) {
        IGaugeValue value = this.getValue();
        int tileColor = value.getColor();
        double displayRatio = value.getDisplayRatio();
        try {
            ResourceLocation texture;
            RenderSystem.m_69478_();
            GuiHelper.setGLColorFromInt(tileColor);
            TextureAtlasSprite tileTexture = this.getBackgroundTileTexture();
            if (tileTexture != null) {
                int tileWidth = this.getBackgroundTileWidth();
                int tileHeight = this.getBackgroundTileHeight();
                int ratioWidth = (int)Math.ceil((double)innerBounds.getWidth() * displayRatio);
                GuiHelper.drawTiledSprite(matrixStack, innerBounds.getX(), innerBounds.getY(), ratioWidth, innerBounds.getHeight(), tileTexture, tileWidth, tileHeight);
            }
            if ((texture = this.getBackgroundTexture()) != null) {
                GuiHelper.drawHorizontal(matrixStack, innerBounds.getX(), innerBounds.getY(), innerBounds.getWidth(), innerBounds.getHeight(), texture, displayRatio);
            }
        }
        finally {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69461_();
        }
    }

    protected void drawBorder(PoseStack matrixStack, int left, int top, int width, int height) {
        int borderColor = this.getBorderColor();
        int padding = this.getBorderWidth();
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)left, (int)top, (int)(left + width - padding), (int)(top + padding), (int)borderColor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)left, (int)top, (int)(left + padding), (int)(top + height - padding), (int)borderColor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(left + width - padding), (int)top, (int)(left + width), (int)(top + height - padding), (int)borderColor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)left, (int)(top + height - padding), (int)(left + width), (int)(top + height), (int)borderColor);
    }

    public int getTextColor() {
        return -1;
    }

    @Nullable
    public TextureAtlasSprite getBackgroundTileTexture() {
        return null;
    }

    @Nullable
    public ResourceLocation getBackgroundTexture() {
        return null;
    }

    public int getBackgroundTileWidth() {
        return 16;
    }

    public int getBackgroundTileHeight() {
        return 16;
    }

    public int getBorderWidth() {
        return 1;
    }

    public int getBorderColor() {
        return -8355712;
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return 13;
    }

    public Vec2 getSize() {
        return new Vec2((float)this.getWidth(), (float)this.getHeight());
    }

    public IGaugeValue getValue() {
        return this.value;
    }
}

