/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.gui.screens.planetselection;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.beyond_earth.BeyondEarthMod;
import net.mrscauthd.beyond_earth.crafting.IngredientStack;
import net.mrscauthd.beyond_earth.crafting.SpaceStationRecipe;
import net.mrscauthd.beyond_earth.gui.helper.GuiHelper;
import net.mrscauthd.beyond_earth.gui.helper.ImageButtonPlacer;
import net.mrscauthd.beyond_earth.gui.screens.planetselection.PlanetSelectionGui;
import net.mrscauthd.beyond_earth.util.Rectangle2d;

@OnlyIn(value=Dist.CLIENT)
public class PlanetSelectionGuiWindow
extends AbstractContainerScreen<PlanetSelectionGui.GuiContainer> {
    private static ResourceLocation texture = new ResourceLocation("beyond_earth", "textures/screens/planet_selection_gui.png");
    private static ResourceLocation defaultButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/red_button.png");
    private static ResourceLocation gbButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/green_button.png");
    private static ResourceLocation gb2ButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/green_button_2.png");
    private static ResourceLocation rbButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/red_button.png");
    private static ResourceLocation rb2ButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/red_button_2.png");
    private static ResourceLocation dbbButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/dark_blue_button.png");
    private static ResourceLocation dbb2ButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/dark_blue_button_2.png");
    private static ResourceLocation bbButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/blue_button.png");
    private static ResourceLocation bb2ButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/blue_button_2.png");
    private static ResourceLocation sbbButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/small_blue_button.png");
    private static ResourceLocation sbb2ButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/small_blue_button_2.png");
    private static ResourceLocation bgbButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/big_green_button.png");
    private static ResourceLocation bgb2ButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/big_green_button_2.png");
    private static ResourceLocation brbButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/big_red_button.png");
    private static ResourceLocation brb2ButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/big_red_button_2.png");
    public int Category = -1;
    public float milkyWay = 0.0f;
    public float rotationMars = 0.0f;
    public float rotationEarth = 90.0f;
    public float rotationVenus = 180.0f;
    public float rotationMercury = 270.0f;
    public float rotationGlacio = 180.0f;
    public ImageButtonPlacer solarSystemButton;
    public ImageButtonPlacer proximaCentauriButton;
    public ImageButtonPlacer earthCategoryButton;
    public ImageButtonPlacer marsCategoryButton;
    public ImageButtonPlacer mercuryCategoryButton;
    public ImageButtonPlacer venusCategoryButton;
    public ImageButtonPlacer glacioCategoryButton;
    public ImageButtonPlacer earthButton;
    public ImageButtonPlacer moonButton;
    public ImageButtonPlacer marsButton;
    public ImageButtonPlacer mercuryButton;
    public ImageButtonPlacer venusButton;
    public ImageButtonPlacer glacioButton;
    public ImageButtonPlacer backButton;
    public ImageButtonPlacer earthOrbitButton;
    public ImageButtonPlacer moonOrbitButton;
    public ImageButtonPlacer marsOrbitButton;
    public ImageButtonPlacer mercuryOrbitButton;
    public ImageButtonPlacer venusOrbitButton;
    public ImageButtonPlacer glacioOrbitButton;
    public ImageButtonPlacer earthSpaceStationButton;
    public ImageButtonPlacer moonSpaceStationButton;
    public ImageButtonPlacer marsSpaceStationButton;
    public ImageButtonPlacer mercurySpaceStationButton;
    public ImageButtonPlacer venusSpaceStationButton;
    public ImageButtonPlacer glacioSpaceStationButton;
    private SpaceStationRecipe recipe;
    private boolean spaceStationItemList;

    public PlanetSelectionGuiWindow(PlanetSelectionGui.GuiContainer container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 512;
        this.f_97727_ = 512;
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.m_7025_(ms, mouseX, mouseY);
        this.milkyWay = (this.milkyWay + partialTicks * 0.4f) % 360.0f;
        this.rotationMars = (this.rotationMars + partialTicks * 0.4f) % 360.0f;
        this.rotationEarth = (this.rotationEarth + partialTicks * 0.8f) % 360.0f;
        this.rotationVenus = (this.rotationVenus + partialTicks * 0.7f) % 360.0f;
        this.rotationMercury = (this.rotationMercury + partialTicks * 0.7f) % 360.0f;
        this.rotationGlacio = (this.rotationGlacio + partialTicks * 0.7f) % 360.0f;
        String rocketType = ((PlanetSelectionGui.GuiContainer)this.f_97732_).rocket;
        if (this.Category == -1) {
            this.solarSystemButton.f_93624_ = true;
            this.proximaCentauriButton.f_93624_ = true;
            this.categoryButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 34, 70, 20, ms, this.solarSystemButton, this.tl("solar_system"), this.tl("solar_system"));
            this.categoryButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.proximaCentauriButton, this.tl("proxima_centauri"), this.tl("solar_system"));
        } else {
            this.solarSystemButton.f_93624_ = false;
            this.proximaCentauriButton.f_93624_ = false;
        }
        if (this.Category == 0) {
            this.earthCategoryButton.f_93624_ = true;
            this.marsCategoryButton.f_93624_ = true;
            this.mercuryCategoryButton.f_93624_ = true;
            this.venusCategoryButton.f_93624_ = true;
            this.buttonManager(rocketType, gb2ButtonTex, rb2ButtonTex, gbButtonTex, rbButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.earthCategoryButton, this.tl("earth"), 1);
            this.buttonManager(rocketType, gb2ButtonTex, rb2ButtonTex, gbButtonTex, rbButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 + 10, 70, 20, ms, this.marsCategoryButton, this.tl("mars"), 2);
            this.buttonManager(rocketType, gb2ButtonTex, rb2ButtonTex, gbButtonTex, rbButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 + 32, 70, 20, ms, this.mercuryCategoryButton, this.tl("mercury"), 3);
            this.buttonManager(rocketType, gb2ButtonTex, rb2ButtonTex, gbButtonTex, rbButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 + 54, 70, 20, ms, this.venusCategoryButton, this.tl("venus"), 3);
        } else {
            this.earthCategoryButton.f_93624_ = false;
            this.marsCategoryButton.f_93624_ = false;
            this.mercuryCategoryButton.f_93624_ = false;
            this.venusCategoryButton.f_93624_ = false;
        }
        if (this.Category >= 0) {
            this.backButton.f_93624_ = true;
            this.backButtonManager(dbbButtonTex, dbb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 34, 70, 20, this.backButton);
        } else {
            this.backButton.f_93624_ = false;
        }
        if (this.Category == 1) {
            this.earthButton.f_93624_ = true;
            this.earthOrbitButton.f_93624_ = true;
            this.earthSpaceStationButton.f_93624_ = true;
            this.moonButton.f_93624_ = true;
            this.moonOrbitButton.f_93624_ = true;
            this.moonSpaceStationButton.f_93624_ = true;
            this.teleportButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.earthButton, this.tl("planet"), "9.807 m/s", true, "a", 14);
            this.teleportButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 + 10, 70, 20, ms, this.moonButton, this.tl("moon"), "1.62 m/s", false, "c", -160);
            this.teleportButtonManager(sbbButtonTex, sbb2ButtonTex, mouseX, mouseY, 84, this.f_96544_ / 2 - 12, 37, 20, ms, this.earthOrbitButton, this.tl("orbit"), this.tl("no_gravity"), false, "c", -270);
            this.teleportButtonManager(sbbButtonTex, sbb2ButtonTex, mouseX, mouseY, 84, this.f_96544_ / 2 + 10, 37, 20, ms, this.moonOrbitButton, this.tl("orbit"), this.tl("no_gravity"), false, "c", -270);
            this.spaceStationCreatorButtonManager(brbButtonTex, brb2ButtonTex, bgbButtonTex, bgb2ButtonTex, mouseX, mouseY, 125, this.f_96544_ / 2 - 12, 75, 20, ms, this.earthSpaceStationButton, this.tl("orbit"), this.tl("no_gravity"), false, "c", -270);
            this.spaceStationCreatorButtonManager(brbButtonTex, brb2ButtonTex, bgbButtonTex, bgb2ButtonTex, mouseX, mouseY, 125, this.f_96544_ / 2 + 10, 75, 20, ms, this.moonSpaceStationButton, this.tl("orbit"), this.tl("no_gravity"), false, "c", -270);
        } else {
            this.earthButton.f_93624_ = false;
            this.earthOrbitButton.f_93624_ = false;
            this.earthSpaceStationButton.f_93624_ = false;
            this.moonButton.f_93624_ = false;
            this.moonOrbitButton.f_93624_ = false;
            this.moonSpaceStationButton.f_93624_ = false;
        }
        if (this.Category == 2) {
            this.marsButton.f_93624_ = true;
            this.marsOrbitButton.f_93624_ = true;
            this.marsSpaceStationButton.f_93624_ = true;
            this.teleportButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.marsButton, this.tl("planet"), "3.721 m/s", false, "a", -63);
            this.teleportButtonManager(sbbButtonTex, sbb2ButtonTex, mouseX, mouseY, 84, this.f_96544_ / 2 - 12, 37, 20, ms, this.marsOrbitButton, this.tl("orbit"), this.tl("no_gravity"), false, "c", -270);
            this.spaceStationCreatorButtonManager(brbButtonTex, brb2ButtonTex, bgbButtonTex, bgb2ButtonTex, mouseX, mouseY, 125, this.f_96544_ / 2 - 12, 75, 20, ms, this.marsSpaceStationButton, this.tl("orbit"), this.tl("no_gravity"), false, "c", -270);
        } else {
            this.marsButton.f_93624_ = false;
            this.marsOrbitButton.f_93624_ = false;
            this.marsSpaceStationButton.f_93624_ = false;
        }
        if (this.Category == 3) {
            this.mercuryButton.f_93624_ = true;
            this.mercuryOrbitButton.f_93624_ = true;
            this.mercurySpaceStationButton.f_93624_ = true;
            this.teleportButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.mercuryButton, this.tl("planet"), "3.7 m/s", false, "a", 430);
            this.teleportButtonManager(sbbButtonTex, sbb2ButtonTex, mouseX, mouseY, 84, this.f_96544_ / 2 - 12, 37, 20, ms, this.mercuryOrbitButton, this.tl("orbit"), this.tl("no_gravity"), false, "c", -270);
            this.spaceStationCreatorButtonManager(brbButtonTex, brb2ButtonTex, bgbButtonTex, bgb2ButtonTex, mouseX, mouseY, 125, this.f_96544_ / 2 - 12, 75, 20, ms, this.mercurySpaceStationButton, this.tl("orbit"), this.tl("no_gravity"), false, "c", -270);
        } else {
            this.mercuryButton.f_93624_ = false;
            this.mercuryOrbitButton.f_93624_ = false;
            this.mercurySpaceStationButton.f_93624_ = false;
        }
        if (this.Category == 4) {
            this.venusButton.f_93624_ = true;
            this.venusOrbitButton.f_93624_ = true;
            this.venusSpaceStationButton.f_93624_ = true;
            this.teleportButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.venusButton, this.tl("planet"), "8.87 m/s", false, "a", 482);
            this.teleportButtonManager(sbbButtonTex, sbb2ButtonTex, mouseX, mouseY, 84, this.f_96544_ / 2 - 12, 37, 20, ms, this.venusOrbitButton, this.tl("orbit"), this.tl("no_gravity"), false, "c", -270);
            this.spaceStationCreatorButtonManager(brbButtonTex, brb2ButtonTex, bgbButtonTex, bgb2ButtonTex, mouseX, mouseY, 125, this.f_96544_ / 2 - 12, 75, 20, ms, this.venusSpaceStationButton, this.tl("orbit"), this.tl("no_gravity"), false, "c", -270);
        } else {
            this.venusButton.f_93624_ = false;
            this.venusOrbitButton.f_93624_ = false;
            this.venusSpaceStationButton.f_93624_ = false;
        }
        if (this.Category == 5) {
            this.glacioCategoryButton.f_93624_ = true;
            this.buttonManager(rocketType, gb2ButtonTex, rb2ButtonTex, gbButtonTex, rbButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 11, 70, 20, ms, this.glacioCategoryButton, this.tl("glacio"), 4);
        } else {
            this.glacioCategoryButton.f_93624_ = false;
        }
        if (this.Category == 6) {
            this.glacioButton.f_93624_ = true;
            this.glacioOrbitButton.f_93624_ = true;
            this.glacioSpaceStationButton.f_93624_ = true;
            this.teleportButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.glacioButton, this.tl("planet"), "3.721 m/s", true, "a", -20);
            this.teleportButtonManager(sbbButtonTex, sbb2ButtonTex, mouseX, mouseY, 84, this.f_96544_ / 2 - 12, 37, 20, ms, this.glacioOrbitButton, this.tl("orbit"), this.tl("no_gravity"), false, "c", -270);
            this.spaceStationCreatorButtonManager(brbButtonTex, brb2ButtonTex, bgbButtonTex, bgb2ButtonTex, mouseX, mouseY, 125, this.f_96544_ / 2 - 12, 75, 20, ms, this.glacioSpaceStationButton, this.tl("orbit"), this.tl("no_gravity"), false, "c", -270);
        } else {
            this.glacioButton.f_93624_ = false;
            this.glacioOrbitButton.f_93624_ = false;
            this.glacioSpaceStationButton.f_93624_ = false;
        }
        this.f_96547_.m_92889_(ms, this.tl("catalog"), 24.0f, (float)(this.f_96544_ / 2 - 71), -1);
    }

    public Component getRocket(int tier) {
        return new TranslatableComponent("entity.beyond_earth.rocket_t" + tier);
    }

    public Component tl(String string) {
        return new TranslatableComponent("gui.beyond_earth.planet_selection." + string);
    }

    protected void m_7286_(PoseStack ms, float p_97788_, int p_97789_, int p_97790_) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93133_((PoseStack)ms, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.f_96543_, (int)this.f_96544_, (int)this.f_96543_, (int)this.f_96544_);
        if (this.Category >= 0 && this.Category <= 4) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("beyond_earth", "textures/solar_system.png"));
            GuiHelper.blit(ms, (this.f_96543_ - 185) / 2, (this.f_96544_ - 185) / 2, 0.0f, 0.0f, 185.0f, 185.0f, 185, 185);
        }
        if (this.Category >= 5 && this.Category <= 6) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("beyond_earth", "textures/proxima_centauri.png"));
            GuiHelper.blit(ms, (this.f_96543_ - 185) / 2, (this.f_96544_ - 185) / 2, 0.0f, 0.0f, 185.0f, 185.0f, 185, 185);
        }
        if (this.Category >= 0 && this.Category <= 4) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("beyond_earth", "textures/sky/gui/sun.png"));
            GuiHelper.blit(ms, (this.f_96543_ - 15) / 2, (this.f_96544_ - 15) / 2, 0.0f, 0.0f, 15.0f, 15.0f, 15, 15);
        } else if (this.Category >= 5 && this.Category <= 6) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("beyond_earth", "textures/sky/gui/blue_sun.png"));
            GuiHelper.blit(ms, (this.f_96543_ - 15) / 2, (this.f_96544_ - 15) / 2, 0.0f, 0.0f, 15.0f, 15.0f, 15, 15);
        }
        if (this.Category == -1) {
            this.addGalaxy(ms, new ResourceLocation("beyond_earth", "textures/sky/gui/milky_way.png"), -125.0f, -125.0f, 250, 250, this.milkyWay);
        }
        if (this.Category >= 0 && this.Category <= 4) {
            this.addPlanet(ms, new ResourceLocation("beyond_earth", "textures/sky/gui/mars.png"), -70.0f, -70.0f, 10, 10, this.rotationMars);
            this.addPlanet(ms, new ResourceLocation("beyond_earth", "textures/sky/gui/earth.png"), -54.0f, -54.0f, 10, 10, this.rotationEarth);
            this.addPlanet(ms, new ResourceLocation("beyond_earth", "textures/sky/gui/venus.png"), -37.0f, -37.0f, 10, 10, this.rotationVenus);
            this.addPlanet(ms, new ResourceLocation("beyond_earth", "textures/sky/gui/mercury.png"), -20.5f, -20.5f, 10, 10, this.rotationMercury);
        } else if (this.Category >= 5 && this.Category <= 6) {
            this.addPlanet(ms, new ResourceLocation("beyond_earth", "textures/sky/gui/glacio.png"), -20.5f, -20.5f, 10, 10, this.rotationGlacio);
        }
        if (this.Category < 1 || this.Category == 5) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("beyond_earth", "textures/rocket_menu_list.png"));
            GuiComponent.m_93133_((PoseStack)ms, (int)0, (int)(this.f_96544_ / 2 - 88), (float)0.0f, (float)0.0f, (int)105, (int)177, (int)105, (int)177);
        } else if (this.Category >= 1 && this.Category <= 4 || this.Category >= 5 && this.Category <= 6) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("beyond_earth", "textures/rocket_menu_list_2.png"));
            GuiComponent.m_93133_((PoseStack)ms, (int)0, (int)(this.f_96544_ / 2 - 88), (float)0.0f, (float)0.0f, (int)215, (int)177, (int)215, (int)177);
        }
        RenderSystem.m_69461_();
    }

    public void addPlanet(PoseStack ms, ResourceLocation planet, float x, float y, int width, int height, float rotation) {
        ms.m_85836_();
        ms.m_85837_((double)(this.f_96543_ / 2), (double)(this.f_96544_ / 2), 0.0);
        ms.m_85845_(new Quaternion(Vector3f.f_122227_, rotation, true));
        RenderSystem.m_157456_((int)0, (ResourceLocation)planet);
        GuiHelper.blit(ms, x, y, 0.0f, 0.0f, width, height, width, height);
        ms.m_85837_((double)(-this.f_96543_ / 2), (double)(-this.f_96544_ / 2), 0.0);
        ms.m_85849_();
    }

    public void addGalaxy(PoseStack ms, ResourceLocation planet, float x, float y, int width, int height, float rotation) {
        ms.m_85836_();
        ms.m_85837_((double)(this.f_96543_ / 2), (double)(this.f_96544_ / 2), 0.0);
        ms.m_85845_(new Quaternion(Vector3f.f_122227_, rotation, true));
        RenderSystem.m_157456_((int)0, (ResourceLocation)planet);
        GuiHelper.blit(ms, x, y, 0.0f, 0.0f, width, height, width, height);
        ms.m_85837_((double)(-this.f_96543_ / 2), (double)(-this.f_96544_ / 2), 0.0);
        ms.m_85849_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.recipe = this.f_96541_.f_91073_.m_7465_().m_44043_(SpaceStationRecipe.KEY).orElse(null);
        this.spaceStationItemList = this.recipe.getIngredientStacks().stream().allMatch(this::getSpaceStationItemCheck);
        this.solarSystemButton = this.addImageButtonSetSolarSystem(10, this.f_96544_ / 2 - 34, 70, 20, bbButtonTex, 0, this.tl("sun"));
        this.proximaCentauriButton = this.addImageButtonSetSolarSystem(10, this.f_96544_ / 2 - 12, 70, 20, bbButtonTex, 5, this.tl("proxima_cent"));
        this.earthCategoryButton = this.addImageButtonSetCategory(10, this.f_96544_ / 2 - 12, 70, 20, defaultButtonTex, 1, ((PlanetSelectionGui.GuiContainer)this.f_97732_).rocket, 1, this.tl("earth"));
        this.earthCategoryButton.f_93624_ = false;
        this.marsCategoryButton = this.addImageButtonSetCategory(10, this.f_96544_ / 2 + 10, 70, 20, defaultButtonTex, 2, ((PlanetSelectionGui.GuiContainer)this.f_97732_).rocket, 2, this.tl("mars"));
        this.marsCategoryButton.f_93624_ = false;
        this.mercuryCategoryButton = this.addImageButtonSetCategory(10, this.f_96544_ / 2 + 32, 70, 20, defaultButtonTex, 3, ((PlanetSelectionGui.GuiContainer)this.f_97732_).rocket, 3, this.tl("mercury"));
        this.mercuryCategoryButton.f_93624_ = false;
        this.venusCategoryButton = this.addImageButtonSetCategory(10, this.f_96544_ / 2 + 54, 70, 20, defaultButtonTex, 4, ((PlanetSelectionGui.GuiContainer)this.f_97732_).rocket, 3, this.tl("venus"));
        this.venusCategoryButton.f_93624_ = false;
        this.glacioCategoryButton = this.addImageButtonSetCategory(10, this.f_96544_ / 2 - 12, 70, 20, defaultButtonTex, 6, ((PlanetSelectionGui.GuiContainer)this.f_97732_).rocket, 4, this.tl("glacio"));
        this.glacioCategoryButton.f_93624_ = false;
        this.backButton = this.addImageButtonBack(10, this.f_96544_ / 2 - 34, 70, 20, dbbButtonTex, this.tl("back"));
        this.backButton.f_93624_ = false;
        this.earthButton = this.addImageButton(10, this.f_96544_ / 2 - 12, 70, 20, bbButtonTex, 0, this.tl("earth"));
        this.earthButton.f_93624_ = false;
        this.moonButton = this.addImageButton(10, this.f_96544_ / 2 + 10, 70, 20, bbButtonTex, 1, this.tl("moon"));
        this.moonButton.f_93624_ = false;
        this.marsButton = this.addImageButton(10, this.f_96544_ / 2 - 12, 70, 20, bbButtonTex, 2, this.tl("mars"));
        this.marsButton.f_93624_ = false;
        this.mercuryButton = this.addImageButton(10, this.f_96544_ / 2 - 12, 70, 20, bbButtonTex, 3, this.tl("mercury"));
        this.mercuryButton.f_93624_ = false;
        this.venusButton = this.addImageButton(10, this.f_96544_ / 2 - 12, 70, 20, bbButtonTex, 4, this.tl("venus"));
        this.venusButton.f_93624_ = false;
        this.glacioButton = this.addImageButton(10, this.f_96544_ / 2 - 12, 70, 20, bbButtonTex, 5, this.tl("glacio"));
        this.glacioButton.f_93624_ = false;
        this.earthOrbitButton = this.addImageButton(84, this.f_96544_ / 2 - 12, 37, 20, sbbButtonTex, 6, this.tl("orbit"));
        this.earthOrbitButton.f_93624_ = false;
        this.moonOrbitButton = this.addImageButton(84, this.f_96544_ / 2 + 10, 37, 20, sbbButtonTex, 7, this.tl("orbit"));
        this.moonOrbitButton.f_93624_ = false;
        this.marsOrbitButton = this.addImageButton(84, this.f_96544_ / 2 - 12, 37, 20, sbbButtonTex, 8, this.tl("orbit"));
        this.marsOrbitButton.f_93624_ = false;
        this.mercuryOrbitButton = this.addImageButton(84, this.f_96544_ / 2 - 12, 37, 20, sbbButtonTex, 9, this.tl("orbit"));
        this.mercuryOrbitButton.f_93624_ = false;
        this.venusOrbitButton = this.addImageButton(84, this.f_96544_ / 2 - 12, 37, 20, sbbButtonTex, 10, this.tl("orbit"));
        this.venusOrbitButton.f_93624_ = false;
        this.glacioOrbitButton = this.addImageButton(84, this.f_96544_ / 2 - 12, 37, 20, sbbButtonTex, 11, this.tl("orbit"));
        this.glacioOrbitButton.f_93624_ = false;
        this.earthSpaceStationButton = this.addSpaceStationImageButton(125, this.f_96544_ / 2 - 12, 75, 20, brbButtonTex, 12, this.tl("space_station"), this.spaceStationItemList);
        this.earthSpaceStationButton.f_93624_ = false;
        this.moonSpaceStationButton = this.addSpaceStationImageButton(125, this.f_96544_ / 2 + 10, 75, 20, brbButtonTex, 13, this.tl("space_station"), this.spaceStationItemList);
        this.moonSpaceStationButton.f_93624_ = false;
        this.marsSpaceStationButton = this.addSpaceStationImageButton(125, this.f_96544_ / 2 - 12, 75, 20, brbButtonTex, 14, this.tl("space_station"), this.spaceStationItemList);
        this.marsSpaceStationButton.f_93624_ = false;
        this.mercurySpaceStationButton = this.addSpaceStationImageButton(125, this.f_96544_ / 2 - 12, 75, 20, brbButtonTex, 15, this.tl("space_station"), this.spaceStationItemList);
        this.mercurySpaceStationButton.f_93624_ = false;
        this.venusSpaceStationButton = this.addSpaceStationImageButton(125, this.f_96544_ / 2 - 12, 75, 20, brbButtonTex, 16, this.tl("space_station"), this.spaceStationItemList);
        this.venusSpaceStationButton.f_93624_ = false;
        this.glacioSpaceStationButton = this.addSpaceStationImageButton(125, this.f_96544_ / 2 - 12, 75, 20, brbButtonTex, 17, this.tl("space_station"), this.spaceStationItemList);
        this.glacioSpaceStationButton.f_93624_ = false;
    }

    protected void m_7027_(PoseStack p_97808_, int p_97809_, int p_97810_) {
    }

    public Rectangle2d getBounds(int left, int top, int width, int height) {
        return GuiHelper.getBounds(left, top, width, height);
    }

    public boolean checkTier(String rocketType, int stage) {
        int tier = 0;
        if (rocketType.equals("entity.beyond_earth.rocket_t1")) {
            tier = 1;
        }
        if (rocketType.equals("entity.beyond_earth.rocket_t2")) {
            tier = 2;
        }
        if (rocketType.equals("entity.beyond_earth.rocket_t3")) {
            tier = 3;
        }
        if (rocketType.equals("entity.beyond_earth.rocket_t4")) {
            tier = 4;
        }
        return tier >= stage;
    }

    public void buttonManager(String rocketType, ResourceLocation gb2, ResourceLocation rb2, ResourceLocation gb, ResourceLocation rb, int mouseX, int mouseY, int left, int top, int width, int height, PoseStack ms, ImageButtonPlacer button, Component dim, int stage) {
        String level = "c";
        if (this.checkTier(rocketType, stage)) {
            level = "a";
            button.setTexture(gb);
        } else {
            level = "c";
            button.setTexture(rb);
        }
        if (GuiHelper.isHover(this.getBounds(left, top, width, height), mouseX, mouseY)) {
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            list.add(new TextComponent("\u00a79" + this.tl("category").getString() + ": \u00a7" + level + dim.getString()));
            list.add(new TextComponent("\u00a79" + this.tl("provided").getString() + ": \u00a7b" + this.getRocket(stage).getString()));
            this.m_96597_(ms, list, mouseX, mouseY);
            if (this.checkTier(rocketType, stage)) {
                button.setTexture(gb2);
            } else {
                button.setTexture(rb2);
            }
        }
    }

    public void categoryButtonManager(ResourceLocation bb, ResourceLocation bb2, int mouseX, int mouseY, int left, int top, int width, int height, PoseStack ms, ImageButtonPlacer button, Component solarSystem, Component type) {
        button.setTexture(bb);
        if (GuiHelper.isHover(this.getBounds(left, top, width, height), mouseX, mouseY)) {
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            list.add(new TextComponent("\u00a79" + this.tl("category").getString() + ": \u00a7b" + solarSystem.getString()));
            list.add(new TextComponent("\u00a79" + this.tl("type").getString() + ": \u00a73" + type.getString()));
            this.m_96597_(ms, list, mouseX, mouseY);
            button.setTexture(bb2);
        }
    }

    public void teleportButtonManager(ResourceLocation bb, ResourceLocation bb2, int mouseX, int mouseY, int left, int top, int width, int height, PoseStack ms, ImageButtonPlacer button, Component planetType, String gravity, boolean oxygen, String temperatureColor, int temperature) {
        this.teleportButtonManager(bb, bb2, mouseX, mouseY, left, top, width, height, ms, button, planetType, (Component)new TextComponent(gravity), oxygen, temperatureColor, temperature);
    }

    public void teleportButtonManager(ResourceLocation bb, ResourceLocation bb2, int mouseX, int mouseY, int left, int top, int width, int height, PoseStack ms, ImageButtonPlacer button, Component planetType, Component gravity, boolean oxygen, String temperatureColor, int temperature) {
        if (GuiHelper.isHover(this.getBounds(left, top, width, height), mouseX, mouseY)) {
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            list.add(new TextComponent("\u00a79" + this.tl("type").getString() + ": \u00a73" + planetType.getString()));
            list.add(new TextComponent("\u00a79" + this.tl("gravity").getString() + ": \u00a73" + gravity.getString()));
            list.add(new TextComponent("\u00a79" + this.tl("oxygen").getString() + ": \u00a7" + (oxygen ? "a" : "c") + this.tl("oxygen." + oxygen).getString()));
            list.add(new TextComponent("\u00a79" + this.tl("temperature").getString() + ": \u00a7" + temperatureColor + temperature));
            this.m_96597_(ms, list, mouseX, mouseY);
            button.setTexture(bb2);
        } else {
            button.setTexture(bb);
        }
    }

    public void spaceStationCreatorButtonManager(ResourceLocation brb, ResourceLocation brb2, ResourceLocation bbb, ResourceLocation bbb2, int mouseX, int mouseY, int left, int top, int width, int height, PoseStack ms, ImageButtonPlacer button, Component orbitType, Component gravity, boolean oxygen, String temperatureColor, int temperature) {
        if (this.spaceStationItemList) {
            button.setTexture(bbb);
        } else {
            button.setTexture(brb);
        }
        if (GuiHelper.isHover(this.getBounds(left, top, width, height), mouseX, mouseY)) {
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            list.add(new TextComponent("\u00a79" + this.tl("item_requirement").getString()));
            for (IngredientStack ingredientStack : this.recipe.getIngredientStacks()) {
                boolean check = this.getSpaceStationItemCheck(ingredientStack);
                Component component = Arrays.stream(ingredientStack.getIngredient().m_43908_()).findFirst().map(ItemStack::m_41786_).orElse(TextComponent.f_131282_);
                list.add(new TextComponent("\u00a78[\u00a76" + ingredientStack.getCount() + "\u00a78]" + (check ? "\u00a7a" : "\u00a7c") + " " + component.getString() + (ingredientStack.getCount() > 1 ? "'s" : "")));
            }
            list.add(new TextComponent("\u00a7c----------------"));
            list.add(new TextComponent("\u00a79" + this.tl("type").getString() + ": \u00a73" + orbitType.getString()));
            list.add(new TextComponent("\u00a79" + this.tl("gravity").getString() + ": \u00a73" + gravity.getString()));
            list.add(new TextComponent("\u00a79" + this.tl("oxygen").getString() + ": \u00a7" + (oxygen ? "a" : "c") + this.tl("oxygen." + oxygen).getString()));
            list.add(new TextComponent("\u00a79" + this.tl("temperature").getString() + ": \u00a7" + temperatureColor + temperature));
            this.m_96597_(ms, list, mouseX, mouseY);
            if (this.spaceStationItemList) {
                button.setTexture(bbb2);
            } else {
                button.setTexture(brb2);
            }
        }
    }

    public boolean getSpaceStationItemCheck(IngredientStack ingredientStack) {
        if (((PlanetSelectionGui.GuiContainer)this.f_97732_).player.m_150110_().f_35937_ || ((PlanetSelectionGui.GuiContainer)this.f_97732_).player.m_5833_()) {
            return true;
        }
        Inventory inv = ((PlanetSelectionGui.GuiContainer)this.f_97732_).player.m_150109_();
        int itemStackCount = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemStack = inv.m_8020_(i);
            if (!ingredientStack.testWithoutCount(itemStack)) continue;
            itemStackCount += itemStack.m_41613_();
        }
        return itemStackCount >= ingredientStack.getCount();
    }

    public void backButtonManager(ResourceLocation bb, ResourceLocation bb2, int mouseX, int mouseY, int left, int top, int width, int height, ImageButtonPlacer button) {
        if (GuiHelper.isHover(this.getBounds(left, top, width, height), mouseX, mouseY)) {
            button.setTexture(bb2);
        } else {
            button.setTexture(bb);
        }
    }

    public ImageButtonPlacer addImageButton(int xIn, int yIn, int width, int height, ResourceLocation texture, int handler, Component title) {
        ImageButtonPlacer button = (ImageButtonPlacer)this.m_142416_((GuiEventListener)new ImageButtonPlacer(xIn, yIn, width, height, 0, 0, 0, texture, width, height, p_2130901 -> BeyondEarthMod.PACKET_HANDLER.sendToServer((Object)new PlanetSelectionGui.NetworkMessage(handler)), title));
        return button;
    }

    public ImageButtonPlacer addSpaceStationImageButton(int xIn, int yIn, int width, int height, ResourceLocation texture, int handler, Component title, boolean condition) {
        ImageButtonPlacer button = (ImageButtonPlacer)this.m_142416_((GuiEventListener)new ImageButtonPlacer(xIn, yIn, width, height, 0, 0, 0, texture, width, height, p_2130901 -> {
            if (condition) {
                BeyondEarthMod.PACKET_HANDLER.sendToServer((Object)new PlanetSelectionGui.NetworkMessage(handler));
            }
        }, title));
        return button;
    }

    public ImageButtonPlacer addImageButtonSetCategory(int xIn, int yIn, int width, int height, ResourceLocation texture, int newCategory, String rocket, int stage, Component title) {
        ImageButtonPlacer button = (ImageButtonPlacer)this.m_142416_((GuiEventListener)new ImageButtonPlacer(xIn, yIn, width, height, 0, 0, 0, texture, width, height, p_2130901 -> {
            if (this.checkTier(rocket, stage)) {
                this.Category = newCategory;
            }
        }, title));
        return button;
    }

    public ImageButtonPlacer addImageButtonBack(int xIn, int yIn, int width, int height, ResourceLocation texture, Component title) {
        ImageButtonPlacer button = (ImageButtonPlacer)this.m_142416_((GuiEventListener)new ImageButtonPlacer(xIn, yIn, width, height, 0, 0, 0, texture, width, height, p_2130901 -> {
            this.Category = this.Category >= 1 && this.Category <= 4 ? 0 : (this.Category == 5 ? -1 : (this.Category >= 6 && this.Category <= 6 ? 5 : --this.Category));
        }, title));
        return button;
    }

    public ImageButtonPlacer addImageButtonSetSolarSystem(int xIn, int yIn, int width, int height, ResourceLocation texture, int newCategory, Component title) {
        ImageButtonPlacer button = (ImageButtonPlacer)this.m_142416_((GuiEventListener)new ImageButtonPlacer(xIn, yIn, width, height, 0, 0, 0, texture, width, height, p_2130901 -> {
            this.Category = newCategory;
        }, title));
        return button;
    }
}

