/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.gui.screens.rocket;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.compat.CompatibleManager;
import net.mrscauthd.beyond_earth.entity.RocketTier1Entity;
import net.mrscauthd.beyond_earth.entity.RocketTier2Entity;
import net.mrscauthd.beyond_earth.entity.RocketTier3Entity;
import net.mrscauthd.beyond_earth.entity.RocketTier4Entity;
import net.mrscauthd.beyond_earth.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.gauge.IGaugeValue;
import net.mrscauthd.beyond_earth.gui.helper.GuiHelper;
import net.mrscauthd.beyond_earth.gui.screens.rocket.RocketGui;
import net.mrscauthd.beyond_earth.util.Rectangle2d;

@OnlyIn(value=Dist.CLIENT)
public class RocketGuiWindow
extends AbstractContainerScreen<RocketGui.GuiContainer> {
    private static final ResourceLocation texture = new ResourceLocation("beyond_earth", "textures/screens/rocket_gui.png");

    public RocketGuiWindow(RocketGui.GuiContainer container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 176;
        this.f_97727_ = 167;
        this.f_97731_ = this.f_97727_ - 93;
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.m_7025_(ms, mouseX, mouseY);
        if (!CompatibleManager.JEI.isLoaded() && GuiHelper.isHover(this.getFluidBounds(), mouseX - this.f_97735_, mouseY - this.f_97736_)) {
            ArrayList<Component> fuelToolTip = new ArrayList<Component>();
            fuelToolTip.add(this.getFuelGaugeComponent());
            this.m_96597_(ms, fuelToolTip, mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack ms, float p_98414_, int p_98415_, int p_98416_) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93133_((PoseStack)ms, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)this.f_97726_, (int)this.f_97727_);
        IGaugeValue fuelGaugeValue = this.getFuelGaugeValue();
        FluidStack fluidStack = new FluidStack((Fluid)((LiquidBlock)ModInit.FUEL_BLOCK.get()).getFluid(), fuelGaugeValue.getAmount());
        GuiHelper.drawRocketFluidTank(ms, this.f_97735_ + 67, this.f_97736_ + 22, fluidStack, fuelGaugeValue.getCapacity());
    }

    protected void m_7027_(PoseStack ms, int p_97809_, int p_97810_) {
        this.f_96547_.m_92883_(ms, this.f_96539_.getString(), (float)(this.f_97726_ / 2) - 33.0f, (float)this.f_97729_, 0x404040);
        this.f_96547_.m_92889_(ms, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
    }

    public Component getFuelGaugeComponent() {
        return GaugeTextHelper.buildBlockTooltip(GaugeTextHelper.getPercentText(this.getFuelGaugeValue()), ChatFormatting.WHITE);
    }

    public IGaugeValue getFuelGaugeValue() {
        int fuel = 0;
        if (((RocketGui.GuiContainer)this.f_97732_).rocket instanceof RocketTier1Entity) {
            fuel = (Integer)((RocketGui.GuiContainer)this.f_97732_).rocket.m_20088_().m_135370_(RocketTier1Entity.FUEL);
        }
        if (((RocketGui.GuiContainer)this.f_97732_).rocket instanceof RocketTier2Entity) {
            fuel = (Integer)((RocketGui.GuiContainer)this.f_97732_).rocket.m_20088_().m_135370_(RocketTier2Entity.FUEL);
        }
        if (((RocketGui.GuiContainer)this.f_97732_).rocket instanceof RocketTier3Entity) {
            fuel = (Integer)((RocketGui.GuiContainer)this.f_97732_).rocket.m_20088_().m_135370_(RocketTier3Entity.FUEL);
        }
        if (((RocketGui.GuiContainer)this.f_97732_).rocket instanceof RocketTier4Entity) {
            fuel = (Integer)((RocketGui.GuiContainer)this.f_97732_).rocket.m_20088_().m_135370_(RocketTier4Entity.FUEL);
        }
        return GaugeValueHelper.getFuel(fuel / 3, 100);
    }

    public Rectangle2d getFluidBounds() {
        return GuiHelper.getRocketFluidTankBounds(66, 21);
    }

    public Entity getRocket() {
        return ((RocketGui.GuiContainer)this.f_97732_).rocket;
    }
}

