/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.gui.screens.waterpump;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidTank;
import net.mrscauthd.beyond_earth.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.gui.helper.GuiHelper;
import net.mrscauthd.beyond_earth.gui.screens.waterpump.WaterPumpGui;
import net.mrscauthd.beyond_earth.machines.tile.WaterPumpBlockEntity;
import net.mrscauthd.beyond_earth.util.Rectangle2d;

@OnlyIn(value=Dist.CLIENT)
public class WaterPumpGuiWindow
extends AbstractContainerScreen<WaterPumpGui.GuiContainer> {
    public static final ResourceLocation texture = new ResourceLocation("beyond_earth", "textures/screens/water_pump_gui.png");
    public static final int WATER_TANK_LEFT = 75;
    public static final int WATER_TANK_TOP = 21;
    public static final int ENERGY_LEFT = 144;
    public static final int ENERGY_TOP = 21;

    public WaterPumpGuiWindow(WaterPumpGui.GuiContainer container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 177;
        this.f_97727_ = 172;
        this.f_97731_ = this.f_97727_ - 92;
    }

    public Rectangle2d getOutputTankBounds() {
        return GuiHelper.getFluidTankBounds(this.f_97735_ + 75, this.f_97736_ + 21);
    }

    public Rectangle2d getEnergyBounds() {
        return GuiHelper.getEnergyBounds(this.f_97735_ + 144, this.f_97736_ + 21);
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.m_7025_(ms, mouseX, mouseY);
        WaterPumpBlockEntity blockEntity = ((WaterPumpGui.GuiContainer)this.m_6262_()).getBlockEntity();
        if (GuiHelper.isHover(this.getOutputTankBounds(), mouseX, mouseY)) {
            this.m_96602_(ms, (Component)GaugeTextHelper.getStorageText(GaugeValueHelper.getFluid((IFluidTank)blockEntity.getWaterTank())).build(), mouseX, mouseY);
        } else if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
            this.m_96602_(ms, (Component)GaugeTextHelper.getStorageText(GaugeValueHelper.getEnergy(blockEntity)).build(), mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack ms, float p_97788_, int p_97789_, int p_97790_) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93133_((PoseStack)ms, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)this.f_97726_, (int)this.f_97727_);
        WaterPumpBlockEntity blockEntity = ((WaterPumpGui.GuiContainer)this.m_6262_()).getBlockEntity();
        GuiHelper.drawEnergy(ms, this.f_97735_ + 144, this.f_97736_ + 21, blockEntity.getPrimaryEnergyStorage());
        GuiHelper.drawFluidTank(ms, this.f_97735_ + 75, this.f_97736_ + 21, (IFluidTank)blockEntity.getWaterTank());
    }
}

