/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.entity.RoverEntity;
import net.mrscauthd.beyond_earth.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.item.FilledAltVehicleItem;
import net.mrscauthd.beyond_earth.item.VehicleItem;
import net.mrscauthd.beyond_earth.itemgroup.ItemGroups;
import org.jetbrains.annotations.Nullable;

public class RoverItem
extends VehicleItem
implements FilledAltVehicleItem {
    public static String fuelTag = "beyond_earth:fuel";

    public RoverItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        int fuel = p_41421_.m_41784_().m_128451_(fuelTag);
        p_41423_.add((Component)GaugeTextHelper.buildBlockTooltip(GaugeTextHelper.getStorageText(GaugeValueHelper.getFuel(fuel, 3000))));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        if (world.m_5776_()) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.m_8083_();
        InteractionHand hand = context.m_43724_();
        ItemStack itemStack = context.m_43722_();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        BlockPos pos1 = new BlockPos(x, y + 1, z);
        BlockPos pos2 = new BlockPos(x + 1, y + 1, z);
        BlockPos pos3 = new BlockPos(x - 1, y + 1, z);
        BlockPos pos4 = new BlockPos(x, y + 1, z + 1);
        BlockPos pos5 = new BlockPos(x, y + 1, z - 1);
        BlockPos pos6 = new BlockPos(x + 1, y + 1, z + 1);
        BlockPos pos7 = new BlockPos(x + 1, y + 1, z - 1);
        BlockPos pos8 = new BlockPos(x - 1, y + 1, z + 1);
        BlockPos pos9 = new BlockPos(x - 1, y + 1, z - 1);
        if (!(world.m_8055_(pos1).m_60815_() || world.m_8055_(pos2).m_60815_() || world.m_8055_(pos3).m_60815_() || world.m_8055_(pos4).m_60815_() || world.m_8055_(pos5).m_60815_() || world.m_8055_(pos6).m_60815_() || world.m_8055_(pos7).m_60815_() || world.m_8055_(pos8).m_60815_() || world.m_8055_(pos9).m_60815_())) {
            AABB scanAbove = new AABB((double)(x - 0), (double)(y - 0), (double)(z - 0), (double)(x + 1), (double)(y + 1), (double)(z + 1));
            List entities = player.m_20193_().m_45976_(Entity.class, scanAbove);
            if (entities.isEmpty()) {
                RoverEntity rover = new RoverEntity((EntityType)ModInit.ROVER.get(), world);
                rover.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
                double d0 = RoverItem.getYOffset((LevelReader)world, pos, true, rover.m_142469_());
                float f = player.m_146908_();
                rover.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + d0, (double)pos.m_123343_() + 0.5, f, 0.0f);
                rover.f_19859_ = f;
                world.m_7967_((Entity)rover);
                rover.m_20088_().m_135381_(RoverEntity.FUEL, (Object)itemStack.m_41784_().m_128451_(fuelTag));
                if (!player.m_150110_().f_35937_) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                } else {
                    player.m_21011_(context.m_43724_(), true);
                }
                RoverItem.roverPlaceSound(pos, world);
            }
        }
        return super.m_6225_(context);
    }

    @Override
    public void fillItemCategoryAlt(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.m_41389_(p_41391_)) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            itemStack.m_41784_().m_128405_(fuelTag, 3000);
            p_41392_.add((Object)itemStack);
        }
    }

    public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (p_41391_ != ItemGroups.tab_normal) {
            super.m_6787_(p_41391_, p_41392_);
        }
    }

    @Override
    public void itemCategoryAlt(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.m_41389_(p_41391_)) {
            p_41392_.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public static void roverPlaceSound(BlockPos pos, Level world) {
        world.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

