/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.block.RocketLaunchPad;
import net.mrscauthd.beyond_earth.entity.RocketTier3Entity;
import net.mrscauthd.beyond_earth.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.item.FilledAltVehicleItem;
import net.mrscauthd.beyond_earth.item.VehicleItem;
import net.mrscauthd.beyond_earth.itemgroup.ItemGroups;
import org.jetbrains.annotations.Nullable;

public class Tier3RocketItem
extends VehicleItem
implements FilledAltVehicleItem {
    public static String fuelTag = "beyond_earth:fuel";
    public static String bucketTag = "beyond_earth:buckets";

    public Tier3RocketItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack itemstack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        int fuel = itemstack.m_41784_().m_128451_(fuelTag) / 3;
        list.add((Component)GaugeTextHelper.buildBlockTooltip(GaugeTextHelper.getPercentText(GaugeValueHelper.getFuel(fuel, 100))));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = world.m_8055_(pos);
        InteractionHand hand = context.m_43724_();
        ItemStack itemStack = context.m_43722_();
        if (world.m_5776_()) {
            return InteractionResult.PASS;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (state.m_60734_() instanceof RocketLaunchPad && ((Boolean)state.m_61143_((Property)RocketLaunchPad.STAGE)).booleanValue()) {
            BlockPos pos1 = new BlockPos(x, y + 1, z);
            BlockPos pos2 = new BlockPos(x, y + 2, z);
            BlockPos pos3 = new BlockPos(x, y + 3, z);
            BlockPos pos4 = new BlockPos(x, y + 4, z);
            if (world.m_8055_(pos1).m_60795_() && world.m_8055_(pos2).m_60795_() && world.m_8055_(pos3).m_60795_() && world.m_8055_(pos4).m_60795_()) {
                AABB scanAbove = new AABB((double)(x - 0), (double)(y - 0), (double)(z - 0), (double)(x + 1), (double)(y + 1), (double)(z + 1));
                List entities = player.m_20193_().m_45976_(Entity.class, scanAbove);
                if (entities.isEmpty()) {
                    RocketTier3Entity rocket = new RocketTier3Entity((EntityType)ModInit.TIER_3_ROCKET.get(), world);
                    rocket.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
                    double d0 = Tier3RocketItem.getYOffset((LevelReader)world, pos, true, rocket.m_142469_());
                    rocket.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + d0, (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
                    rocket.f_19859_ = rocket.m_146908_();
                    world.m_7967_((Entity)rocket);
                    rocket.m_20088_().m_135381_(RocketTier3Entity.FUEL, (Object)itemStack.m_41784_().m_128451_(fuelTag));
                    rocket.m_20088_().m_135381_(RocketTier3Entity.BUCKETS, (Object)itemStack.m_41784_().m_128451_(bucketTag));
                    if (!player.m_150110_().f_35937_) {
                        player.m_21008_(hand, ItemStack.f_41583_);
                    } else {
                        player.m_21011_(context.m_43724_(), true);
                    }
                    Tier3RocketItem.rocketPlaceSound(pos, world);
                }
            }
        }
        return super.m_6225_(context);
    }

    @Override
    public void fillItemCategoryAlt(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.m_41389_(p_41391_)) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            itemStack.m_41784_().m_128405_(fuelTag, 300);
            p_41392_.add((Object)itemStack);
        }
    }

    public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (p_41391_ != ItemGroups.tab_normal) {
            super.m_6787_(p_41391_, p_41392_);
        }
    }

    @Override
    public void itemCategoryAlt(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.m_41389_(p_41391_)) {
            p_41392_.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public static void rocketPlaceSound(BlockPos pos, Level world) {
        world.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

