/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.capability.oxygen.OxygenUtil;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeTypes;
import net.mrscauthd.beyond_earth.crafting.CompressingRecipe;
import net.mrscauthd.beyond_earth.crafting.FuelRefiningRecipe;
import net.mrscauthd.beyond_earth.crafting.GeneratingRecipe;
import net.mrscauthd.beyond_earth.crafting.IngredientStack;
import net.mrscauthd.beyond_earth.crafting.OxygenBubbleDistributorRecipe;
import net.mrscauthd.beyond_earth.crafting.OxygenLoaderRecipe;
import net.mrscauthd.beyond_earth.crafting.RocketPart;
import net.mrscauthd.beyond_earth.crafting.SpaceStationRecipe;
import net.mrscauthd.beyond_earth.crafting.WorkbenchingRecipe;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.fluid.FluidUtil2;
import net.mrscauthd.beyond_earth.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.gui.helper.GridPlacer;
import net.mrscauthd.beyond_earth.gui.helper.GuiHelper;
import net.mrscauthd.beyond_earth.gui.helper.IPlacer;
import net.mrscauthd.beyond_earth.gui.helper.RocketPartGridPlacer;
import net.mrscauthd.beyond_earth.gui.screens.coalgenerator.CoalGeneratorGui;
import net.mrscauthd.beyond_earth.gui.screens.coalgenerator.CoalGeneratorGuiWindow;
import net.mrscauthd.beyond_earth.gui.screens.compressor.CompressorGui;
import net.mrscauthd.beyond_earth.gui.screens.compressor.CompressorGuiWindow;
import net.mrscauthd.beyond_earth.gui.screens.fuelrefinery.FuelRefineryGui;
import net.mrscauthd.beyond_earth.gui.screens.fuelrefinery.FuelRefineryGuiWindow;
import net.mrscauthd.beyond_earth.gui.screens.nasaworkbench.NasaWorkbenchGui;
import net.mrscauthd.beyond_earth.gui.screens.nasaworkbench.NasaWorkbenchGuiWindow;
import net.mrscauthd.beyond_earth.gui.screens.oxygenbubbledistributor.OxygenBubbleDistributorGui;
import net.mrscauthd.beyond_earth.gui.screens.oxygenbubbledistributor.OxygenBubbleDistributorGuiWindow;
import net.mrscauthd.beyond_earth.gui.screens.oxygenloader.OxygenLoaderGui;
import net.mrscauthd.beyond_earth.gui.screens.oxygenloader.OxygenLoaderGuiWindow;
import net.mrscauthd.beyond_earth.gui.screens.planetselection.PlanetSelectionGuiWindow;
import net.mrscauthd.beyond_earth.gui.screens.rocket.RocketGui;
import net.mrscauthd.beyond_earth.gui.screens.rocket.RocketGuiWindow;
import net.mrscauthd.beyond_earth.gui.screens.rover.RoverGuiWindow;
import net.mrscauthd.beyond_earth.jei.jeiguihandlers.CoalGeneratorGuiContainerHandler;
import net.mrscauthd.beyond_earth.jei.jeiguihandlers.CompressorGuiContainerHandler;
import net.mrscauthd.beyond_earth.jei.jeiguihandlers.PlanetSlecetionGuiJeiHandler;
import net.mrscauthd.beyond_earth.jei.jeiguihandlers.RocketGuiContainerHandler;
import net.mrscauthd.beyond_earth.jei.jeiguihandlers.RoverGuiContainerHandler;
import net.mrscauthd.beyond_earth.machines.tile.NASAWorkbenchBlockEntity;
import net.mrscauthd.beyond_earth.util.Rectangle2d;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelper;
    private Map<Fluid, List<ItemStack>> fluidFullItemStacks;
    private List<ItemStack> oxygenFullItemStacks;
    private List<Fluid> fuelTagFluids;

    private ClientLevel getLevel() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91073_;
    }

    public List<ItemStack> getFluidFullItemStacks(Fluid fluid) {
        return this.fluidFullItemStacks.computeIfAbsent(fluid, this::generateFluidFullIngredients);
    }

    public List<ItemStack> getFluidFullItemStacks(Collection<Fluid> fluids) {
        return fluids.stream().flatMap(f -> this.getFluidFullItemStacks((Fluid)f).stream()).collect(Collectors.toList());
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("beyond_earth", "default");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        int inventorySlotCount = 36;
        registration.addRecipeTransferHandler(OxygenLoaderGui.GuiContainer.class, OxygenLoaderJeiCategory.Uid, 0, 1, 0, inventorySlotCount);
        registration.addRecipeTransferHandler(OxygenBubbleDistributorGui.GuiContainer.class, OxygenBubbleDistributorJeiCategory.Uid, 0, 1, 0, inventorySlotCount);
        registration.addRecipeTransferHandler(CoalGeneratorGui.GuiContainer.class, CoalGeneratorJeiCategory.Uid, 0, 1, 1, inventorySlotCount);
        registration.addRecipeTransferHandler(CompressorGui.GuiContainer.class, CompressorJeiCategory.Uid, 0, 1, 2, inventorySlotCount);
        int workbenchPartSlotStart = 1;
        int workbenchPartSlotCount = NASAWorkbenchBlockEntity.getBasicPartSlots();
        registration.addRecipeTransferHandler(NasaWorkbenchGui.GuiContainer.class, NASAWorkbenchJeiCategory.Uid, workbenchPartSlotStart, workbenchPartSlotCount, workbenchPartSlotStart + workbenchPartSlotCount, inventorySlotCount);
        registration.addRecipeTransferHandler(FuelRefineryGui.GuiContainer.class, FuelRefineryJeiCategory.Uid, 0, 1, 0, inventorySlotCount);
        registration.addRecipeTransferHandler(RocketGui.GuiContainer.class, RocketTier1JeiCategory.Uid, 0, 1, 0, inventorySlotCount);
        registration.addRecipeTransferHandler(RocketGui.GuiContainer.class, RocketTier2JeiCategory.Uid, 0, 1, 0, inventorySlotCount);
        registration.addRecipeTransferHandler(RocketGui.GuiContainer.class, RocketTier3JeiCategory.Uid, 0, 1, 0, inventorySlotCount);
        registration.addRecipeTransferHandler(RocketGui.GuiContainer.class, RocketTier4JeiCategory.Uid, 0, 1, 0, inventorySlotCount);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(NasaWorkbenchGuiWindow.class, 108, 49, 14, 14, new ResourceLocation[]{NASAWorkbenchJeiCategory.Uid});
        registration.addGuiContainerHandler(CoalGeneratorGuiWindow.class, (IGuiContainerHandler)new CoalGeneratorGuiContainerHandler());
        registration.addRecipeClickArea(FuelRefineryGuiWindow.class, 48, 36, 24, 17, new ResourceLocation[]{FuelRefineryJeiCategory.Uid});
        registration.addGuiContainerHandler(CompressorGuiWindow.class, (IGuiContainerHandler)new CompressorGuiContainerHandler());
        registration.addRecipeClickArea(OxygenLoaderGuiWindow.class, 48, 36, 24, 17, new ResourceLocation[]{OxygenLoaderJeiCategory.Uid});
        registration.addRecipeClickArea(OxygenBubbleDistributorGuiWindow.class, 48, 36, 24, 17, new ResourceLocation[]{OxygenBubbleDistributorJeiCategory.Uid});
        registration.addGuiContainerHandler(RocketGuiWindow.class, (IGuiContainerHandler)new RocketGuiContainerHandler());
        registration.addGuiContainerHandler(RoverGuiWindow.class, (IGuiContainerHandler)new RoverGuiContainerHandler());
        registration.addGuiContainerHandler(PlanetSelectionGuiWindow.class, (IGuiContainerHandler)new PlanetSlecetionGuiJeiHandler());
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        jeiHelper = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new OxygenLoaderJeiCategory(this, jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new OxygenBubbleDistributorJeiCategory(this, jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CoalGeneratorJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new NASAWorkbenchJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RocketTier1JeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RocketTier2JeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RocketTier3JeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RocketTier4JeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CompressorJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FuelRefineryJeiCategory(this, jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RoverJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SpaceStationJeiCategory(jeiHelper.getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.fluidFullItemStacks = new HashMap<Fluid, List<ItemStack>>();
        this.oxygenFullItemStacks = this.generateOxygenLoadingItems();
        this.fuelTagFluids = this.generateFuelTagFluids();
        registration.addRecipes(this.generateOxygenLoaderRecipes(), OxygenLoaderJeiCategory.Uid);
        registration.addRecipes(this.generateOxygenBubbleDistributorRecipes(), OxygenBubbleDistributorJeiCategory.Uid);
        registration.addRecipes(this.generateGeneratorRecipes(), CoalGeneratorJeiCategory.Uid);
        registration.addRecipes(this.generateWorkbenchRecipes(), NASAWorkbenchJeiCategory.Uid);
        registration.addRecipes(this.generateFuelLoadingRecipes(), RocketTier1JeiCategory.Uid);
        registration.addRecipes(this.generateFuelLoadingRecipes(), RocketTier2JeiCategory.Uid);
        registration.addRecipes(this.generateFuelLoadingRecipes(), RocketTier3JeiCategory.Uid);
        registration.addRecipes(this.generateFuelLoadingRecipes(), RocketTier4JeiCategory.Uid);
        registration.addRecipes(this.generateFuelLoadingRecipes(), RoverJeiCategory.Uid);
        registration.addRecipes(this.generateCompressingRecipes(), CompressorJeiCategory.Uid);
        registration.addRecipes(this.generateFuelMakerRecipes(), FuelRefineryJeiCategory.Uid);
        registration.addRecipes(this.generateSpaceStationRecipes(), SpaceStationJeiCategory.Uid);
        TranslatableComponent oilDescriptionKey = new TranslatableComponent("jei.tooltip.beyond_earth.oil");
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModInit.OIL_BUCKET.get(), 1), VanillaTypes.ITEM, new Component[]{oilDescriptionKey});
        registration.addIngredientInfo((Object)new FluidStack((Fluid)ModInit.OIL_STILL.get(), 1000), VanillaTypes.FLUID, new Component[]{oilDescriptionKey});
    }

    private List<ItemStack> generateOxygenLoadingItems() {
        return ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(OxygenUtil::canReceive).map(OxygenUtil::makeFull).collect(Collectors.toList());
    }

    private List<OxygenLoaderRecipe> generateOxygenLoaderRecipes() {
        return BeyondEarthRecipeTypes.OXYGENLOADER.getRecipes((Level)this.getLevel());
    }

    private List<OxygenBubbleDistributorRecipe> generateOxygenBubbleDistributorRecipes() {
        return BeyondEarthRecipeTypes.OXYGENBUBBLEDISTRIBUTOR.getRecipes((Level)this.getLevel());
    }

    private List<GeneratingRecipe> generateGeneratorRecipes() {
        return BeyondEarthRecipeTypes.GENERATING.getRecipes((Level)this.getLevel());
    }

    private List<WorkbenchingRecipe> generateWorkbenchRecipes() {
        return BeyondEarthRecipeTypes.WORKBENCHING.getRecipes((Level)this.getLevel());
    }

    private List<CompressingRecipe> generateCompressingRecipes() {
        return BeyondEarthRecipeTypes.COMPRESSING.getRecipes((Level)this.getLevel());
    }

    private List<ItemStack> generateFluidFullIngredients(Fluid fluid) {
        return ForgeRegistries.ITEMS.getValues().stream().map(i -> new ItemStack((ItemLike)i)).filter(is -> FluidUtil2.canFill(is, fluid)).map(is -> FluidUtil2.makeFull(is, fluid)).collect(Collectors.toList());
    }

    private List<FuelRefiningRecipe> generateFuelMakerRecipes() {
        return BeyondEarthRecipeTypes.FUELREFINING.getRecipes((Level)this.getLevel());
    }

    private List<Fluid> generateFuelTagFluids() {
        return ForgeRegistries.FLUIDS.getValues().stream().filter(f -> f.m_7444_(f.m_76145_()) && Methods.tagCheck(f, ModInit.FLUID_VEHICLE_FUEL_TAG)).collect(Collectors.toList());
    }

    private List<FuelLoadingRecipe> generateFuelLoadingRecipes() {
        ArrayList<ItemStack> fuelTagBuckets = new ArrayList<ItemStack>();
        for (Fluid fluid : this.fuelTagFluids) {
            fuelTagBuckets.add(new ItemStack((ItemLike)fluid.m_6859_()));
        }
        FuelLoadingRecipe recipe = new FuelLoadingRecipe(fuelTagBuckets, this.fuelTagFluids);
        ArrayList<FuelLoadingRecipe> recipes = new ArrayList<FuelLoadingRecipe>();
        recipes.add(recipe);
        return recipes;
    }

    private List<SpaceStationRecipe> generateSpaceStationRecipes() {
        ArrayList<SpaceStationRecipe> recipes = new ArrayList<SpaceStationRecipe>();
        this.getLevel().m_7465_().m_44043_(SpaceStationRecipe.KEY).ifPresent(r -> recipes.add((SpaceStationRecipe)r));
        return recipes;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModInit.OXYGEN_LOADER_BLOCK.get()), new ResourceLocation[]{OxygenLoaderJeiCategory.Uid});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModInit.OXYGEN_BUBBLE_DISTRIBUTOR_BLOCK.get()), new ResourceLocation[]{OxygenBubbleDistributorJeiCategory.Uid});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModInit.COAL_GENERATOR_BLOCK.get()), new ResourceLocation[]{CoalGeneratorJeiCategory.Uid});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModInit.NASA_WORKBENCH_ITEM.get()), new ResourceLocation[]{NASAWorkbenchJeiCategory.Uid});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModInit.COMPRESSOR_BLOCK.get()), new ResourceLocation[]{CompressorJeiCategory.Uid});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModInit.FUEL_REFINERY_BLOCK.get()), new ResourceLocation[]{FuelRefineryJeiCategory.Uid});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModInit.TIER_1_ROCKET_ITEM.get()), new ResourceLocation[]{RocketTier1JeiCategory.Uid, SpaceStationJeiCategory.Uid});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModInit.TIER_2_ROCKET_ITEM.get()), new ResourceLocation[]{RocketTier2JeiCategory.Uid, SpaceStationJeiCategory.Uid});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModInit.TIER_3_ROCKET_ITEM.get()), new ResourceLocation[]{RocketTier3JeiCategory.Uid, SpaceStationJeiCategory.Uid});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModInit.TIER_4_ROCKET_ITEM.get()), new ResourceLocation[]{RocketTier4JeiCategory.Uid, SpaceStationJeiCategory.Uid});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModInit.ROVER_ITEM.get()), new ResourceLocation[]{RoverJeiCategory.Uid});
    }

    public static int placeRcketParts(int slot, int left, int top, int mod, IPlacer placer, RocketPart part, IRecipeLayout iRecipeLayout, WorkbenchingRecipe recipe) {
        IGuiItemStackGroup stacks = iRecipeLayout.getItemStacks();
        List<Ingredient> ingredients = recipe.getParts().get((Object)part);
        return RocketPartGridPlacer.place(slot, left, top, mod, placer, part, (i, s, bounds) -> {
            Ingredient ingredient = ingredients != null && i < ingredients.size() ? (Ingredient)ingredients.get((int)i) : Ingredient.f_43901_;
            stacks.init(s.intValue(), true, bounds.getX(), bounds.getY());
            stacks.set(s.intValue(), (List)Lists.newArrayList((Object[])ingredient.m_43908_()));
        });
    }

    public static IDrawableStatic createFireStatic(IGuiHelper guiHelper) {
        return JeiPlugin.drawableBuilder(guiHelper, GuiHelper.FIRE_PATH, 14, 14).build();
    }

    public static IDrawableAnimated createFireAnimated(IGuiHelper guiHelper) {
        return JeiPlugin.createFireAnimated(guiHelper, 200);
    }

    public static IDrawableAnimated createFireAnimated(IGuiHelper guiHelper, int ticks) {
        return JeiPlugin.createFireAnimated(guiHelper, JeiPlugin.createFireStatic(guiHelper), ticks);
    }

    public static IDrawableAnimated createFireAnimated(IGuiHelper guiHelper, IDrawableStatic fireStatic, int ticks) {
        return guiHelper.createAnimatedDrawable(fireStatic, ticks, IDrawableAnimated.StartDirection.TOP, true);
    }

    public static IDrawableBuilder drawableBuilder(IGuiHelper guiHelper, ResourceLocation path, int width, int height) {
        return guiHelper.drawableBuilder(path, 0, 0, width, height).setTextureSize(width, height);
    }

    public static LoadingCache<Integer, IDrawableAnimated> createFires(final IGuiHelper guiHelper) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer time) {
                return JeiPlugin.drawableBuilder(guiHelper, GuiHelper.FIRE_PATH, 14, 14).buildAnimated(time.intValue(), IDrawableAnimated.StartDirection.TOP, true);
            }
        });
    }

    public static LoadingCache<Integer, IDrawableAnimated> createArrows(final IGuiHelper guiHelper) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer time) {
                return JeiPlugin.drawableBuilder(guiHelper, GuiHelper.ARROW_PATH, 24, 17).buildAnimated(time.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public static LoadingCache<Integer, IDrawableAnimated> createEnergies(final IGuiHelper guiHelper, final boolean inverted) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer time) {
                return JeiPlugin.drawableBuilder(guiHelper, GuiHelper.ENERGY_PATH, 24, 48).buildAnimated(time.intValue(), inverted ? IDrawableAnimated.StartDirection.TOP : IDrawableAnimated.StartDirection.BOTTOM, inverted);
            }
        });
    }

    public static LoadingCache<Integer, IDrawableAnimated> createUsingEnergies(IGuiHelper guiHelper) {
        return JeiPlugin.createEnergies(guiHelper, true);
    }

    public static LoadingCache<Integer, IDrawableAnimated> createGeneratingEnergies(IGuiHelper guiHelper) {
        return JeiPlugin.createEnergies(guiHelper, false);
    }

    public static void drawText(PoseStack stack, IDrawable background, String text) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int stringWidth = font.m_92895_(text);
        float f = background.getWidth() - 5 - stringWidth;
        int n = background.getHeight();
        Objects.requireNonNull(font);
        font.m_92883_(stack, text, f, (float)(n - 9 - 5), 0x808080);
    }

    public static void drawTextTime(PoseStack stack, IDrawable background, int ticks) {
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(2);
        String text = numberInstance.format((float)ticks / 20.0f) + "s";
        JeiPlugin.drawText(stack, background, text);
    }

    public static class OxygenLoaderJeiCategory
    implements IRecipeCategory<OxygenLoaderRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "oxygen_loader");
        public static final int INPUT_TANK_LEFT = 8;
        public static final int INPUT_TANK_TOP = 8;
        public static final int OUTPUT_TANK_LEFT = 74;
        public static final int OUTPUT_TANK_TOP = 8;
        public static final int ENERGY_LEFT = 114;
        public static final int ENERGY_TOP = 8;
        private final JeiPlugin plugin;
        private final Component title;
        private final IDrawable background;
        private final IDrawable fluidOverlay;
        private final LoadingCache<Integer, IDrawableAnimated> cachedEnergies;

        public OxygenLoaderJeiCategory(JeiPlugin plugin, IGuiHelper guiHelper) {
            this.plugin = plugin;
            this.title = new TranslatableComponent("container.beyond_earth.oxygen_loader");
            this.background = guiHelper.createDrawable(new ResourceLocation("beyond_earth", "textures/jei/oxygen_loader_jei.png"), 0, 0, 148, 64);
            this.fluidOverlay = guiHelper.drawableBuilder(GuiHelper.FLUID_TANK_PATH, 0, 0, 14, 48).setTextureSize(14, 48).build();
            this.cachedEnergies = JeiPlugin.createUsingEnergies(guiHelper);
        }

        public List<Component> getTooltipStrings(OxygenLoaderRecipe recipe, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getUsingPerTickText(GaugeValueHelper.getEnergy(1)).build());
            }
            if (GuiHelper.isHover(this.getOutputTankBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getValueText(GaugeValueHelper.getOxygen(recipe.getOxygen())).build());
            }
            return Collections.emptyList();
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends OxygenLoaderRecipe> getRecipeClass() {
            return OxygenLoaderRecipe.class;
        }

        public Component getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public void draw(OxygenLoaderRecipe recipe, PoseStack stack, double mouseX, double mouseY) {
            super.draw((Object)recipe, stack, mouseX, mouseY);
            ((IDrawableAnimated)this.cachedEnergies.getUnchecked((Object)200)).draw(stack, 114, 8);
            GuiHelper.drawOxygenTank(stack, 74, 8, 1.0);
        }

        public void setIngredients(OxygenLoaderRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputs(VanillaTypes.ITEM, this.plugin.getFluidFullItemStacks(recipe.getInput().getFluids()));
            iIngredients.setOutputs(VanillaTypes.ITEM, this.plugin.oxygenFullItemStacks);
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getInput().toStacks()));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, OxygenLoaderRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 24, 8);
            itemStacks.init(1, false, 90, 38);
            itemStacks.init(2, false, 24, 38);
            itemStacks.init(3, false, 90, 8);
            itemStacks.set(0, iIngredients.getInputs(VanillaTypes.ITEM).stream().flatMap(Collection::stream).collect(Collectors.toList()));
            itemStacks.set(1, iIngredients.getOutputs(VanillaTypes.ITEM).stream().flatMap(Collection::stream).collect(Collectors.toList()));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            int tanks = 0;
            fluidStacks.init(tanks, true, 8, 8, 14, 48, 1, false, this.fluidOverlay);
            fluidStacks.set(tanks, iIngredients.getInputs(VanillaTypes.FLUID).stream().flatMap(Collection::stream).collect(Collectors.toList()));
            ++tanks;
        }

        public Rectangle2d getInputTankBounds() {
            return GuiHelper.getFluidTankBounds(8, 8);
        }

        public Rectangle2d getOutputTankBounds() {
            return GuiHelper.getFluidTankBounds(74, 8);
        }

        public Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(114, 8);
        }
    }

    public static class OxygenBubbleDistributorJeiCategory
    implements IRecipeCategory<OxygenBubbleDistributorRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "oxygen_bubble_distributor");
        public static final int INPUT_TANK_LEFT = 8;
        public static final int INPUT_TANK_TOP = 8;
        public static final int OUTPUT_TANK_LEFT = 74;
        public static final int OUTPUT_TANK_TOP = 8;
        public static final int ENERGY_LEFT = 114;
        public static final int ENERGY_TOP = 8;
        private final JeiPlugin plugin;
        private final Component title;
        private final IDrawable background;
        private final IDrawable fluidOverlay;
        private final LoadingCache<Integer, IDrawableAnimated> cachedEnergies;

        public OxygenBubbleDistributorJeiCategory(JeiPlugin plugin, IGuiHelper guiHelper) {
            this.plugin = plugin;
            this.title = new TranslatableComponent("container.beyond_earth.oxygen_bubble_distributor");
            this.background = guiHelper.createDrawable(new ResourceLocation("beyond_earth", "textures/jei/oxygen_bubble_distributor_jei.png"), 0, 0, 148, 64);
            this.fluidOverlay = guiHelper.drawableBuilder(GuiHelper.FLUID_TANK_PATH, 0, 0, 14, 48).setTextureSize(14, 48).build();
            this.cachedEnergies = JeiPlugin.createUsingEnergies(guiHelper);
        }

        public List<Component> getTooltipStrings(OxygenBubbleDistributorRecipe recipe, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getUsingPerTickText(GaugeValueHelper.getEnergy(1)).build());
            }
            if (GuiHelper.isHover(this.getOutputTankBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getValueText(GaugeValueHelper.getOxygen(recipe.getOxygen())).build());
            }
            return Collections.emptyList();
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends OxygenBubbleDistributorRecipe> getRecipeClass() {
            return OxygenBubbleDistributorRecipe.class;
        }

        public Component getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public void draw(OxygenBubbleDistributorRecipe recipe, PoseStack stack, double mouseX, double mouseY) {
            super.draw((Object)recipe, stack, mouseX, mouseY);
            ((IDrawableAnimated)this.cachedEnergies.getUnchecked((Object)200)).draw(stack, 114, 8);
            GuiHelper.drawOxygenTank(stack, 74, 8, 1.0);
        }

        public void setIngredients(OxygenBubbleDistributorRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputs(VanillaTypes.ITEM, this.plugin.getFluidFullItemStacks(recipe.getInput().getFluids()));
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getInput().toStacks()));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, OxygenBubbleDistributorRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 24, 8);
            itemStacks.init(2, false, 24, 38);
            itemStacks.set(0, iIngredients.getInputs(VanillaTypes.ITEM).stream().flatMap(Collection::stream).collect(Collectors.toList()));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            int tanks = 0;
            fluidStacks.init(tanks, true, 8, 8, 14, 48, 1, false, this.fluidOverlay);
            fluidStacks.set(tanks, iIngredients.getInputs(VanillaTypes.FLUID).stream().flatMap(Collection::stream).collect(Collectors.toList()));
            ++tanks;
        }

        public Rectangle2d getInputTankBounds() {
            return GuiHelper.getFluidTankBounds(8, 8);
        }

        public Rectangle2d getOutputTankBounds() {
            return GuiHelper.getFluidTankBounds(74, 8);
        }

        public Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(114, 8);
        }
    }

    public static class CoalGeneratorJeiCategory
    implements IRecipeCategory<GeneratingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "coal_generator");
        public static final int FIRE_LEFT = 45;
        public static final int FIRE_TOP = 45;
        public static final int ENERGY_LEFT = 103;
        public static final int ENERGY_TOP = 15;
        private final Component title = new TranslatableComponent("container.beyond_earth.coal_generator");
        private final IDrawable background;
        private final LoadingCache<Integer, IDrawableAnimated> fires;
        private final LoadingCache<Integer, IDrawableAnimated> energies;

        public CoalGeneratorJeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(new ResourceLocation("beyond_earth", "textures/jei/generator_gui_jei.png"), 0, 0, 144, 84);
            this.fires = JeiPlugin.createFires(guiHelper);
            this.energies = JeiPlugin.createGeneratingEnergies(guiHelper);
        }

        public List<Component> getTooltipStrings(GeneratingRecipe recipe, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getFireBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getValueText(GaugeValueHelper.getBurnTime(recipe.getBurnTime())).build());
            }
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getGeneratingPerTickText(GaugeValueHelper.getEnergy(2)).build());
            }
            return Collections.emptyList();
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends GeneratingRecipe> getRecipeClass() {
            return GeneratingRecipe.class;
        }

        public Component getTitle() {
            return this.title;
        }

        public Rectangle2d getFireBounds() {
            return GuiHelper.getFireBounds(45, 45);
        }

        public Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(103, 15);
        }

        public void draw(GeneratingRecipe recipe, PoseStack stack, double mouseX, double mouseY) {
            super.draw((Object)recipe, stack, mouseX, mouseY);
            int burnTime = recipe.getBurnTime();
            ((IDrawableAnimated)this.fires.getUnchecked((Object)burnTime)).draw(stack, 45, 45);
            ((IDrawableAnimated)this.energies.getUnchecked((Object)200)).draw(stack, 103, 15);
            JeiPlugin.drawTextTime(stack, this.getBackground(), burnTime);
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public void setIngredients(GeneratingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputIngredients(recipe.m_7527_());
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, GeneratingRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup stacks = iRecipeLayout.getItemStacks();
            stacks.init(0, true, 44, 25);
            stacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
        }
    }

    public static class CompressorJeiCategory
    implements IRecipeCategory<CompressingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "compressor");
        public static final int ARROW_LEFT = 36;
        public static final int ARROW_TOP = 29;
        public static final int ENERGY_LEFT = 103;
        public static final int ENERGY_TOP = 15;
        private final Component title = new TranslatableComponent("container.beyond_earth.compressor");
        private final IDrawable background;
        private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;
        private final LoadingCache<Integer, IDrawableAnimated> cachedEnergies;

        public CompressorJeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(new ResourceLocation("beyond_earth", "textures/jei/compressor_gui_jei.png"), 0, 0, 144, 84);
            this.cachedArrows = JeiPlugin.createArrows(guiHelper);
            this.cachedEnergies = JeiPlugin.createUsingEnergies(guiHelper);
        }

        public List<Component> getTooltipStrings(CompressingRecipe recipe, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getUsingPerTickText(GaugeValueHelper.getEnergy(1)).build());
            }
            return Collections.emptyList();
        }

        private Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(103, 15);
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends CompressingRecipe> getRecipeClass() {
            return CompressingRecipe.class;
        }

        public Component getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public void draw(CompressingRecipe recipe, PoseStack stack, double mouseX, double mouseY) {
            super.draw((Object)recipe, stack, mouseX, mouseY);
            int cookTime = recipe.getCookTime();
            ((IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime)).draw(stack, 36, 29);
            ((IDrawableAnimated)this.cachedEnergies.getUnchecked((Object)cookTime)).draw(stack, 103, 15);
            JeiPlugin.drawTextTime(stack, this.getBackground(), cookTime);
        }

        public IDrawable getIcon() {
            return null;
        }

        public void setIngredients(CompressingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputIngredients(recipe.m_7527_());
            iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, CompressingRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup stacks = iRecipeLayout.getItemStacks();
            stacks.init(0, true, 14, 29);
            stacks.init(1, false, 69, 28);
            stacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
            stacks.set(1, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
    }

    public static class NASAWorkbenchJeiCategory
    implements IRecipeCategory<WorkbenchingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "nasa_workbench");
        private final Component title = new TranslatableComponent("container.beyond_earth.nasa_workbench");
        private final IDrawable background;

        public NASAWorkbenchJeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(new ResourceLocation("beyond_earth", "textures/jei/nasaworkbenchjei.png"), 0, 0, 176, 122);
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends WorkbenchingRecipe> getRecipeClass() {
            return WorkbenchingRecipe.class;
        }

        public Component getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public void setIngredients(WorkbenchingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputIngredients(recipe.m_7527_());
            iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, WorkbenchingRecipe recipe, IIngredients iIngredients) {
            IDrawable background = this.getBackground();
            iRecipeLayout.moveRecipeTransferButton(background.getWidth() - 20, background.getHeight() - 20);
            int slots = 0;
            GridPlacer placer = new GridPlacer();
            slots = JeiPlugin.placeRcketParts(slots, 38, 7, 1, placer::placeBottom, (RocketPart)ModInit.ROCKET_PART_NOSE.get(), iRecipeLayout, recipe);
            slots = JeiPlugin.placeRcketParts(slots, 29, 25, 2, placer::placeBottom, (RocketPart)ModInit.ROCKET_PART_BODY.get(), iRecipeLayout, recipe);
            slots = JeiPlugin.placeRcketParts(slots, 29, 79, 1, placer::placeRight, (RocketPart)ModInit.ROCKET_PART_TANK.get(), iRecipeLayout, recipe);
            slots = JeiPlugin.placeRcketParts(slots, 11, 79, 1, placer::placeBottom, (RocketPart)ModInit.ROCKET_PART_FIN_LEFT.get(), iRecipeLayout, recipe);
            slots = JeiPlugin.placeRcketParts(slots, 65, 79, 1, placer::placeBottom, (RocketPart)ModInit.ROCKET_PART_FIN_RIGHT.get(), iRecipeLayout, recipe);
            slots = JeiPlugin.placeRcketParts(slots, 38, 97, 1, placer::placeBottom, (RocketPart)ModInit.ROCKET_PART_ENGINE.get(), iRecipeLayout, recipe);
            IGuiItemStackGroup stacks = iRecipeLayout.getItemStacks();
            stacks.init(slots, false, 126, 72);
            stacks.set(slots, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(0));
            ++slots;
        }
    }

    public static class FuelRefineryJeiCategory
    implements IRecipeCategory<FuelRefiningRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "fuel_refinery");
        public static final int INPUT_TANK_LEFT = 8;
        public static final int INPUT_TANK_TOP = 8;
        public static final int OUTPUT_TANK_LEFT = 74;
        public static final int OUTPUT_TANK_TOP = 8;
        public static final int ENERGY_LEFT = 114;
        public static final int ENERGY_TOP = 8;
        private final JeiPlugin plugin;
        private final Component title;
        private final IDrawable background;
        private final IDrawable fluidOverlay;
        private final LoadingCache<Integer, IDrawableAnimated> cachedEnergies;

        public FuelRefineryJeiCategory(JeiPlugin plugin, IGuiHelper guiHelper) {
            this.plugin = plugin;
            this.title = new TranslatableComponent("container.beyond_earth.fuel_refinery");
            this.background = guiHelper.createDrawable(new ResourceLocation("beyond_earth", "textures/jei/fuel_refinery_jei.png"), 0, 0, 148, 64);
            this.fluidOverlay = guiHelper.drawableBuilder(GuiHelper.FLUID_TANK_PATH, 0, 0, 14, 48).setTextureSize(14, 48).build();
            this.cachedEnergies = JeiPlugin.createUsingEnergies(guiHelper);
        }

        public List<Component> getTooltipStrings(FuelRefiningRecipe recipe, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getUsingPerTickText(GaugeValueHelper.getEnergy(1)).build());
            }
            return Collections.emptyList();
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelRefiningRecipe> getRecipeClass() {
            return FuelRefiningRecipe.class;
        }

        public Component getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public void draw(FuelRefiningRecipe recipe, PoseStack stack, double mouseX, double mouseY) {
            super.draw((Object)recipe, stack, mouseX, mouseY);
            ((IDrawableAnimated)this.cachedEnergies.getUnchecked((Object)200)).draw(stack, 114, 8);
        }

        public void setIngredients(FuelRefiningRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputs(VanillaTypes.ITEM, this.plugin.getFluidFullItemStacks(recipe.getInput().getFluids()));
            iIngredients.setOutputs(VanillaTypes.ITEM, this.plugin.getFluidFullItemStacks(recipe.getOutput().getFluids()));
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getInput().toStacks()));
            iIngredients.setOutputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getOutput().toStacks()));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, FuelRefiningRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 24, 8);
            itemStacks.init(1, false, 90, 38);
            itemStacks.init(2, false, 24, 38);
            itemStacks.init(3, false, 90, 8);
            itemStacks.set(0, iIngredients.getInputs(VanillaTypes.ITEM).stream().flatMap(i -> i.stream()).collect(Collectors.toList()));
            itemStacks.set(1, iIngredients.getOutputs(VanillaTypes.ITEM).stream().flatMap(i -> i.stream()).collect(Collectors.toList()));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            int tanks = 0;
            fluidStacks.init(tanks, true, 8, 8, 14, 48, 1, false, this.fluidOverlay);
            fluidStacks.set(tanks, (List)iIngredients.getInputs(VanillaTypes.FLUID).get(0));
            fluidStacks.init(++tanks, false, 74, 8, 14, 48, 1, false, this.fluidOverlay);
            fluidStacks.set(tanks, (List)iIngredients.getOutputs(VanillaTypes.FLUID).get(0));
            ++tanks;
        }

        public Rectangle2d getInputTankBounds() {
            return GuiHelper.getFluidTankBounds(8, 8);
        }

        public Rectangle2d getOutputTankBounds() {
            return GuiHelper.getFluidTankBounds(74, 8);
        }

        public Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(114, 8);
        }
    }

    public static class RocketTier1JeiCategory
    implements IRecipeCategory<FuelLoadingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "rocket_t1");
        private final Component title = ((EntityType)ModInit.TIER_1_ROCKET.get()).m_20676_();
        private final IDrawable background;
        private final IDrawable icon;

        public RocketTier1JeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(new ResourceLocation("beyond_earth", "textures/jei/rocket_gui_jei.png"), 0, 0, 128, 71);
            this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)ModInit.TIER_1_ROCKET_ITEM.get()));
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelLoadingRecipe> getRecipeClass() {
            return FuelLoadingRecipe.class;
        }

        public Component getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }

        public void setIngredients(FuelLoadingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getFuelTagBuckets()));
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getFluidStacks(1000)));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, FuelLoadingRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 13, 18);
            itemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            fluidStacks.init(0, true, 66, 12, 46, 46, 1000, false, null);
            fluidStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.FLUID).get(0));
        }
    }

    public static class RocketTier2JeiCategory
    implements IRecipeCategory<FuelLoadingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "rocket_t2");
        private final Component title = ((EntityType)ModInit.TIER_2_ROCKET.get()).m_20676_();
        private final IDrawable background;
        private final IDrawable icon;

        public RocketTier2JeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(new ResourceLocation("beyond_earth", "textures/jei/rocket_gui_jei.png"), 0, 0, 128, 71);
            this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)ModInit.TIER_2_ROCKET_ITEM.get()));
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelLoadingRecipe> getRecipeClass() {
            return FuelLoadingRecipe.class;
        }

        public Component getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }

        public void setIngredients(FuelLoadingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getFuelTagBuckets()));
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getFluidStacks(3000)));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, FuelLoadingRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 13, 18);
            itemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            fluidStacks.init(0, true, 66, 12, 46, 46, 3000, false, null);
            fluidStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.FLUID).get(0));
        }
    }

    public static class RocketTier3JeiCategory
    implements IRecipeCategory<FuelLoadingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "rocket_t3");
        private final Component title = ((EntityType)ModInit.TIER_3_ROCKET.get()).m_20676_();
        private final IDrawable background;
        private final IDrawable icon;

        public RocketTier3JeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(new ResourceLocation("beyond_earth", "textures/jei/rocket_gui_jei.png"), 0, 0, 128, 71);
            this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)ModInit.TIER_3_ROCKET_ITEM.get()));
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelLoadingRecipe> getRecipeClass() {
            return FuelLoadingRecipe.class;
        }

        public Component getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }

        public void setIngredients(FuelLoadingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getFuelTagBuckets()));
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getFluidStacks(3000)));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, FuelLoadingRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 13, 18);
            itemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            fluidStacks.init(0, true, 66, 12, 46, 46, 3000, false, null);
            fluidStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.FLUID).get(0));
        }
    }

    public static class RocketTier4JeiCategory
    implements IRecipeCategory<FuelLoadingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "rocket_t4");
        private final Component title = ((EntityType)ModInit.TIER_4_ROCKET.get()).m_20676_();
        private final IDrawable background;
        private final IDrawable icon;

        public RocketTier4JeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(new ResourceLocation("beyond_earth", "textures/jei/rocket_gui_jei.png"), 0, 0, 128, 71);
            this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)ModInit.TIER_4_ROCKET_ITEM.get()));
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelLoadingRecipe> getRecipeClass() {
            return FuelLoadingRecipe.class;
        }

        public Component getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }

        public void setIngredients(FuelLoadingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getFuelTagBuckets()));
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getFluidStacks(3000)));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, FuelLoadingRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 13, 18);
            itemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            fluidStacks.init(0, true, 66, 12, 46, 46, 3000, false, null);
            fluidStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.FLUID).get(0));
        }
    }

    public static class RoverJeiCategory
    implements IRecipeCategory<FuelLoadingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "rover");
        private final Component title = ((EntityType)ModInit.ROVER.get()).m_20676_();
        private final IDrawable background;
        private final IDrawable fluidOverlay;

        public RoverJeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(new ResourceLocation("beyond_earth", "textures/jei/rover_jei.png"), 0, 0, 144, 84);
            this.fluidOverlay = guiHelper.drawableBuilder(GuiHelper.FLUID_TANK_PATH, 0, 0, 14, 48).setTextureSize(14, 48).build();
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelLoadingRecipe> getRecipeClass() {
            return FuelLoadingRecipe.class;
        }

        public Component getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public void setIngredients(FuelLoadingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getFuelTagBuckets()));
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getFluidStacks(3000)));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, FuelLoadingRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 7, 59);
            itemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            fluidStacks.init(0, true, 9, 8, 14, 48, 3000, false, this.fluidOverlay);
            fluidStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.FLUID).get(0));
        }
    }

    public static class SpaceStationJeiCategory
    implements IRecipeCategory<SpaceStationRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "space_station");
        public static final ResourceLocation BACKGROUND = new ResourceLocation("beyond_earth", "textures/jei/space_station_background.png");
        public static final ResourceLocation ICON = new ResourceLocation("beyond_earth", "textures/jei/space_station_icon.png");
        public static final int SLOTS_X_CENTER = 72;
        public static final int SLOTS_Y_TOP = 6;
        public static final int SLOTS_X_OFFSET = 18;
        public static final int SLOTS_Y_OFFSET = 18;
        private final Component title;
        private final Component[] tooltips;
        private final IDrawable background;
        private final IDrawable icon;
        private final IDrawable slot;

        public SpaceStationJeiCategory(IGuiHelper guiHelper) {
            String path = "beyond_earth.space_station";
            this.title = new TranslatableComponent("jei.category." + path);
            this.tooltips = (Component[])Arrays.stream(new TranslatableComponent("jei.tooltip." + path).getString().split("\n")).map(TextComponent::new).toArray(Component[]::new);
            this.background = guiHelper.createDrawable(BACKGROUND, 0, 0, 144, 51);
            this.icon = guiHelper.drawableBuilder(ICON, 0, 0, 16, 16).setTextureSize(16, 16).build();
            this.slot = guiHelper.getSlotDrawable();
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends SpaceStationRecipe> getRecipeClass() {
            return SpaceStationRecipe.class;
        }

        public Component getTitle() {
            return this.title;
        }

        public Component[] getTooltip() {
            return this.tooltips;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }

        public void setIngredients(SpaceStationRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputIngredients(recipe.m_7527_());
        }

        public int[] getSpaceStationItemPosition(int index, int count) {
            int xIndex = index % count;
            int yIndex = index / count;
            int slots_width = count * 18;
            int xPosition = 72 + xIndex * 18 - slots_width / 2;
            int yPosition = 6 + yIndex * 18;
            return new int[]{xPosition, yPosition};
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, SpaceStationRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            NonNullList<IngredientStack> ingredientStacks = recipe.getIngredientStacks();
            int count = ingredientStacks.size();
            for (int i = 0; i < count; ++i) {
                int[] pos = this.getSpaceStationItemPosition(i, count);
                IngredientStack ingredientStack = (IngredientStack)ingredientStacks.get(i);
                itemStacks.init(i, true, pos[0], pos[1]);
                itemStacks.set(i, (List)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])ingredientStack.getItems()));
            }
        }

        public void draw(SpaceStationRecipe recipe, PoseStack stack, double mouseX, double mouseY) {
            super.draw((Object)recipe, stack, mouseX, mouseY);
            NonNullList<IngredientStack> ingredientStacks = recipe.getIngredientStacks();
            int count = ingredientStacks.size();
            for (int i = 0; i < count; ++i) {
                int[] pos = this.getSpaceStationItemPosition(i, count);
                this.slot.draw(stack, pos[0], pos[1]);
            }
            Minecraft minecraft = Minecraft.m_91087_();
            Font font = minecraft.f_91062_;
            int tooltipYOffset = this.getSpaceStationItemPosition(ingredientStacks.size() - 1, count)[1] + 18 + 4;
            Component[] tooltips = this.getTooltip();
            for (int i = 0; i < tooltips.length; ++i) {
                Component tooltip = tooltips[i];
                int tooltipWidth = font.m_92852_((FormattedText)tooltip);
                float f = 72 - tooltipWidth / 2;
                Objects.requireNonNull(font);
                font.m_92889_(stack, tooltip, f, (float)(tooltipYOffset + 9 * i), -12566464);
            }
        }
    }

    public static class FuelLoadingRecipe {
        private final List<ItemStack> fuelTagBuckets;
        private final List<Fluid> fluids;

        public FuelLoadingRecipe(List<ItemStack> fuelTagBuckets, List<Fluid> fluids) {
            this.fuelTagBuckets = Collections.unmodifiableList(fuelTagBuckets);
            this.fluids = Collections.unmodifiableList(fluids);
        }

        public List<ItemStack> getFuelTagBuckets() {
            return this.fuelTagBuckets;
        }

        public List<FluidStack> getFluidStacks(int amount) {
            return this.getFluid().stream().map(f -> new FluidStack(f, amount)).collect(Collectors.toList());
        }

        public List<Fluid> getFluid() {
            return this.fluids;
        }
    }
}

