/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.machines.tile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeType;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeTypes;
import net.mrscauthd.beyond_earth.crafting.RocketPart;
import net.mrscauthd.beyond_earth.crafting.WorkbenchingRecipe;
import net.mrscauthd.beyond_earth.gui.screens.nasaworkbench.NasaWorkbenchGui;
import net.mrscauthd.beyond_earth.inventory.ItemHandlerHelper2;
import net.mrscauthd.beyond_earth.inventory.RocketPartsItemHandler;
import net.mrscauthd.beyond_earth.inventory.StackCacher;
import net.mrscauthd.beyond_earth.machines.tile.AbstractMachineBlockEntity;

public class NASAWorkbenchBlockEntity
extends AbstractMachineBlockEntity {
    public static final int SLOT_PARTS = 0;
    private StackCacher itemStackCacher = new StackCacher();
    private WorkbenchingRecipe cachedRecipe = null;
    private List<WorkbenchingRecipe> possibleRecipes = new ArrayList<WorkbenchingRecipe>();
    private Set<ItemStack> invalidCache = new HashSet<ItemStack>();
    private int prevRedstone = 0;
    private int currRedstone = 0;
    private RocketPartsItemHandler partsItemHandler;

    public static List<RocketPart> getBasicPartOrders() {
        ArrayList<RocketPart> parts = new ArrayList<RocketPart>();
        parts.add((RocketPart)ModInit.ROCKET_PART_NOSE.get());
        parts.add((RocketPart)ModInit.ROCKET_PART_BODY.get());
        parts.add((RocketPart)ModInit.ROCKET_PART_TANK.get());
        parts.add((RocketPart)ModInit.ROCKET_PART_FIN_LEFT.get());
        parts.add((RocketPart)ModInit.ROCKET_PART_FIN_RIGHT.get());
        parts.add((RocketPart)ModInit.ROCKET_PART_ENGINE.get());
        return parts;
    }

    public static int getBasicPartSlots() {
        return NASAWorkbenchBlockEntity.getBasicPartOrders().stream().collect(Collectors.summingInt(p -> p.getSlots()));
    }

    public NASAWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModInit.NASA_WORKBENCH.get(), pos, state);
    }

    public RocketPartsItemHandler getPartsItemHandler() {
        return this.partsItemHandler;
    }

    public List<RocketPart> getPartOrders() {
        return NASAWorkbenchBlockEntity.getBasicPartOrders();
    }

    public int getPartsSlot() {
        return 0;
    }

    @Override
    protected void createItemHandlers() {
        super.createItemHandlers();
        this.partsItemHandler = new RocketPartsItemHandler(this.getItemHandler(), this.getPartsSlot(), this.getPartOrders());
    }

    @Override
    protected int getInitialInventorySize() {
        return super.getInitialInventorySize() + this.getPartsItemHandler().getSlots();
    }

    public void m_6836_(int p_59616_, ItemStack p_59617_) {
        super.m_6836_(p_59616_, p_59617_);
        this.cacheRecipes();
    }

    public AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new NasaWorkbenchGui.GuiContainer(id, inventory, this);
    }

    @Override
    protected void getSlotsForFace(Direction direction, List<Integer> slots) {
        super.getSlotsForFace(direction, slots);
        RocketPartsItemHandler partsItemHandler = this.getPartsItemHandler();
        for (int i = 0; i < partsItemHandler.getSlots(); ++i) {
            slots.add(partsItemHandler.getParentSlotIndex(i));
        }
    }

    @Override
    protected boolean onCanPlaceItemThroughFace(int index, ItemStack stack, Direction direction) {
        if (super.onCanPlaceItemThroughFace(index, stack, direction)) {
            return true;
        }
        if (direction == null) {
            return true;
        }
        int find = this.findAvailableSlot(stack);
        return find == index;
    }

    public int findAvailableSlot(ItemStack itemStack) {
        this.cacheRecipes();
        ItemStack single = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1);
        if (this.invalidCache.contains(single)) {
            return -1;
        }
        for (WorkbenchingRecipe recipe : this.possibleRecipes) {
            int slot = this.findAvailableSlot(recipe, itemStack);
            if (slot == -1) continue;
            return slot;
        }
        this.invalidCache.add(single);
        return -1;
    }

    public int findAvailableSlot(WorkbenchingRecipe recipe, ItemStack itemStack) {
        Map<RocketPart, List<Ingredient>> recipeParts = recipe.getParts();
        RocketPartsItemHandler partsItemHandler = this.getPartsItemHandler();
        for (Map.Entry<RocketPart, IItemHandlerModifiable> entry : partsItemHandler.getSubHandlers().entrySet()) {
            RocketPart part = entry.getKey();
            IItemHandlerModifiable subHandler = entry.getValue();
            List<Ingredient> ingredients = recipeParts.get((Object)part);
            if (ingredients == null) continue;
            for (int i = 0; i < ingredients.size(); ++i) {
                if (!ingredients.get(i).test(itemStack) || !subHandler.getStackInSlot(i).m_41619_()) continue;
                return partsItemHandler.getParentSlotIndex(part, i);
            }
        }
        return -1;
    }

    public WorkbenchingRecipe cacheRecipes() {
        RocketPartsItemHandler partsItemHandler = this.getPartsItemHandler();
        NonNullList<ItemStack> stacks = ItemHandlerHelper2.getStacks((IItemHandler)partsItemHandler);
        if (!this.itemStackCacher.test((Collection<? extends Object>)stacks)) {
            this.itemStackCacher.set((Collection<? extends Object>)stacks);
            BeyondEarthRecipeType<WorkbenchingRecipe> recipeType = this.getRecipeType();
            this.cachedRecipe = recipeType.findFirst(this.m_58904_(), r -> r.test(partsItemHandler, false));
            this.possibleRecipes.clear();
            recipeType.filter(this.m_58904_(), r -> r.test(partsItemHandler, true)).forEach(this.possibleRecipes::add);
            this.invalidCache.clear();
        }
        return this.cachedRecipe;
    }

    public BeyondEarthRecipeType<WorkbenchingRecipe> getRecipeType() {
        return BeyondEarthRecipeTypes.WORKBENCHING;
    }

    @Override
    protected void tickProcessing() {
        this.spawnParticles();
        this.updateRedstoneState();
        if (this.prevRedstone == 0 && this.currRedstone > 0) {
            this.outputToBottom();
        }
    }

    protected void updateRedstoneState() {
        this.prevRedstone = this.currRedstone;
        this.currRedstone = this.m_58904_().m_46755_(this.m_58899_());
    }

    protected void outputToBottom() {
        WorkbenchingRecipe recipe = this.cacheRecipes();
        if (recipe == null) {
            return;
        }
        IItemHandler bottomItemHandler = this.getBottomBlockEntityItemHandler();
        if (bottomItemHandler == null) {
            return;
        }
        ItemStack output = recipe.getOutput();
        if (ItemHandlerHelper.insertItem((IItemHandler)bottomItemHandler, (ItemStack)output, (boolean)true).m_41619_()) {
            ItemHandlerHelper.insertItem((IItemHandler)bottomItemHandler, (ItemStack)output, (boolean)false);
            this.consumeIngredient();
        }
    }

    private IItemHandler getBottomBlockEntityItemHandler() {
        BlockEntity bottomBlockEntity = this.m_58904_().m_7702_(this.m_58899_().m_7495_());
        if (bottomBlockEntity != null) {
            return (IItemHandler)bottomBlockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        }
        return null;
    }

    protected void spawnParticles() {
        Level level;
        if (this.possibleRecipes.size() > 0 && !ItemHandlerHelper2.isEmpty((IItemHandler)this.getPartsItemHandler()) && (level = this.m_58904_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, 10, 0.1, 0.1, 0.1, 0.1);
        }
    }

    public boolean consumeIngredient() {
        WorkbenchingRecipe recipe = this.cacheRecipes();
        if (recipe == null) {
            return false;
        }
        RocketPartsItemHandler partsItemHandler = this.getPartsItemHandler();
        for (RocketPart part : recipe.getParts().keySet()) {
            IItemHandlerModifiable subHandler = partsItemHandler.getSubHandlers().get((Object)part);
            for (int i = 0; i < part.getSlots(); ++i) {
                subHandler.extractItem(i, 1, false);
            }
        }
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            serverLevel.m_5594_(null, pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.totem.use")), SoundSource.NEUTRAL, 1.0f, 1.0f);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123767_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, 100, 0.1, 0.1, 0.1, 0.7);
        }
        return true;
    }

    @Override
    public boolean hasSpaceInOutput() {
        return true;
    }
}

