/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.machines.tile;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.mrscauthd.beyond_earth.capability.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.capability.oxygen.IOxygenStorageHolder;
import net.mrscauthd.beyond_earth.capability.oxygen.OxygenStorage;
import net.mrscauthd.beyond_earth.compat.CompatibleManager;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeType;
import net.mrscauthd.beyond_earth.crafting.OxygenMakingRecipeAbstract;
import net.mrscauthd.beyond_earth.fluid.FluidUtil2;
import net.mrscauthd.beyond_earth.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.gauge.IGaugeValue;
import net.mrscauthd.beyond_earth.inventory.StackCacher;
import net.mrscauthd.beyond_earth.machines.tile.AbstractMachineBlockEntity;
import net.mrscauthd.beyond_earth.machines.tile.NamedComponentRegistry;

public abstract class OxygenMakingBlockEntity
extends AbstractMachineBlockEntity {
    public static final int TANK_CAPACITY = 3000;
    public static final int TRANSFER_PER_TICK = 256;
    public static final ResourceLocation TANK_INPUT = new ResourceLocation("beyond_earth", "input");
    public static final ResourceLocation TANK_OUTPUT = new ResourceLocation("beyond_earth", "output");
    public static final int SLOT_INPUT_SOURCE = 0;
    public static final int SLOT_INPUT_SINK = 1;
    private FluidTank inputTank;
    private OxygenStorage outputTank;
    private StackCacher recipeCacher = new StackCacher();
    private OxygenMakingRecipeAbstract cachedRecipe = null;

    public OxygenMakingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.getOutputTank().deserializeNBT((Tag)compound.m_128469_("outputTank"));
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("outputTank", this.getOutputTank().serializeNBT());
    }

    @Override
    public List<IGaugeValue> getGaugeValues() {
        List<IGaugeValue> list = super.getGaugeValues();
        if (!CompatibleManager.MEKANISM.isLoaded()) {
            list.add(GaugeValueHelper.getOxygen(this.getOutputTank()));
        }
        return list;
    }

    @Override
    protected void createFluidHandlers(NamedComponentRegistry<IFluidHandler> registry) {
        super.createFluidHandlers(registry);
        this.inputTank = (FluidTank)registry.computeIfAbsent(this.getInputTankName(), k -> this.creatFluidTank((ResourceLocation)k));
        this.outputTank = this.createOxygenTank(this.getOutputTankName());
    }

    protected int getInitialTankCapacity(ResourceLocation name) {
        return 3000;
    }

    protected FluidTank creatFluidTank(ResourceLocation name) {
        return new FluidTank(this.getInitialTankCapacity(name)){

            protected void onContentsChanged() {
                super.onContentsChanged();
                OxygenMakingBlockEntity.this.m_6596_();
            }
        };
    }

    protected OxygenStorage createOxygenTank(ResourceLocation name) {
        return new OxygenStorage(new IOxygenStorageHolder(){

            @Override
            public void onOxygenChanged(IOxygenStorage oxygenStorage, int oxygenDelta) {
                OxygenMakingBlockEntity.this.m_6596_();
            }
        }, this.getInitialTankCapacity(name));
    }

    @Override
    protected void tickProcessing() {
        this.drainSources();
        this.consumeIngredients();
        this.fillSinks();
    }

    public boolean consumeIngredients() {
        int oxygen;
        OxygenMakingRecipeAbstract recipe = this.cacheRecipe();
        if (recipe != null && this.hasSpaceInOutput(oxygen = recipe.getOxygen()) && this.consumePowerForOperation() != null) {
            this.getInputTank().drain(recipe.getInput().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            this.getOutputTank().receiveOxygen(oxygen, false);
            this.setProcessedInThisTick();
            return true;
        }
        return false;
    }

    protected void drainSources() {
        FluidUtil2.drainSource(this.getItemHandler(), this.getInputSourceSlot(), (IFluidHandler)this.getInputTank(), this.getTransferPerTick());
    }

    protected void fillSinks() {
        FluidUtil2.fillSink(this.getItemHandler(), this.getInputSinkSlot(), (IFluidHandler)this.getInputTank(), this.getTransferPerTick());
    }

    @Override
    public <T> LazyOptional<T> getCapabilityFluidHandler(Capability<T> capability, @Nullable Direction facing) {
        return LazyOptional.of(this::getInputTank).cast();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (CompatibleManager.MEKANISM.isLoaded()) {
            // empty if block
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void getSlotsForFace(Direction direction, List<Integer> slots) {
        super.getSlotsForFace(direction, slots);
        slots.add(this.getInputSourceSlot());
    }

    @Override
    protected boolean onCanPlaceItemThroughFace(int index, ItemStack stack, Direction direction) {
        if (index == this.getInputSourceSlot()) {
            return FluidUtil2.canDrain(stack);
        }
        if (index == this.getInputSinkSlot()) {
            FluidTank tank = this.slotToFluidTank(index);
            return FluidUtil2.canFill(stack, tank.getFluid().getFluid());
        }
        return super.onCanPlaceItemThroughFace(index, stack, direction);
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        if (index == this.getInputSourceSlot()) {
            return !FluidUtil2.canDrain(stack);
        }
        if (index == this.getInputSinkSlot()) {
            FluidTank tank = this.slotToFluidTank(index);
            return !FluidUtil2.canFill(stack, tank.getFluid().getFluid());
        }
        return super.m_7157_(index, stack, direction);
    }

    @Override
    public boolean hasSpaceInOutput() {
        OxygenMakingRecipeAbstract recipe = this.cacheRecipe();
        return recipe != null && this.hasSpaceInOutput(recipe.getOxygen());
    }

    public boolean hasSpaceInOutput(int oxygen) {
        return this.hasSpaceInOutput(oxygen, this.getOutputTank());
    }

    public boolean hasSpaceInOutput(int oxygen, IOxygenStorage storage) {
        return oxygen + storage.getOxygenStored() <= storage.getMaxOxygenStored();
    }

    public OxygenMakingRecipeAbstract cacheRecipe() {
        FluidStack fluidStack = this.getInputTank().getFluid();
        if (fluidStack.isEmpty()) {
            this.recipeCacher.set(fluidStack);
            this.cachedRecipe = null;
        } else if (!this.recipeCacher.test(fluidStack)) {
            this.recipeCacher.set(fluidStack);
            this.cachedRecipe = this.getRecipeType().findFirst(this.m_58904_(), r -> r.test(fluidStack));
        }
        return this.cachedRecipe;
    }

    public abstract BeyondEarthRecipeType<? extends OxygenMakingRecipeAbstract> getRecipeType();

    @Override
    protected int getInitialInventorySize() {
        return super.getInitialInventorySize() + 2;
    }

    public int m_6893_() {
        return 1;
    }

    public int getInputSourceSlot() {
        return 0;
    }

    public int getInputSinkSlot() {
        return 1;
    }

    public boolean isSourceSlot(int slot) {
        return slot == this.getInputSourceSlot();
    }

    public boolean isSinkSlot(int slot) {
        return slot == this.getInputSinkSlot();
    }

    public FluidTank slotToFluidTank(int slot) {
        if (slot == this.getInputSourceSlot() || slot == this.getInputSinkSlot()) {
            return this.getInputTank();
        }
        return null;
    }

    public IOxygenStorage slotToOxygenTank(int slot) {
        return null;
    }

    public ResourceLocation slotToTankName(int slot) {
        if (slot == this.getInputSourceSlot() || slot == this.getInputSinkSlot()) {
            return this.getInputTankName();
        }
        return null;
    }

    public ResourceLocation getInputTankName() {
        return TANK_INPUT;
    }

    public FluidTank getInputTank() {
        return this.inputTank;
    }

    public ResourceLocation getOutputTankName() {
        return TANK_OUTPUT;
    }

    public IOxygenStorage getOutputTank() {
        return this.outputTank;
    }

    public int getTransferPerTick() {
        return 256;
    }
}

