/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.machines.tile;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.mrscauthd.beyond_earth.inventory.StackCacher;
import net.mrscauthd.beyond_earth.machines.tile.AbstractMachineBlockEntity;
import net.mrscauthd.beyond_earth.machines.tile.PowerSystem;

public abstract class PowerSystemFuel
extends PowerSystem {
    private final int slot;
    private int fuel;
    private int maxFuel;
    private StackCacher itemStackCacher;
    private int cachedFuel;

    public PowerSystemFuel(AbstractMachineBlockEntity blockEntity, int slot) {
        super(blockEntity);
        this.slot = slot;
        this.fuel = 0;
        this.maxFuel = 0;
        this.itemStackCacher = new StackCacher();
        this.cachedFuel = 0;
    }

    @Override
    public int getUsingSlots() {
        return this.getSlot() == -1 ? 0 : 1;
    }

    @Override
    public int receive(int amount, boolean simulate) {
        int received = Math.min(this.getCapacity() - this.getStored(), Math.max(amount, 0));
        if (!simulate) {
            this.fuel += received;
            this.getBlockEntity().m_6596_();
        }
        return received;
    }

    @Override
    public int extract(int amount, boolean simulate) {
        int extracted = Math.min(this.getStored(), Math.max(amount, 0));
        if (!simulate) {
            this.fuel -= extracted;
            this.getBlockEntity().m_6596_();
        }
        return extracted;
    }

    @Override
    public int getStored() {
        return this.fuel;
    }

    @Override
    public int getCapacity() {
        return this.maxFuel;
    }

    public boolean canFeed(boolean spareForNextTick, ItemStack fuel) {
        return this.getBlockEntity().hasSpaceInOutput();
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.fuel = compound.m_128451_("fuel");
        this.maxFuel = compound.m_128451_("maxFuel");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128405_("fuel", this.fuel);
        compound.m_128405_("maxFuel", this.maxFuel);
        return compound;
    }

    protected abstract int getFuelInternal(ItemStack var1);

    public final int getFuel(ItemStack fuel) {
        if (fuel == null || fuel.m_41619_()) {
            this.itemStackCacher.set(fuel);
            this.cachedFuel = -1;
        } else if (!this.itemStackCacher.test(fuel)) {
            this.itemStackCacher.set(fuel);
            this.cachedFuel = this.getFuelInternal(fuel);
        }
        return this.cachedFuel;
    }

    @Override
    public boolean feed(boolean spareForNextTick) {
        int fuel;
        if (!spareForNextTick) {
            return false;
        }
        int slot = this.getSlot();
        if (slot == -1) {
            return false;
        }
        IItemHandlerModifiable itemHandler = this.getItemHandler();
        ItemStack fuelItemStack = itemHandler.getStackInSlot(slot);
        if (!fuelItemStack.m_41619_() && this.canFeed(spareForNextTick, fuelItemStack) && (fuel = this.getFuel(fuelItemStack)) > 0) {
            itemHandler.extractItem(slot, 1, false);
            this.addFuel(fuel);
            return true;
        }
        return false;
    }

    public void setFuel(int fuel) {
        this.maxFuel = fuel = Math.max(fuel, 0);
        this.receive(fuel, false);
    }

    public void addFuel(int fuel) {
        fuel = Math.max(fuel, 0);
        this.maxFuel = this.getStored() + fuel;
        this.receive(fuel, false);
    }

    public boolean matchDirection(Direction direction) {
        return direction == null || direction != Direction.UP && direction != Direction.DOWN;
    }

    @Override
    public void getSlotsForFace(Direction direction, List<Integer> slots) {
        if (this.matchDirection(direction)) {
            slots.add(this.getSlot());
        }
    }

    @Override
    public boolean canInsertItem(@Nullable Direction direction, int index, ItemStack stack) {
        return this.matchDirection(direction) && index == this.getSlot() && this.getFuel(stack) > 0;
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.getBlockEntity().getItemHandler();
    }

    public int getSlot() {
        return this.slot;
    }

    @Override
    public ResourceLocation getName() {
        return new ResourceLocation("beyond_earth", "fuel");
    }
}

