/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.mixin;

import net.minecraft.world.entity.item.ItemEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.events.forgeevents.ItemGravityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class MixinItemGravity {
    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void tick(CallbackInfo info) {
        ItemEntity w = (ItemEntity)this;
        if (MixinItemGravity.GravityCheckItem(w)) {
            if (Methods.isWorld(w.f_19853_, Methods.moon)) {
                MixinItemGravity.itemGravityMath(w, 0.05);
            }
            if (Methods.isWorld(w.f_19853_, Methods.mars)) {
                MixinItemGravity.itemGravityMath(w, 0.06);
            }
            if (Methods.isWorld(w.f_19853_, Methods.mercury)) {
                MixinItemGravity.itemGravityMath(w, 0.05);
            }
            if (Methods.isWorld(w.f_19853_, Methods.venus)) {
                MixinItemGravity.itemGravityMath(w, 0.06);
            }
            if (Methods.isWorld(w.f_19853_, Methods.glacio)) {
                MixinItemGravity.itemGravityMath(w, 0.06);
            }
            if (Methods.isOrbitWorld(w.f_19853_)) {
                MixinItemGravity.itemGravityMath(w, 0.05);
            }
        }
    }

    private static boolean GravityCheckItem(ItemEntity entity) {
        return !entity.m_20069_() && !entity.m_20077_() && !entity.m_20068_();
    }

    private static void itemGravityMath(ItemEntity entity, double gravity) {
        if (MinecraftForge.EVENT_BUS.post((Event)new ItemGravityEvent(entity))) {
            return;
        }
        entity.m_20334_(entity.m_20184_().f_82479_, entity.m_20184_().f_82480_ / 0.98 + 0.08 - gravity, entity.m_20184_().f_82481_);
    }
}

