/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.world.structure.configuration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.mrscauthd.beyond_earth.world.structure.AlienVillageStructure;
import net.mrscauthd.beyond_earth.world.structure.CrimsonStructure;
import net.mrscauthd.beyond_earth.world.structure.MeteorStructure;
import net.mrscauthd.beyond_earth.world.structure.OilStructure;
import net.mrscauthd.beyond_earth.world.structure.VenusBulletStructure;
import net.mrscauthd.beyond_earth.world.structure.VenusTowerStructure;

public class STStructures {
    public static final DeferredRegister<StructureFeature<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"beyond_earth");
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> ALIEN_VILLAGE = DEFERRED_REGISTRY_STRUCTURE.register("alien_village", () -> new AlienVillageStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> METEOR = DEFERRED_REGISTRY_STRUCTURE.register("meteor", () -> new MeteorStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> OIL = DEFERRED_REGISTRY_STRUCTURE.register("oil_well", () -> new OilStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> VENUS_BULLET = DEFERRED_REGISTRY_STRUCTURE.register("venus_bullet", () -> new VenusBulletStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> VENUS_TOWER = DEFERRED_REGISTRY_STRUCTURE.register("venus_tower", () -> new VenusTowerStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> CRIMSON = DEFERRED_REGISTRY_STRUCTURE.register("crimson_village", () -> new CrimsonStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));

    public static void setupStructures() {
        STStructures.setupMapSpacingAndLand((StructureFeature)ALIEN_VILLAGE.get(), new StructureFeatureConfiguration(29, 9, 1234567890), false);
        STStructures.setupMapSpacingAndLand((StructureFeature)METEOR.get(), new StructureFeatureConfiguration(22, 5, 1234567890), false);
        STStructures.setupMapSpacingAndLand((StructureFeature)OIL.get(), new StructureFeatureConfiguration(13, 8, 1234567890), false);
        STStructures.setupMapSpacingAndLand((StructureFeature)VENUS_BULLET.get(), new StructureFeatureConfiguration(29, 19, 1234567890), true);
        STStructures.setupMapSpacingAndLand((StructureFeature)VENUS_TOWER.get(), new StructureFeatureConfiguration(24, 17, 1234567890), true);
        STStructures.setupMapSpacingAndLand((StructureFeature)CRIMSON.get(), new StructureFeatureConfiguration(27, 14, 1234567890), false);
    }

    public static <F extends StructureFeature<?>> void setupMapSpacingAndLand(F structure, StructureFeatureConfiguration structureFeatureConfiguration, boolean transformSurroundingLand) {
        StructureFeature.f_67012_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add(structure).build();
        }
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put(structure, (Object)structureFeatureConfiguration).build();
        BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
            Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(structureMap);
                tempMap.put(structure, structureFeatureConfiguration);
                ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_ = tempMap;
            } else {
                structureMap.put(structure, structureFeatureConfiguration);
            }
        });
    }
}

